/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.testCases;

import ca.mcgill.mcb.pcingola.snpSift.hwe.VcfHwe;
import junit.framework.TestCase;
import org.junit.Assert;

public class TestCasesHwe
extends TestCase {
    public static boolean verbose = false;

    public void test_01() {
        VcfHwe vcfHwe = new VcfHwe();
        double pchi2 = vcfHwe.hwePchi2(452, 184, 120);
        Assert.assertEquals(0.14201030881111387, pchi2, 1.0E-4);
    }

    public void test_02() {
        VcfHwe vcfHwe = new VcfHwe();
        double p = vcfHwe.hwePn12(452, 184, 120);
        Assert.assertEquals(0.03532606464457993, p, 1.0E-4);
    }

    public void test_02_table_1() {
        if (verbose) {
            System.out.println(" Calculate P[ n12 | n1, n2] according to Table 1 in the paper 'A Note on Exact test of Hardy Weinberg Equilibrium', G. Abecasis et. al.");
        }
        VcfHwe vcfHwe = new VcfHwe();
        int N = 100;
        int na = 21;
        int nb = 2 * N - na;
        int[] nabs = new int[]{5, 7, 9, 11, 13, 15, 17, 19, 21};
        double[] ps = new double[]{2.1173148965188926E-8, 1.4034773028353937E-6, 4.693851868371584E-5, 8.704961646798517E-4, 0.009374574081167143, 0.05928302085614469, 0.21446504603840832, 0.40635482407275675, 0.3096036754840131};
        for (int i = 0; i < nabs.length; ++i) {
            double p = vcfHwe.hwePn12(na, nb, nabs[i]);
            if (verbose) {
                System.out.println("\tnab: " + nabs[i] + "\t\tP[ n12 | n1, n2] : " + p);
            }
            Assert.assertEquals(ps[i], p, 1.0E-10);
        }
    }

    public void test_03_page_59() {
        if (verbose) {
            System.out.println("Calculate P[ n12 | n1, n2] according to Page 59 in the 'Principles of population genetics'");
        }
        VcfHwe vcfHwe = new VcfHwe();
        int N = 8;
        int na = 8;
        int nb = 2 * N - na;
        int[] nabs = new int[]{0, 2, 4, 6, 8};
        double[] ps = new double[]{0.005439005439005438, 0.1740481740481739, 0.5221445221445218, 0.2784770784770781, 0.01989121989121986};
        for (int i = 0; i < nabs.length; ++i) {
            double p = vcfHwe.hwePn12(na, nb, nabs[i]);
            if (verbose) {
                System.out.println("\tnab: " + nabs[i] + "\t\tP[ n12 | n1, n2] : " + p);
            }
            Assert.assertEquals(ps[i], p, 1.0E-10);
        }
    }

    public void test_04_pChi2_table_1() {
        if (verbose) {
            System.out.println("Calculate P_{HWE} using Chi-square approximation");
        }
        VcfHwe vcfHwe = new VcfHwe();
        int N = 100;
        int na = 21;
        int nb = 2 * N - na;
        int[] nabs = new int[]{5, 7, 9, 11, 13, 15, 17, 19, 21};
        double[] ps = new double[]{2.14051E-13f, 3.4827685180260914E-10, 1.873274999564245E-7, 3.3630218789326705E-5, 0.002047414882462517, 0.04347121256973019, 0.33955684500144223, 0.9131457308575013, 0.2407218835565368};
        for (int i = 0; i < nabs.length; ++i) {
            double p = vcfHwe.hwePchi2(na, nb, nabs[i]);
            if (verbose) {
                System.out.println("\tnab: " + nabs[i] + "\t\tP_{HWE} : " + p);
            }
            Assert.assertEquals(ps[i], p, 1.0E-10);
        }
    }

    public void test_04_pHwe_table_1() {
        if (verbose) {
            System.out.println("Calculate P_{HWE} according to a corrected formula from 'A Note on Exact test of Hardy Weinberg Equilibrium'");
        }
        VcfHwe vcfHwe = new VcfHwe();
        int N = 100;
        int na = 21;
        int nb = 2 * N - na;
        int[] nabs = new int[]{5, 7, 9, 11, 13, 15, 17, 19, 21};
        double[] ps = new double[]{2.130704311953056E-8, 1.4247843459549242E-6, 4.8363303029670764E-5, 9.188594677095224E-4, 0.010293433548876666, 0.06957645440502136, 0.2840415004434297, 1.0, 0.5936451759274428};
        for (int i = 0; i < nabs.length; ++i) {
            double p = vcfHwe.hweP(na, nb, nabs[i]);
            if (verbose) {
                System.out.println("\tnab: " + nabs[i] + "\t\tP_{HWE} : " + p);
            }
            Assert.assertEquals(ps[i], p, 1.0E-10);
        }
    }
}

