/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.testCases;

import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdAnnotate;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesAnnotate
extends TestCase {
    public static boolean debug;
    public static boolean verbose;
    protected String[] defaultExtraArgs;

    public TestCasesAnnotate() {
        String[] memExtraArgs = new String[]{"-sorted"};
        this.defaultExtraArgs = memExtraArgs;
    }

    public List<VcfEntry> annotate(String dbFileName, String fileName, String[] extraArgs) {
        if (verbose) {
            System.out.println("Annotate: " + dbFileName + "\t" + fileName);
        }
        String[] args = this.argsList(dbFileName, fileName, extraArgs);
        SnpSiftCmdAnnotate snpSiftAnnotate = new SnpSiftCmdAnnotate(args);
        snpSiftAnnotate.setDebug(debug);
        snpSiftAnnotate.setVerbose(verbose);
        snpSiftAnnotate.setSuppressOutput(!verbose);
        List<VcfEntry> results = snpSiftAnnotate.run(true);
        Assert.assertTrue(results != null);
        Assert.assertTrue(results.size() > 0);
        return results;
    }

    public String annotateOut(String dbFileName, String fileName, String[] extraArgs) {
        if (verbose) {
            System.out.println("Annotate: " + dbFileName + "\t" + fileName);
        }
        String[] args = this.argsList(dbFileName, fileName, extraArgs);
        SnpSiftCmdAnnotate snpSift = new SnpSiftCmdAnnotate(args);
        snpSift.setDebug(debug);
        snpSift.setVerbose(verbose);
        snpSift.setSaveOutput(true);
        snpSift.run();
        return snpSift.getOutput();
    }

    public void annotateTest(String dbFileName, String fileName) {
        this.annotateTest(dbFileName, fileName, null);
    }

    public void annotateTest(String dbFileName, String fileName, String[] extraArgs) {
        List<VcfEntry> results = this.annotate(dbFileName, fileName, extraArgs);
        for (VcfEntry vcf : results) {
            String idstr = vcf.getId();
            String expectedIds = vcf.getInfo("EXP_IDS");
            if (expectedIds != null) {
                if ((expectedIds = expectedIds.replace('|', ';')).equals(".")) {
                    expectedIds = "";
                }
                Assert.assertEquals(expectedIds, idstr);
                continue;
            }
            TestCasesAnnotate.fail("EXP_IDS (expected ids) INFO field missing in " + fileName + ", entry:\n" + vcf);
        }
    }

    protected String[] argsList(String dbFileName, String fileName, String[] extraArgs) {
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.defaultExtraArgs != null) {
            for (String arg : this.defaultExtraArgs) {
                argsList.add(arg);
            }
        }
        if (extraArgs != null) {
            for (String arg : extraArgs) {
                argsList.add(arg);
            }
        }
        argsList.add(dbFileName);
        argsList.add(fileName);
        return argsList.toArray(new String[0]);
    }

    public void test_01() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_1.vcf";
        String fileName = "./test/annotate_1.vcf";
        this.annotateTest(dbFileName, fileName);
    }

    public void test_02() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_10.vcf";
        String fileName = "./test/annotate_10.vcf";
        this.annotateTest(dbFileName, fileName);
    }

    public void test_03() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_2.vcf";
        String fileName = "./test/annotate_2.vcf";
        this.annotateTest(dbFileName, fileName);
    }

    public void test_04() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_large.vcf";
        String fileName = "./test/annotate_large.vcf";
        this.annotateTest(dbFileName, fileName);
    }

    public void test_05() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_chr22.vcf";
        String fileName = "./test/test_chr22.vcf";
        this.annotateTest(dbFileName, fileName);
    }

    public void test_06() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_06.vcf";
        String fileName = "./test/annotate_06.vcf";
        List<VcfEntry> results = this.annotate(dbFileName, fileName, null);
        Assert.assertEquals("PREVIOUS=annotation;TEST=yes;ABE=0.678;ABZ=47.762;AF=0.002;AN=488;AOI=-410.122;AOZ=-399.575;IOD=0.000;OBS=4,1,1636,2011,3,1,6780,9441;RSPOS=16346045", results.get(0).getInfoStr());
    }

    public void test_07() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_06.vcf";
        String fileName = "./test/annotate_06.vcf";
        String[] extraArgs = new String[]{"-info", "AF,AN,ABE"};
        List<VcfEntry> results = this.annotate(dbFileName, fileName, extraArgs);
        Assert.assertEquals("PREVIOUS=annotation;TEST=yes;ABE=0.678;AF=0.002;AN=488", results.get(0).getInfoStr());
    }

    public void test_08() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_06.vcf";
        String fileName = "./test/annotate_06.vcf";
        String[] extraArgs = new String[]{"-noId"};
        List<VcfEntry> results = this.annotate(dbFileName, fileName, extraArgs);
        Assert.assertEquals("OLD_ID", results.get(0).getId());
    }

    public void test_09() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_09.vcf";
        String fileName = "./test/annotate_09.vcf";
        String[] extraArgs = new String[]{"-info", "GMAF,AC"};
        String out = this.annotateOut(dbFileName, fileName, extraArgs);
        boolean hasGmaf = false;
        boolean hasAc = false;
        for (String line : out.split("\n")) {
            hasGmaf |= line.startsWith("##INFO=<ID=GMAF");
            hasAc |= line.startsWith("##INFO=<ID=AC");
        }
        Assert.assertEquals(true, hasGmaf);
        Assert.assertEquals(false, hasAc);
    }

    public void test_11() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_11.vcf";
        String fileName = "./test/annotate_11.vcf";
        String[] extraArgs = new String[]{"-info", "GMAF,AC"};
        String out = this.annotateOut(dbFileName, fileName, extraArgs);
        if (verbose) {
            System.out.println(out);
        }
        int hasGmaf = 0;
        int hasAc = 0;
        for (String line : out.split("\n")) {
            if (line.startsWith("##INFO=<ID=GMAF")) {
                ++hasGmaf;
            }
            if (!line.startsWith("##INFO=<ID=AC")) continue;
            ++hasAc;
        }
        Assert.assertEquals(1, hasGmaf);
        Assert.assertEquals(0, hasAc);
    }

    public void test_12() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_12.vcf";
        String fileName = "./test/annotate_12.vcf";
        String[] extraArgs = new String[]{"-noAlt"};
        List<VcfEntry> results = this.annotate(dbFileName, fileName, extraArgs);
        Assert.assertEquals("NEW_ID", results.get(0).getId());
    }

    public void test_13() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_13.vcf";
        String fileName = "./test/annotate_13.vcf";
        String[] extraArgs = new String[]{"-info", "AA"};
        String out = this.annotateOut(dbFileName, fileName, extraArgs);
        if (verbose) {
            System.out.println(out);
        }
        int hasAa = 0;
        for (String line : out.split("\n")) {
            if (!line.startsWith("##INFO=<ID=AA")) continue;
            ++hasAa;
        }
        Assert.assertEquals(1, hasAa);
    }

    public void test_14() {
        Gpr.debug("Test");
        String dbFileName = "./test/annotate_multiple_allele.db.vcf";
        String fileName = "./test/annotate_multiple_allele.1.vcf";
        List<VcfEntry> results = this.annotate(dbFileName, fileName, null);
        VcfEntry ve = results.get(0);
        if (verbose) {
            System.out.println(ve);
        }
        String allNum = ve.getInfo("ALL_NUM");
        Assert.assertEquals("2", allNum);
    }

    public void test_15() {
        Gpr.debug("Test");
        String dbFileName = "./test/annotate_multiple_allele_R.db.vcf";
        String fileName = "./test/annotate_multiple_allele.2.vcf";
        List<VcfEntry> results = this.annotate(dbFileName, fileName, null);
        VcfEntry ve = results.get(0);
        if (verbose) {
            System.out.println(ve);
        }
        String allNum = ve.getInfo("ALL_NUM");
        Assert.assertEquals("value_REF,value_C", allNum);
    }

    public void test_16() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_16.vcf";
        String fileName = "./test/annotate_16.vcf";
        String infoName = "PREPEND_";
        String[] extraArgs = new String[]{"-name", infoName};
        List<VcfEntry> results = this.annotate(dbFileName, fileName, extraArgs);
        VcfEntry ve = results.get(0);
        String aa = ve.getInfo(infoName + "AA");
        String bb = ve.getInfo(infoName + "BB");
        Assert.assertEquals("Field_Value", aa);
        Assert.assertEquals("AnotherValue", bb);
    }

    public void test_17() {
        Gpr.debug("Test");
        String dbFileName = "./test/annotate_oder_db.vcf";
        String fileName = "./test/annotate_oder_snp.vcf";
        HashMap<String, String> types = new HashMap<String, String>();
        types.put("0", "zero");
        types.put("1", "first");
        types.put("2", "second");
        List<VcfEntry> results = this.annotate(dbFileName, fileName, null);
        for (VcfEntry ve : results) {
            String type = ve.getInfo("TYPE");
            String ann = ve.getInfo("ANN");
            if (verbose) {
                System.out.println(ve.toStr() + "\t" + type + "\t" + ann);
            }
            Assert.assertEquals((String)types.get(type), ann);
        }
    }

    public void test_18() {
        Gpr.debug("Test");
        String dbFileName = "./test/test_annotate_18_db.vcf";
        String fileName = "./test/test_annotate_18.vcf";
        List<VcfEntry> results = this.annotate(dbFileName, fileName, null);
        VcfEntry ve = results.get(0);
        String ukac = ve.getInfo("UK10KWES_AC");
        if (verbose) {
            System.out.println("Annotated value: " + ukac);
        }
        Assert.assertEquals(".,49,44,.,.,.,.,.,.,.,.", ukac);
    }

    public void test_19() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_multiline.vcf";
        String fileName = "./test/annotate_multiline.vcf";
        this.annotateTest(dbFileName, fileName);
    }

    public void test_20() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_20.vcf";
        String fileName = "./test/annotate_20.vcf";
        List<VcfEntry> results = this.annotate(dbFileName, fileName, null);
        Assert.assertEquals("44,49", results.get(0).getInfo("ANNOTATE_ONCE"));
    }

    public void test_21() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_21.vcf";
        String fileName = "./test/annotate_21.vcf";
        List<VcfEntry> results = this.annotate(dbFileName, fileName, null);
        VcfEntry ve = results.get(2);
        String ann = ve.getInfo("clinvar_db");
        if (debug) {
            Gpr.debug("Annotation: '" + ann + "'");
        }
        Assert.assertNotNull(ann);
        ve = results.get(1);
        ann = ve.getInfo("clinvar_db");
        if (debug) {
            Gpr.debug("Annotation: '" + ann + "'");
        }
        Assert.assertNotNull(ann);
    }

    public void test_22() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_2.vcf";
        String fileName = "./test/annotate_22.vcf";
        this.annotate(dbFileName, fileName, null);
    }

    public void test_23_allele_specific_annotation_missing_R() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_23.vcf";
        String fileName = "./test/annotate_23.vcf";
        List<VcfEntry> results = this.annotate(dbFileName, fileName, null);
        VcfEntry ve = results.get(0);
        String caf = ve.getInfo("CAF");
        if (verbose) {
            System.out.println(ve + "\n\tCAF: " + caf);
        }
        Assert.assertEquals("0.9642,.,0.03581", caf);
    }

    public void test_24() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_24.vcf";
        String fileName = "./test/annotate_24.vcf";
        String infoName = "PREPEND_";
        String[] extraArgs = new String[]{"-name", infoName};
        String out = this.annotateOut(dbFileName, fileName, extraArgs);
        if (verbose) {
            System.out.println(out);
        }
        int hasAa = 0;
        int hasBb = 0;
        int hasCc = 0;
        for (String line : out.split("\n")) {
            if (line.startsWith("##INFO=<ID=PREPEND_AA")) {
                ++hasAa;
            }
            if (line.startsWith("##INFO=<ID=PREPEND_BB")) {
                ++hasBb;
            }
            if (!line.startsWith("##INFO=<ID=PREPEND_CC")) continue;
            ++hasCc;
        }
        Assert.assertEquals(1, hasAa);
        Assert.assertEquals(1, hasBb);
        Assert.assertEquals(1, hasCc);
    }

    public void test_25() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_24.vcf";
        String fileName = "./test/annotate_24.vcf";
        String infoName = "PREPEND_";
        String[] extraArgs = new String[]{"-name", infoName, "-info", "AA,BB"};
        String out = this.annotateOut(dbFileName, fileName, extraArgs);
        if (verbose) {
            System.out.println(out);
        }
        int hasAa = 0;
        int hasBb = 0;
        int hasCc = 0;
        for (String line : out.split("\n")) {
            if (line.startsWith("##INFO=<ID=PREPEND_AA")) {
                ++hasAa;
            }
            if (line.startsWith("##INFO=<ID=PREPEND_BB")) {
                ++hasBb;
            }
            if (!line.startsWith("##INFO=<ID=PREPEND_CC")) continue;
            ++hasCc;
        }
        Assert.assertEquals(1, hasAa);
        Assert.assertEquals(1, hasBb);
        Assert.assertEquals(0, hasCc);
    }

    public void test_26_repeat_db_entry() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_26.vcf";
        String fileName = "./test/annotate_26.vcf";
        this.annotateTest(dbFileName, fileName);
    }

    public void test_27_repeat_db_entry() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_27.vcf";
        String fileName = "./test/annotate_27.vcf";
        List<VcfEntry> res = this.annotate(dbFileName, fileName, null);
        for (VcfEntry ve : res) {
            if (verbose) {
                System.out.println(ve);
            }
            Assert.assertEquals("121964859,45578238", ve.getInfo("RS"));
        }
    }

    public void test_28_exists() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_28.vcf";
        String fileName = "./test/annotate_28.vcf";
        String[] args = new String[]{"-exists", "EXISTS"};
        List<VcfEntry> res = this.annotate(dbFileName, fileName, args);
        for (VcfEntry ve : res) {
            if (verbose) {
                System.out.println(ve);
            }
            if (ve.getStart() == 201331098) {
                Assert.assertTrue("Existing VCF entry has not been annotated", ve.hasInfo("EXISTS"));
                continue;
            }
            Assert.assertFalse("Non-existing VCF entry has been annotated", ve.hasInfo("EXISTS"));
        }
    }

    public void test_29_repeated_IDs() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_29.vcf";
        String fileName = "./test/annotate_29.vcf";
        String[] args = new String[]{"-exists", "EXISTS"};
        List<VcfEntry> res = this.annotate(dbFileName, fileName, args);
        for (VcfEntry ve : res) {
            if (verbose) {
                System.out.println(ve);
            }
            if (ve.getStart() == 838418) {
                Assert.assertEquals("rs1130678", ve.getId());
                continue;
            }
            if (ve.getStart() == 49545) {
                Assert.assertEquals("rs62075716", ve.getId());
                continue;
            }
            if (ve.getStart() == 109567) {
                Assert.assertEquals("rs62076738", ve.getId());
                continue;
            }
            throw new RuntimeException("Position not found: " + ve.getStart());
        }
    }

    public void test_31_annotate_minimal_representation_db() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_31.vcf";
        String fileName = "./test/annotate_31.vcf";
        this.annotateTest(dbFileName, fileName);
    }

    public void test_32_annotate_minimal_representation_input() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_32.vcf";
        String fileName = "./test/annotate_32.vcf";
        this.annotateTest(dbFileName, fileName);
    }

    public void test_33_empty_db() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_33.vcf";
        String fileName = "./test/annotate_33.vcf";
        this.annotateTest(dbFileName, fileName);
    }

    public void test_34_dbStartsOnDifferentChromo() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_34.vcf";
        String fileName = "./test/annotate_34.vcf";
        List<VcfEntry> results = this.annotate(dbFileName, fileName, null);
        VcfEntry ve = results.get(0);
        String rs = ve.getInfo("RS");
        if (verbose) {
            System.out.println(ve + "\n\tRS: " + rs);
        }
        Assert.assertEquals("207477890", rs);
    }

    public void test_35() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_35.vcf";
        String fileName = "./test/annotate_35.vcf";
        String[] extraArgs = new String[]{"-noId"};
        List<VcfEntry> results = this.annotate(dbFileName, fileName, extraArgs);
        VcfEntry ve = results.get(0);
        String infoStr = ve.getInfoStr();
        Assert.assertEquals("FLAG_ADD", infoStr);
    }

    public void test_36() {
        Gpr.debug("Test");
        String dbFileName = "./test/db_test_36.vcf";
        String fileName = "./test/annotate_36.vcf";
        String[] extraArgs = new String[]{};
        List<VcfEntry> results = this.annotate(dbFileName, fileName, extraArgs);
        VcfEntry ve = results.get(0);
        if (verbose) {
            System.out.println(ve);
        }
        String infoStr = ve.getInfoStr();
        Assert.assertEquals("GENE=NPHP4", infoStr);
    }

    static {
        verbose = debug = false;
    }
}

