/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.pedigree;

import ca.mcgill.mcb.pcingola.ped.PedPedigree;
import ca.mcgill.mcb.pcingola.ped.Sex;
import ca.mcgill.mcb.pcingola.ped.TfamEntry;
import ca.mcgill.mcb.pcingola.snpSift.pedigree.Individual;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PedigreeDraw {
    public static boolean debug = false;
    int Y_OFFSET = 25;
    int X_OFFSET = 80;
    int INDIVIDUAL_SIZE = 20;
    int INDIVIDUAL_HALF_SIZE = this.INDIVIDUAL_SIZE / 2;
    int FEMALE_RADIUS = this.INDIVIDUAL_SIZE / 2;
    int MALE_SIZE = this.INDIVIDUAL_SIZE;
    int STROKE_WIDTH = 2;
    int FONT_SIZE = 10;
    int LABEL_DELTA_X = 20;
    int LABEL_DELTA_Y = 20;
    int STEP_X = 25;
    int STEP_Y = 200;
    int sizeX;
    int sizeY;
    String GEN_LINE_COLOR = "grey";
    String LINE_COLOR = "black";
    String STROKE_COLOR = "black";
    String BG_COLOR = "white";
    String BG_COLOR_SEQUENCED = "pink";
    String FILL_COLOR_FEMALE = "pink";
    String FILL_COLOR_MALE = "blue";
    String COLOR_SEQUENCED = "blue";
    String FILL_COLOR_TRUE = "red";
    String FILL_COLOR_FALSE = "green";
    String MARK_COLOR = "green";
    String MARK_BG_COLOR = "white";
    int MARK_WIDTH = 2;
    PedPedigree pedigree;
    int maxDepth;
    int[] labelCount;
    int[] couplesByDepth;
    HashSet<String> elements = new HashSet();
    ArrayList<String> elementsSorted = new ArrayList();
    HashMap<String, Integer> coupleNum = new HashMap();
    ArrayList<Individual> individuals;
    HashMap<String, Individual> individualsById = new HashMap();
    HashSet<String> assignedPos = new HashSet();

    public PedigreeDraw(PedPedigree pedigree) {
        this.pedigree = pedigree;
        this.init();
    }

    public PedigreeDraw(String tfamFileName) {
        this.pedigree = new PedPedigree();
        this.pedigree.loadTfam(tfamFileName);
        this.init();
    }

    void add(String line) {
        this.elements.add(line);
        this.elementsSorted.add(line);
    }

    int assign(Individual ind, int pos) {
        if (ind.hasPosition()) {
            this.assignedPos.remove(ind.getPosition().x + "\t" + ind.getDepth());
        }
        int max2 = Math.max(ind.getPosition().x, pos);
        while (this.assignedPos.contains(max2 + "\t" + ind.getDepth())) {
            ++max2;
        }
        ind.getPosition().x = max2;
        this.assignedPos.add(max2 + "\t" + ind.getDepth());
        if (debug) {
            Gpr.debug(Gpr.tabs(ind.getDepth()) + ind.getId() + "\t" + ind.getDepth() + " , " + ind.getPosition().x);
        }
        return max2;
    }

    public int assignOrder() {
        int order = 0;
        for (Individual ind : this.individuals) {
            ind.setOrder(order++);
        }
        return order;
    }

    int assignXpos() {
        ArrayList<Individual> indByDesc = new ArrayList<Individual>();
        indByDesc.addAll(this.individuals);
        Collections.sort(indByDesc, new Comparator<Individual>(){

            @Override
            public int compare(Individual o1, Individual o2) {
                int comp = o2.descendants() - o1.descendants();
                if (comp != 0) {
                    return comp;
                }
                return o1.getId().compareTo(o2.getId());
            }
        });
        int maxX = 0;
        for (int depth = 0; depth <= this.maxDepth; ++depth) {
            maxX = this.maxPositionX(depth);
            for (Individual ind : indByDesc) {
                if (ind.hasPosition() || ind.getDepth() != depth) continue;
                maxX = this.assignXpos(ind, maxX);
            }
        }
        return maxX;
    }

    int assignXpos(Individual ind, Individual spouse, int minPos) {
        Collection<Individual> sharedChilds = spouse != null ? ind.getChilds(spouse) : ind.getChilds();
        int maxX = minPos + 1;
        if (sharedChilds.isEmpty()) {
            maxX = this.assign(ind, minPos + 1);
            return maxX;
        }
        int childsMin = maxX;
        for (Individual ch : sharedChilds) {
            maxX = this.assignXpos(ch, maxX);
        }
        int childsMax = maxX;
        int mid = (childsMax + childsMin) / 2;
        int paren1 = Math.max(mid - 1, minPos);
        paren1 = this.assign(ind, paren1);
        int paren2 = Math.max(paren1 + 2, minPos);
        if (spouse != null) {
            this.assign(spouse, paren2);
        }
        maxX = Math.max(maxX, paren2);
        return maxX;
    }

    int assignXpos(Individual ind, int minPos) {
        if (ind.hasPosition()) {
            return Math.max(ind.getPosition().x, minPos);
        }
        int maxX = minPos;
        List<Individual> spouses = this.findSpouses(ind);
        if (spouses.isEmpty()) {
            maxX = this.assignXpos(ind, null, maxX);
        } else {
            for (Individual spouse : spouses) {
                maxX = this.assignXpos(ind, spouse, maxX);
            }
        }
        return maxX;
    }

    void assignYpos() {
        for (Individual ind : this.individuals) {
            ind.getPosition().y = ind.getDepth();
        }
    }

    public int calcDepth() {
        int maxDepth = 0;
        for (Individual indzz : this.individuals) {
            for (Individual ind : this.individuals) {
                int dfa;
                Individual father;
                int dmo;
                int depth = ind.calcDepth();
                Individual mother = ind.getMother();
                if (mother != null && (dmo = depth - 1) > mother.getDepth()) {
                    mother.setDepth(dmo);
                }
                if ((father = ind.getFather()) != null && (dfa = depth - 1) > father.getDepth()) {
                    father.setDepth(dfa);
                }
                maxDepth = Math.max(maxDepth, ind.getDepth());
            }
        }
        return maxDepth;
    }

    public void circle(int x2, int y, int r, String strokeColor, int strokeWidth, String fillColor) {
        this.add("<circle cx=\"" + x2 + "\" cy=\"" + y + "\" r=\"" + r + "\" stroke=\"" + strokeColor + "\" stroke-width=\"" + strokeWidth + "\" fill=\"" + fillColor + "\"/>\n");
    }

    public void colorAffected() {
        for (TfamEntry tfam : this.pedigree) {
            Individual ind = this.individualsById.get(tfam.getId());
            if (ind.getAffected() != null) {
                if (ind.getAffected().booleanValue()) {
                    ind.setColor("red");
                    continue;
                }
                ind.setColor("green");
                continue;
            }
            ind.setColor("grey");
        }
    }

    String coupleKey(Individual i1, Individual i2) {
        if (i2 == null) {
            i2 = i1;
        }
        if (i1.compareTo(i2) <= 0) {
            return i1.getId() + "\t" + i2.getId();
        }
        return i2.getId() + "\t" + i1.getId();
    }

    void couplesByDepth() {
        this.couplesByDepth = new int[this.maxDepth + 1];
        for (Individual ind : this.individuals) {
            List<Individual> spouses = this.findSpouses(ind);
            spouses.add(null);
            for (Individual spouse : spouses) {
                int depth;
                String coupleKey = this.coupleKey(ind, spouse);
                if (this.coupleNum.containsKey(coupleKey) || ind.getChilds(spouse).isEmpty()) continue;
                int n = depth = ind.getDepth();
                int n2 = this.couplesByDepth[n] + 1;
                this.couplesByDepth[n] = n2;
                int coupleN = n2;
                this.coupleNum.put(coupleKey, coupleN);
            }
        }
    }

    public void diamond(int x2, int y, int width, int height, String strokeColor, int strokeWidth, String fillColor) {
        int w2 = width / 2;
        int h2 = height / 2;
        this.add("<path d=\"M " + x2 + " y=" + y + " L " + w2 + " " + h2 + w2 + " " + -h2 + -w2 + " " + -h2 + -w2 + " " + h2 + "\"" + "stroke=\"" + strokeColor + "\"" + "stroke-width=\"" + strokeWidth + "\"" + (fillColor != null ? " fill=\"" + fillColor + "\"" : "") + "/>");
    }

    public String drawSvg() {
        this.maxDepth = this.calcDepth();
        this.labelCount = new int[this.maxDepth + 1];
        this.couplesByDepth();
        this.assignOrder();
        this.assignYpos();
        this.assignXpos();
        this.sizeY = this.scaleY(this.STEP_Y, this.Y_OFFSET);
        this.sizeX = this.scaleX(this.STEP_X, this.X_OFFSET);
        for (Individual ind : this.individuals) {
            this.drawSvg(ind);
        }
        for (Individual ind : this.individuals) {
            Individual mother = ind.getMother();
            Individual father = ind.getFather();
            if (father != null & mother != null) {
                this.line(father, mother, ind);
                continue;
            }
            if (mother != null) {
                this.line(mother, mother, ind);
                continue;
            }
            if (father == null) continue;
            this.line(father, father, ind);
        }
        for (int i = 0; i <= this.maxDepth; ++i) {
            int y = this.posY(i);
            this.lineDashed(new Point(0, y), new Point(this.sizeX, y), this.GEN_LINE_COLOR);
            this.label(new Point(this.LABEL_DELTA_X, y), "Gen_" + (i + 1));
        }
        StringBuffer out = new StringBuffer();
        out.insert(0, "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg width=\"100%\" height=\"100%\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n");
        for (String line : this.elementsSorted) {
            if (!this.elements.contains(line)) continue;
            out.append(line);
            this.elements.remove(line);
        }
        out.append("</svg>\n");
        return out.toString();
    }

    void drawSvg(Individual ind) {
        if (!ind.hasPosition()) {
            Gpr.debug("Skipping individual " + ind);
            return;
        }
        switch (ind.getSex()) {
            case Male: {
                this.male(ind);
                break;
            }
            case Female: {
                this.female(ind);
                break;
            }
            default: {
                this.unknown(ind);
            }
        }
    }

    public void drawSvgByFamily(String outdir, String info) {
        StringBuffer index = new StringBuffer();
        ArrayList<PedPedigree> families = new ArrayList<PedPedigree>();
        families.addAll(this.pedigree.families());
        Collections.sort(families);
        index = new StringBuffer();
        index.append("\n<center><b> Pedigree </b><center>\n");
        index.append("\n<pre>\n" + info + "\n</pre>\n");
        for (PedPedigree family : families) {
            String famId = family.getFamilyId();
            String familySvgFile = famId + ".svg";
            PedigreeDraw pedigreeDraw = new PedigreeDraw(family);
            for (Individual ind : this.individuals) {
                Individual indf = pedigreeDraw.get(ind.getId());
                if (indf == null) continue;
                indf.setColor(ind.getColor());
            }
            String svg = pedigreeDraw.drawSvg();
            Gpr.toFile(outdir + "/" + familySvgFile, svg);
            index.append("<p><center> Pedigree: " + famId + "</center>\n");
            index.append("\n<iframe src=\"" + familySvgFile + "\" width=\"" + pedigreeDraw.getSizeX() + "\" height=\"" + pedigreeDraw.getSizeY() + "\"> </iframe> <br>\n");
        }
        Gpr.toFile(outdir + "/index.html", index);
    }

    public void female(Individual ind) {
        Point p = ind.getPosition();
        String color = ind.getColor() != null ? ind.getColor() : this.BG_COLOR;
        this.circle(p.x, p.y, this.FEMALE_RADIUS, this.STROKE_COLOR, this.STROKE_WIDTH, color);
        this.label(ind);
    }

    public List<Individual> findSpouses(Individual ind) {
        LinkedList<Individual> spouses = new LinkedList<Individual>();
        for (Individual ind2 : this.individuals) {
            if (ind == ind2 || !ind.isSpouse(ind2)) continue;
            spouses.add(ind2);
        }
        return spouses;
    }

    public Individual get(String id) {
        return this.individualsById.get(id);
    }

    public ArrayList<Individual> getIndividuals() {
        return this.individuals;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    void init() {
        this.individualsById = new HashMap();
        this.individuals = new ArrayList();
        for (TfamEntry tf : this.pedigree) {
            Individual ind = new Individual(tf);
            this.individuals.add(ind);
            this.individualsById.put(ind.getId(), ind);
        }
        Collections.sort(this.individuals);
        LinkedList<Individual> toAdd = new LinkedList<Individual>();
        for (Individual ind : this.individuals) {
            String indId = ind.getId();
            String fid = this.pedigree.get(indId).getFatherId();
            Individual father = this.individualsById.get(fid);
            if (fid != null && father == null) {
                father = new Individual(new TfamEntry(ind.getFamilyId(), fid, null, null, Sex.Male, 0.0));
                toAdd.add(father);
            }
            ind.setFather(father);
            String mid = this.pedigree.get(indId).getMotherId();
            Individual mother = this.individualsById.get(mid);
            if (mid != null && mother == null) {
                mother = new Individual(new TfamEntry(ind.getFamilyId(), mid, null, null, Sex.Female, 0.0));
                toAdd.add(mother);
            }
            ind.setMother(mother);
        }
        for (Individual ind : toAdd) {
            this.individuals.add(ind);
            this.individualsById.put(ind.getId(), ind);
        }
    }

    void label(Individual ind) {
        Point p = new Point(ind.getPosition());
        int off = this.FONT_SIZE * (ind.hashCode() % 2);
        p.y = ind.hashCode() % 4 <= 1 ? p.y - this.INDIVIDUAL_SIZE - this.FONT_SIZE - this.FONT_SIZE / 3 - off : (p.y += off);
        p.x += this.INDIVIDUAL_SIZE / 2;
        this.label(p, ind.getLabel());
    }

    public void label(Point p, String label) {
        this.add("<text x=\"" + (p.x - this.LABEL_DELTA_X) + "\" y=\"" + (p.y + this.LABEL_DELTA_Y) + "\" font-family=\"Verdana\" font-size=\"" + this.FONT_SIZE + "\" fill=\"black\"> " + label + " </text>\n");
    }

    public void line(Individual parent1, Individual parent2, Individual child) {
        int mid1x = (parent1.getPosition().x + parent2.getPosition().x) / 2;
        int offset = this.offset(parent1, parent2);
        int mid1y = (parent1.getPosition().y + parent2.getPosition().y) / 2 + offset;
        Point mid1 = new Point(mid1x, mid1y);
        Point underParent1 = new Point(parent1.getPosition().x, mid1y);
        Point underParent2 = new Point(parent2.getPosition().x, mid1y);
        this.line(this.plus(parent1.getPosition(), 0, this.INDIVIDUAL_HALF_SIZE), underParent1);
        this.line(this.plus(parent2.getPosition(), 0, this.INDIVIDUAL_HALF_SIZE), underParent2);
        this.line(underParent1, underParent2);
        int mid2y = child.getPosition().y - offset;
        Point mid2 = new Point(mid1x, mid2y);
        this.line(mid1, mid2);
        Point mid3 = new Point(child.getPosition().x, mid2y);
        this.line(mid2, mid3);
        this.line(mid3, this.plus(child.getPosition(), 0, -this.INDIVIDUAL_HALF_SIZE));
    }

    public void line(Point p1, Point p2) {
        this.add("<line x1=\"" + p1.x + "\" y1=\"" + p1.y + "\" x2=\"" + p2.x + "\" y2=\"" + p2.y + "\" stroke-width=\"1\" stroke=\"" + this.LINE_COLOR + "\" />\n");
    }

    public void line(Point p1, Point p2, String color) {
        this.add("<line x1=\"" + p1.x + "\" y1=\"" + p1.y + "\" x2=\"" + p2.x + "\" y2=\"" + p2.y + "\" stroke-width=\"1\" stroke=\"" + color + "\" />\n");
    }

    public void lineDashed(Point p1, Point p2, String color) {
        this.add("<line x1=\"" + p1.x + "\" y1=\"" + p1.y + "\" x2=\"" + p2.x + "\" y2=\"" + p2.y + "\" style=\"stroke-dasharray: 2, 10; stroke-width: 1; stroke: " + color + ";\" />\n");
    }

    public void male(Individual ind) {
        Point p = ind.getPosition();
        String color = ind.getColor() != null ? ind.getColor() : this.BG_COLOR;
        this.square(p.x - this.MALE_SIZE / 2, p.y - this.MALE_SIZE / 2, this.MALE_SIZE, this.MALE_SIZE, this.STROKE_COLOR, this.STROKE_WIDTH, color);
        this.label(ind);
    }

    int maxPositionX(int depth) {
        int maxX = 0;
        for (Individual ind : this.individuals) {
            if (ind.getDepth() != depth || !ind.hasPosition()) continue;
            maxX = Math.max(maxX, ind.getPosition().x);
        }
        return maxX;
    }

    protected void moveIfLeft(int posX, int deltaX, Set<Individual> except) {
        for (Individual ind : this.individuals) {
            if (!ind.hasPosition() || ind.getPosition().x > posX || except.contains(ind)) continue;
            ind.getPosition().x += deltaX;
            Gpr.debug("Moved Left: " + ind);
        }
    }

    protected void moveIfRight(int posX, int deltaX, Set<Individual> except) {
        for (Individual ind : this.individuals) {
            if (!ind.hasPosition() || ind.getPosition().x < posX || except.contains(ind)) continue;
            ind.getPosition().x += deltaX;
            Gpr.debug("Moved right: " + ind);
        }
    }

    int offset(Individual parent1, Individual parent2) {
        int off = 0;
        int min2 = Math.max(this.FEMALE_RADIUS, this.MALE_SIZE / 2);
        int max2 = this.STEP_Y / 2 - min2 / 2;
        int maxCouples = this.couplesByDepth[parent1.getDepth()];
        if (maxCouples == 1) {
            off = this.STEP_Y / 4;
        } else {
            String key = this.coupleKey(parent1, parent2);
            int coupleN = this.coupleNum.get(key);
            off = coupleN * (max2 - min2) / (maxCouples + 1);
        }
        return off += min2;
    }

    Point plus(Point p, int x2, int y) {
        return new Point(p.x + x2, p.y + y);
    }

    int posY(int depth) {
        return this.Y_OFFSET + depth * this.STEP_Y;
    }

    int scaleX(int stepX, int offset) {
        int min2 = Integer.MAX_VALUE;
        for (Individual i : this.individuals) {
            if (!i.hasPosition()) continue;
            min2 = Math.min(min2, i.getPosition().x);
        }
        int max2 = 0;
        for (Individual i : this.individuals) {
            if (!i.hasPosition()) continue;
            i.getPosition().x = stepX * (i.getPosition().x - min2) + offset;
            max2 = Math.max(max2, i.getPosition().x);
        }
        return max2 + 2 * this.X_OFFSET;
    }

    int scaleY(int stepY, int offset) {
        int max2 = 0;
        for (Individual i : this.individuals) {
            i.getPosition().y = stepY * i.getPosition().y + offset;
            max2 = Math.max(max2, i.getPosition().y);
        }
        return max2 + 2 * this.Y_OFFSET;
    }

    void showMark(Individual ind, String color) {
        Point p = ind.getPosition();
        this.square(p.x - this.MALE_SIZE, p.y - this.MALE_SIZE, this.MALE_SIZE * 2, this.MALE_SIZE * 2, color, this.MARK_WIDTH, this.MARK_BG_COLOR);
    }

    public void square(int x2, int y, int width, int height, String strokeColor, int strokeWidth, String fillColor) {
        if (fillColor != null) {
            this.add("<rect x=\"" + x2 + "\" y=\"" + y + "\" width=\"" + width + "\" height=\"" + height + "\" stroke=\"" + strokeColor + "\" stroke-width=\"" + strokeWidth + "\" fill=\"" + fillColor + "\"/>");
        } else {
            this.add("<rect x=\"" + x2 + "\" y=\"" + y + "\" width=\"" + width + "\" height=\"" + height + "\" stroke=\"" + strokeColor + "\" stroke-width=\"" + strokeWidth + "\"/>");
        }
    }

    public void unknown(Individual ind) {
        Point p = ind.getPosition();
        String color = ind.getColor() != null ? ind.getColor() : this.BG_COLOR;
        this.diamond(p.x - this.MALE_SIZE / 2, p.y - this.MALE_SIZE / 2, this.MALE_SIZE, this.MALE_SIZE, this.STROKE_COLOR, this.STROKE_WIDTH, color);
        this.label(ind);
    }
}

