/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.lang.function;

import ca.mcgill.mcb.pcingola.snpSift.lang.Value;
import ca.mcgill.mcb.pcingola.snpSift.lang.expression.Expression;
import ca.mcgill.mcb.pcingola.snpSift.lang.function.Function;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class In
extends Function {
    ArrayList<HashSet<String>> sets;
    Expression expression;
    Expression setIdxExpr;

    public In(ArrayList<HashSet<String>> sets, Expression expression, Expression setIdxExpr) {
        super("in");
        this.sets = sets;
        this.expression = expression;
        this.setIdxExpr = setIdxExpr;
    }

    @Override
    public Value eval(VcfEntry vcfEntry) {
        String val = this.expression.eval(vcfEntry).asString();
        Value idx = this.setIdxExpr.eval(vcfEntry);
        Set set = this.sets.get((int)idx.asInt());
        return set.contains(val) ? Value.TRUE : Value.FALSE;
    }

    @Override
    public Value eval(VcfGenotype gt) {
        String val = this.expression.eval(gt).asString();
        Value idx = this.setIdxExpr.eval(gt);
        Set set = this.sets.get((int)idx.asInt());
        return set.contains(val) ? Value.TRUE : Value.FALSE;
    }

    @Override
    public String toString() {
        return this.expression + " " + this.operator + " SET[" + this.setIdxExpr + "]";
    }
}

