/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.lang.expression;

import ca.mcgill.mcb.pcingola.snpSift.lang.Value;
import ca.mcgill.mcb.pcingola.snpSift.lang.expression.Expression;
import ca.mcgill.mcb.pcingola.snpSift.lang.expression.ExpressionBinary;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Match
extends ExpressionBinary {
    public Match(Expression left, Expression right) {
        super(left, right, "~=");
    }

    @Override
    protected Value evalOp(Value lval, Value rval) {
        if (lval.isNull() || rval.isNull()) {
            return Value.FALSE;
        }
        String value2 = lval.asString();
        boolean retVal = false;
        if (value2.isEmpty()) {
            retVal = false;
        } else {
            String regexp = rval.asString();
            Pattern pattern = Pattern.compile(regexp);
            Matcher matcher = pattern.matcher(value2);
            retVal = matcher.find();
        }
        return new Value(this.negated ? !retVal : retVal);
    }
}

