/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.lang.expression;

import ca.mcgill.mcb.pcingola.snpSift.lang.expression.Expression;
import ca.mcgill.mcb.pcingola.snpSift.lang.expression.FieldIterator;
import ca.mcgill.mcb.pcingola.snpSift.lang.expression.FieldSub;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeader;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderInfo;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;
import ca.mcgill.mcb.pcingola.vcf.VcfLof;

public class FieldLof
extends FieldSub {
    int fieldNum = -1;
    String infoFieldName;

    public FieldLof(String name, Expression indexExpr) {
        super(name, indexExpr);
        this.init();
    }

    @Override
    public String getFieldString(VcfEntry vcfEntry) {
        String[] lofEntries;
        String infoStr = vcfEntry.getInfo(this.infoFieldName);
        if (infoStr == null) {
            return (String)this.fieldNotFound(vcfEntry);
        }
        int index = this.evalIndex(vcfEntry);
        if (index >= (lofEntries = infoStr.split(",")).length) {
            return null;
        }
        int idx = index;
        if (index < 0) {
            FieldIterator.get().setMax(FieldIterator.IteratorType.LOF, lofEntries.length - 1);
            FieldIterator.get().setType(index);
            idx = FieldIterator.get().get(FieldIterator.IteratorType.LOF);
        }
        String lof = lofEntries[idx];
        return this.getSubField(lof);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VcfInfoType getReturnType(VcfEntry vcfEntry) {
        String headerName;
        if (this.name == null) {
            return VcfInfoType.String;
        }
        if (this.returnType != VcfInfoType.UNKNOWN) {
            return this.returnType;
        }
        VcfHeader vcfHeader = vcfEntry.getVcfFileIterator().getVcfHeader();
        VcfHeaderInfo vcfInfo = vcfHeader.getVcfInfo(headerName = this.infoFieldName + "." + this.name);
        if (vcfInfo == null) {
            throw new RuntimeException("Sub-field '" + headerName + "' not found in VCF header");
        }
        this.returnType = vcfInfo.getVcfInfoType();
        return this.returnType;
    }

    String getSubField(String lof) {
        String[] subField;
        if (this.name == null) {
            return lof;
        }
        if (lof.startsWith("(")) {
            lof = lof.substring(1);
        }
        if (lof.endsWith(")")) {
            lof = lof.substring(0, lof.length() - 1);
        }
        if (this.fieldNum >= (subField = lof.split("\\|")).length) {
            return null;
        }
        return subField[this.fieldNum];
    }

    protected void init() {
        this.infoFieldName = "LOF";
        if (this.name != null) {
            String headerName = this.infoFieldName + "." + this.name;
            this.fieldNum = VcfLof.fieldNum(headerName);
            if (this.fieldNum < 0) {
                throw new RuntimeException("No such " + this.infoFieldName + " subfield '" + headerName + "'");
            }
        }
    }

    @Override
    public String toString() {
        return this.infoFieldName + "[" + this.indexExpr + "]" + (this.name != null ? "." + this.name : "");
    }
}

