/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.lang.expression;

import ca.mcgill.mcb.pcingola.snpSift.lang.Value;
import ca.mcgill.mcb.pcingola.snpSift.lang.expression.Expression;
import ca.mcgill.mcb.pcingola.snpSift.lang.expression.FieldConstant;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import ca.mcgill.mcb.pcingola.vcf.VcfHeader;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderInfo;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderInfoGenotype;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;

public class Field
extends Expression {
    public static final int TYPE_ALL = -2;
    public static final int TYPE_ANY = -1;
    protected String name;
    protected VcfInfoType returnType;
    protected boolean exceptionIfNotFound = true;

    public Field(String name) {
        this.name = name;
        this.returnType = name == null ? VcfInfoType.String : (name.equals("CHROM") || name.equals("ID") || name.equals("REF") || name.equals("ALT") || name.equals("FILTER") || name.equals("FORMAT") ? VcfInfoType.String : (name.equals("QUAL") ? VcfInfoType.Float : (name.equals("POS") ? VcfInfoType.Integer : VcfInfoType.UNKNOWN)));
    }

    protected VcfInfoType calcReturnType(VcfHeaderInfo vcfInfo) {
        if (this.isSub()) {
            return vcfInfo.getVcfInfoType();
        }
        if (vcfInfo.getNumber() == 1) {
            return vcfInfo.getVcfInfoType();
        }
        return VcfInfoType.String;
    }

    @Override
    public Value eval(VcfEntry vcfEntry) {
        switch (this.getReturnType(vcfEntry)) {
            case Integer: {
                return new Value(this.getFieldInt(vcfEntry));
            }
            case Float: {
                return new Value(this.getFieldFloat(vcfEntry));
            }
            case Flag: {
                return new Value(this.getFieldFlag(vcfEntry));
            }
            case Character: 
            case String: {
                return new Value(this.getFieldString(vcfEntry));
            }
        }
        throw new RuntimeException("Unknown return type '" + (Object)((Object)this.returnType) + "'");
    }

    @Override
    public Value eval(VcfGenotype vcfGenotype) {
        switch (this.getReturnType(vcfGenotype)) {
            case Integer: {
                return new Value(this.getFieldInt(vcfGenotype));
            }
            case Float: {
                return new Value(this.getFieldFloat(vcfGenotype));
            }
            case Flag: {
                return new Value(this.getFieldString(vcfGenotype) != null);
            }
            case Character: 
            case String: {
                return new Value(this.getFieldString(vcfGenotype));
            }
        }
        throw new RuntimeException("Unknown return type '" + (Object)((Object)this.returnType) + "'");
    }

    protected Object fieldHeaderNotFound(VcfEntry vcfEntry) {
        if (this.exceptionIfNotFound) {
            throw new RuntimeException("Error: Field '" + this + "' not available in this VCF entry.\n\t" + vcfEntry);
        }
        return null;
    }

    protected Object fieldNotFound(VcfEntry vcfEntry) {
        if (this.exceptionIfNotFound) {
            throw new RuntimeException("Error: Field '" + this + "' not available in this VCF entry.\n\t" + vcfEntry);
        }
        return null;
    }

    Boolean getFieldFlag(VcfEntry vcfEntry) {
        String value2 = this.getFieldString(vcfEntry);
        return value2 != null && !value2.isEmpty();
    }

    public Double getFieldFloat(VcfEntry vcfEntry) {
        if (this.name.equals("QUAL")) {
            return vcfEntry.getQuality();
        }
        String value2 = this.getFieldString(vcfEntry);
        if (value2 == null) {
            return (Double)this.fieldNotFound(vcfEntry);
        }
        return Gpr.parseDoubleSafe(value2);
    }

    Double getFieldFloat(VcfGenotype vcfGenotype) {
        String value2 = this.getFieldString(vcfGenotype);
        if (value2 == null) {
            return (Double)this.gtFieldNotFound(vcfGenotype);
        }
        return Gpr.parseDoubleSafe(value2);
    }

    Long getFieldInt(VcfEntry vcfEntry) {
        if (this.name.equals("POS")) {
            return (long)vcfEntry.getStart() + 1L;
        }
        if (this.isSampleName(vcfEntry, this.name)) {
            return this.getSampleNum(vcfEntry, this.name);
        }
        String value2 = this.getFieldString(vcfEntry);
        if (value2 == null) {
            return (Long)this.fieldNotFound(vcfEntry);
        }
        return Gpr.parseLongSafe(value2);
    }

    Long getFieldInt(VcfGenotype vcfGenotype) {
        if (this.name.equals("GT")) {
            return vcfGenotype.getGenotypeCode();
        }
        String value2 = this.getFieldString(vcfGenotype);
        if (value2 == null) {
            return (Long)this.gtFieldNotFound(vcfGenotype);
        }
        return Gpr.parseLongSafe(value2);
    }

    String getFieldString(VcfEntry vcfEntry) {
        if (this.name.equals("CHROM")) {
            return vcfEntry.getChromosomeNameOri();
        }
        if (this.name.equals("ID")) {
            return vcfEntry.getId();
        }
        if (this.name.equals("REF")) {
            return vcfEntry.getRef();
        }
        if (this.name.equals("ALT")) {
            return vcfEntry.getAltsStr();
        }
        if (this.name.equals("FILTER")) {
            return vcfEntry.getFilterPass();
        }
        if (this.name.equals("FORMAT")) {
            return vcfEntry.getFormat();
        }
        if (this.name.equals("POS")) {
            return "" + (vcfEntry.getStart() + 1);
        }
        if (this.name.equals("QUAL")) {
            return "" + vcfEntry.getQuality();
        }
        VcfHeaderInfo vcfInfo = vcfEntry.getVcfFileIterator().getVcfHeader().getVcfInfo(this.name);
        if (vcfInfo == null) {
            return (String)this.fieldHeaderNotFound(vcfEntry);
        }
        String value2 = vcfEntry.getInfo(this.name);
        if (value2 == null) {
            return (String)this.fieldNotFound(vcfEntry);
        }
        return value2;
    }

    public String getFieldString(VcfGenotype vcfGenotype) {
        if (this.name.equals("GT")) {
            return vcfGenotype.getGenotypeStr();
        }
        String value2 = vcfGenotype.get(this.name);
        if (value2 == null) {
            return (String)this.gtFieldNotFound(vcfGenotype);
        }
        return value2;
    }

    public String getName() {
        return this.name;
    }

    public VcfInfoType getReturnType(VcfEntry vcfEntry) {
        if (this.returnType != VcfInfoType.UNKNOWN) {
            return this.returnType;
        }
        VcfHeader vcfHeader = vcfEntry.getVcfFileIterator().getVcfHeader();
        VcfHeaderInfo vcfInfo = vcfHeader.getVcfInfo(this.name);
        if (vcfInfo != null) {
            this.returnType = this.calcReturnType(vcfInfo);
        } else {
            VcfHeaderInfoGenotype vcfInfoGenotype = vcfHeader.getVcfInfoGenotype(this.name);
            if (vcfInfoGenotype != null) {
                this.returnType = this.calcReturnType(vcfInfoGenotype);
            } else if (FieldConstant.isConstantField(this.name)) {
                this.returnType = FieldConstant.FieldConstantNames.valueOf(this.name).getType();
            } else if (this.isSampleName(vcfEntry, this.name)) {
                this.returnType = VcfInfoType.Integer;
            } else {
                throw new RuntimeException("INFO field '" + this.name + "' not found in VCF header");
            }
        }
        return this.returnType;
    }

    public VcfInfoType getReturnType(VcfGenotype vcfGenotype) {
        if (this.returnType == VcfInfoType.UNKNOWN) {
            VcfHeader vcfHeader = vcfGenotype.getVcfEntry().getVcfFileIterator().getVcfHeader();
            VcfHeaderInfoGenotype vcfInfoGenotype = vcfHeader.getVcfInfoGenotype(this.name);
            if (vcfInfoGenotype == null) {
                if (FieldConstant.isConstantField(this.name)) {
                    this.returnType = FieldConstant.FieldConstantNames.valueOf(this.name).getType();
                } else if (this.isSampleName(vcfGenotype.getVcfEntry(), this.name)) {
                    this.returnType = VcfInfoType.Integer;
                } else {
                    throw new RuntimeException("Genotype field '" + this.name + "' not found in VCF header");
                }
            }
            this.returnType = this.calcReturnType(vcfInfoGenotype);
        }
        return this.returnType;
    }

    protected int getSampleNum(VcfEntry vcfEntry, String name) {
        return vcfEntry.getVcfFileIterator().getVcfHeader().getSampleNum(name);
    }

    protected Object gtFieldNotFound(VcfGenotype vcfGenotype) {
        if (this.exceptionIfNotFound) {
            throw new RuntimeException("Error: Field '" + this + "' not available in this VCF genotype.\n\tGenotype : " + vcfGenotype + "\n\tLine     : " + vcfGenotype.getVcfEntry());
        }
        return null;
    }

    public String indexStr(int index) {
        if (index == -1) {
            return "*";
        }
        if (index == -2) {
            return "ALL";
        }
        return Integer.toString(index);
    }

    protected boolean isSampleName(VcfEntry vcfEntry, String name) {
        return vcfEntry.getVcfFileIterator().getVcfHeader().getSampleNum(name) >= 0;
    }

    protected boolean isSub() {
        return false;
    }

    int parseIndexField(String text2) {
        if (text2.equals("*")) {
            return -1;
        }
        if (text2.equals("ANY")) {
            return -1;
        }
        if (text2.equals("?")) {
            return -2;
        }
        if (text2.equals("ALL")) {
            return -2;
        }
        return Gpr.parseIntSafe(text2);
    }

    public void setExceptionIfNotFound(boolean exceptionIfNotFound) {
        this.exceptionIfNotFound = exceptionIfNotFound;
    }

    public String toString() {
        return this.name;
    }
}

