/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.hwe;

import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.util.ArithmeticUtils;

public class VcfHwe {
    public static boolean debug = false;
    static final double LOG2 = Math.log(2.0);

    public double hwe(VcfEntry vcfEntry, boolean addInfo) {
        if (vcfEntry.getAlts().length != 1) {
            return Double.NaN;
        }
        int countSamples = vcfEntry.getAlts().length + 1;
        int[] countByGen = new int[countSamples];
        int countAA = 0;
        int countAB = 0;
        int countBB = 0;
        int tot = 0;
        byte[] gt = vcfEntry.getGenotypesScores();
        block5: for (int i = 0; i < gt.length; ++i) {
            switch (gt[i]) {
                case 0: {
                    ++countAA;
                    countByGen[0] = countByGen[0] + 2;
                    continue block5;
                }
                case 1: {
                    ++countAB;
                    countByGen[0] = countByGen[0] + 1;
                    countByGen[1] = countByGen[1] + 1;
                    continue block5;
                }
                case 2: {
                    ++countBB;
                    countByGen[1] = countByGen[1] + 2;
                    continue block5;
                }
            }
        }
        if (countByGen[0] != countAA * 2 + countAB) {
            throw new RuntimeException("This should never happen!");
        }
        if (countByGen[1] != countBB * 2 + countAB) {
            throw new RuntimeException("This should never happen!");
        }
        double p = 0.0;
        double q = 0.0;
        if (tot > 0) {
            p = (double)countByGen[0] / (double)tot;
            q = (double)countByGen[1] / (double)tot;
        }
        double exactP = this.hweP(countByGen[0], countByGen[1], countAB);
        double exactLogP = this.hweLogPn12(countByGen[0], countByGen[1], countAB);
        if (addInfo) {
            vcfEntry.addInfo("HWE", p + "," + q);
            vcfEntry.addInfo("HWEP", exactP + "");
            vcfEntry.addInfo("HWEPCHI", this.hwePchi2(countByGen[0], countByGen[1], countAB) + "," + countByGen[0] + "," + countByGen[1] + "," + countAB);
        }
        return exactP;
    }

    public double hweLogPn12(int n1, int n2, int n12) {
        if ((n1 - n12) % 2 != 0) {
            throw new RuntimeException("Bad nuber combination: (n1-n12) must be even");
        }
        if ((n2 - n12) % 2 != 0) {
            throw new RuntimeException("Bad nuber combination: (n2-n12) must be even");
        }
        int n = n1 + n2;
        int n11 = (n1 - n12) / 2;
        int n22 = (n2 - n12) / 2;
        int N = n11 + n12 + n22;
        double num = ArithmeticUtils.factorialLog(N) - (ArithmeticUtils.factorialLog(n11) + ArithmeticUtils.factorialLog(n12) + ArithmeticUtils.factorialLog(n22));
        double den = ArithmeticUtils.factorialLog(2 * N) - (ArithmeticUtils.factorialLog(n1) + ArithmeticUtils.factorialLog(n2));
        double logp = num - den + (double)n12 * LOG2;
        double p = Math.exp(logp);
        if (debug) {
            Gpr.debug("\n\tn11: " + n11 + "\n\tn12: " + n12 + "\n\tn22: " + n22 + "\n\tn: " + n + "\n\tn1: " + n1 + "\n\tn2: " + n2 + "\n\tlogP: " + logp + "\n\tp: " + p + "\n\tnum : " + num + " [" + Math.exp(num) + "]" + "\n\tden : " + den + " [" + Math.exp(den) + "]");
        }
        return logp;
    }

    public double hweP(int n1, int n2, int n12star) {
        int min2 = Math.min(n1, n2);
        double pstar = this.hwePn12(n1, n2, n12star);
        double totP = 0.0;
        for (int n12 = 0; n12 <= min2; ++n12) {
            double p;
            if ((n1 - n12) % 2 != 0 || (n2 - n12) % 2 != 0 || !((p = this.hwePn12(n1, n2, n12)) <= pstar)) continue;
            totP += p;
        }
        return Math.min(1.0, totP);
    }

    public double hwePchi2(int n1, int n2, int n12) {
        if ((n1 - n12) % 2 != 0) {
            throw new RuntimeException("Bad nuber combination: (n1-n12) must be even");
        }
        if ((n2 - n12) % 2 != 0) {
            throw new RuntimeException("Bad nuber combination: (n2-n12) must be even");
        }
        int n = n1 + n2;
        int n11 = (n1 - n12) / 2;
        int n22 = (n2 - n12) / 2;
        int N = n / 2;
        if (n == 0) {
            return 0.0;
        }
        double p = (double)n1 / (double)n;
        double q = (double)n2 / (double)n;
        double expAA = (double)N * p * p;
        double dAA = (double)n11 - expAA;
        double expAB = (double)N * 2.0 * p * q;
        double dAB = (double)n12 - expAB;
        double expBB = (double)N * q * q;
        double dBB = (double)n22 - expBB;
        double chi2 = dAA * dAA / expAA + dAB * dAB / expAB + dBB * dBB / expBB;
        double pChi2 = 1.0 - new ChiSquaredDistribution(1.0).cumulativeProbability(chi2);
        return pChi2;
    }

    public double hwePn12(int n1, int n2, int n12) {
        double logp = this.hweLogPn12(n1, n2, n12);
        double p = Math.exp(logp);
        return p;
    }
}

