/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.hwe;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.snpSift.hwe.VcfHwe;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderInfo;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;
import java.util.List;

public class SnpSiftCmdHwe
extends SnpSift {
    public static final int SHOW_EVERY = 1000;

    public static void main(String[] args) {
        SnpSiftCmdHwe vcfhwe = new SnpSiftCmdHwe(args);
        vcfhwe.run();
    }

    public SnpSiftCmdHwe() {
        super(null, null);
    }

    public SnpSiftCmdHwe(String[] args) {
        super(args, "hwe");
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> addh = super.headers();
        addh.add(new VcfHeaderInfo("HWE", VcfInfoType.Float, "1", "HardyWeinberg 'p'"));
        addh.add(new VcfHeaderInfo("HWEP", VcfInfoType.Float, "1", "HardyWeinberg p-value using Fisher exact test"));
        addh.add(new VcfHeaderInfo("HHWEPCHIWE", VcfInfoType.Float, "1", "HardyWeinberg p-value using Chi sqaure approximation"));
        return addh;
    }

    @Override
    public void parse(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        for (int argc = 0; argc < args.length; ++argc) {
            String arg = args[argc];
            if (this.isOpt(arg)) {
                if (arg.equals("-h") || args[argc].equalsIgnoreCase("-help")) {
                    this.usage(null);
                    continue;
                }
                if (arg.equals("-v")) {
                    this.verbose = true;
                    continue;
                }
                if (arg.equals("-q")) {
                    this.verbose = false;
                    continue;
                }
                if (arg.equals("-d")) {
                    this.debug = false;
                    continue;
                }
                this.usage("Unknown option '" + args[argc] + "'");
                continue;
            }
            this.vcfInputFile = args[argc++];
        }
        if (this.vcfInputFile == null) {
            this.vcfInputFile = "-";
        }
    }

    @Override
    public void run() {
        Timer.showStdErr("Reading '" + this.vcfInputFile + "'. Running single threaded mode.");
        VcfFileIterator vcfFile = new VcfFileIterator(this.vcfInputFile);
        vcfFile.setDebug(this.debug);
        VcfHwe vcfHwe = new VcfHwe();
        VcfHwe.debug = this.debug;
        int entryNum = 1;
        for (VcfEntry vcfEntry : vcfFile) {
            if (entryNum == 1) {
                this.headers();
                String headerStr = vcfFile.getVcfHeader().toString();
                if (!headerStr.isEmpty()) {
                    System.out.println(headerStr);
                }
            }
            vcfHwe.hwe(vcfEntry, true);
            System.out.println(vcfEntry);
            Gpr.showMark(entryNum++, 1000);
        }
        Timer.showStdErr("Done: " + entryNum + " entries processed.");
    }

    @Override
    public void usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("Error: " + errMsg);
        }
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + "" + ".jar hwe [-v] [-q] [file.vcf]");
        System.err.println("\t-q       : Be quite");
        System.err.println("\t-v       : Be verbose");
        System.exit(1);
    }
}

