/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.gwasCatalog;

import ca.mcgill.mcb.pcingola.collections.MultivalueHashMap;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.snpSift.gwasCatalog.GwasCatalogEntry;
import ca.mcgill.mcb.pcingola.snpSift.gwasCatalog.GwasCatalogFileIterator;
import java.util.List;

public class GwasCatalog {
    MultivalueHashMap<String, GwasCatalogEntry> gwasEntryByChrPos = new MultivalueHashMap();
    MultivalueHashMap<String, GwasCatalogEntry> gwasEntryByRs = new MultivalueHashMap();

    public GwasCatalog(String fileName) {
        this.load(fileName);
    }

    public List<GwasCatalogEntry> get(String chrName, int pos) {
        return (List)this.gwasEntryByChrPos.get(this.key(chrName, pos));
    }

    public List<GwasCatalogEntry> getByRs(String rs) {
        return (List)this.gwasEntryByRs.get(rs);
    }

    String key(String chrName, int pos) {
        return Chromosome.simpleName(chrName) + ":" + pos;
    }

    protected void load(String fileName) {
        GwasCatalogFileIterator gfile = new GwasCatalogFileIterator(fileName);
        for (GwasCatalogEntry ge : gfile) {
            String key = this.key(ge.chrId, ge.chrPos - 1);
            this.gwasEntryByChrPos.add(key, ge);
            for (String rs : ge.snps.split(",")) {
                if (rs.equals("NR")) continue;
                this.gwasEntryByRs.add(rs, ge);
            }
        }
    }
}

