/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.caseControl;

import ca.mcgill.mcb.pcingola.collections.AutoHashMap;
import ca.mcgill.mcb.pcingola.fileIterator.BedFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import ca.mcgill.mcb.pcingola.ped.PedPedigree;
import ca.mcgill.mcb.pcingola.ped.TfamEntry;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.snpSift.caseControl.Summary;
import ca.mcgill.mcb.pcingola.stats.CountByType;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.EffFormatVersion;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import ca.mcgill.mcb.pcingola.vcf.VcfHeader;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SnpSiftCmdCaseControlSummary
extends SnpSift {
    public static EffFormatVersion formatVersion = null;
    public static Boolean[] CaseControl = new Boolean[]{true, false};
    PedPedigree pedPedigree;
    boolean headerSummary = true;
    String tfamFile;
    String bedFile;
    String vcfFile;
    HashMap<String, Boolean> caseControls;
    HashMap<String, String> groups;
    List<Variant> intervals;
    ArrayList<String> groupNamesSorted;
    IntervalForest intForest;
    List<String> sampleIds;
    AutoHashMap<Marker, Summary> summaryByInterval;
    ArrayList<String> infoFields;

    public SnpSiftCmdCaseControlSummary(String[] args) {
        super(args, "caseControlSummary");
    }

    void load() {
        Timer.showStdErr("Reading cases & controls from " + this.tfamFile);
        this.pedPedigree = new PedPedigree(this.tfamFile);
        int countCase = 0;
        int countCtrl = 0;
        int countMissing = 0;
        this.caseControls = new HashMap();
        for (TfamEntry te : this.pedPedigree) {
            if (te.isCase() | te.isControl()) {
                this.caseControls.put(te.getId(), te.isCase());
            }
            if (te.isCase()) {
                ++countCase;
                continue;
            }
            if (te.isControl()) {
                ++countCtrl;
                continue;
            }
            ++countMissing;
        }
        Timer.showStdErr("Total : " + this.caseControls.size() + " entries. Cases: " + countCase + ", controls: " + countCtrl + ", missing: " + countMissing);
        this.groups = new HashMap();
        HashSet<String> groupNames = new HashSet<String>();
        CountByType countByType = new CountByType();
        for (TfamEntry te : this.pedPedigree) {
            String id = te.getId();
            String group = te.getFamilyId();
            if (group == null || group.isEmpty()) continue;
            this.groups.put(id, group);
            groupNames.add(group);
            countByType.inc(group);
        }
        Timer.showStdErr("Total : " + this.groups.size() + " entries.\n" + countByType);
        this.groupNamesSorted = new ArrayList();
        this.groupNamesSorted.addAll(groupNames);
        Collections.sort(this.groupNamesSorted);
        Timer.showStdErr("Loading intervals from " + this.bedFile);
        BedFileIterator bed = new BedFileIterator(this.bedFile);
        this.intervals = bed.load();
        Timer.showStdErr("Done. Number of intervals: " + this.intervals.size());
        if (this.intervals.size() <= 0) {
            System.err.println("Fatal error: No intervals!");
            System.exit(1);
        }
        Timer.showStdErr("Building interval forest.");
        this.intForest = new IntervalForest();
        for (Variant sc : this.intervals) {
            this.intForest.add(sc);
        }
        this.intForest.build();
    }

    double maf(VcfEntry ve) {
        double maf = -1.0;
        if (ve.hasField("AF")) {
            maf = ve.getInfoFloat("AF");
        } else if (ve.hasField("MAF")) {
            maf = ve.getInfoFloat("MAF");
        } else {
            int ac = 0;
            int count2 = 0;
            for (VcfGenotype gen : ve) {
                count2 += 2;
                int genCode = gen.getGenotypeCode();
                if (genCode <= 0) continue;
                ac += genCode;
            }
            maf = (double)ac / (double)count2;
        }
        if (maf > 0.5) {
            maf = 1.0 - maf;
        }
        return maf;
    }

    @Override
    public void parse(String[] args) {
        if (args.length <= 0) {
            this.usage(null);
        }
        for (int argc = 0; argc < args.length; ++argc) {
            if (this.isOpt(args[argc])) {
                this.usage("Unknown option '" + args[argc] + "'");
                continue;
            }
            if (this.tfamFile == null) {
                this.tfamFile = args[argc];
                continue;
            }
            if (this.bedFile == null) {
                this.bedFile = args[argc];
                continue;
            }
            if (this.vcfFile != null) continue;
            this.vcfFile = args[argc];
        }
        if (this.tfamFile == null) {
            this.usage("Missing paramter 'file.tped'");
        }
        if (this.bedFile == null) {
            this.usage("Missing paramter 'file.bed'");
        }
        if (this.vcfFile == null) {
            this.usage("Missing paramter 'file.vcf'");
        }
    }

    void parseDbNsfpFields(VcfFileIterator vcf) {
        VcfHeader vcfHeader = vcf.getVcfHeader();
        for (VcfHeaderInfo vcfInfo : vcfHeader.getVcfInfo()) {
            if (!vcfInfo.getId().startsWith("dbNSFP_")) continue;
            this.infoFields.add(vcfInfo.getId());
        }
        Collections.sort(this.infoFields);
    }

    List<String> parseSampleIds(VcfFileIterator vcf) {
        int missingCc = 0;
        int missingGroups = 0;
        List<String> sampleIds = vcf.getSampleNames();
        for (String id : sampleIds) {
            if (!this.caseControls.containsKey(id)) {
                ++missingCc;
            }
            if (this.groups.containsKey(id)) continue;
            ++missingGroups;
        }
        Timer.showStdErr("Samples missing case/control info : " + missingCc);
        Timer.showStdErr("Samples missing groups info       : " + missingGroups);
        if (1.0 * (double)missingCc / (double)sampleIds.size() > 0.5 || 1.0 * (double)missingCc / (double)sampleIds.size() > 0.5) {
            Timer.showStdErr("Fatal error: Too much missing data!");
            System.exit(1);
        }
        VcfHeader vcfHeader = vcf.getVcfHeader();
        for (VcfHeaderInfo vcfInfo : vcfHeader.getVcfInfo()) {
            if (!vcfInfo.getId().startsWith("dbNSFP_")) continue;
            this.infoFields.add(vcfInfo.getId());
        }
        Collections.sort(this.infoFields);
        return sampleIds;
    }

    void parseVcfEntry(VcfEntry ve) {
        VariantEffect.FunctionalClass funcClass = VariantEffect.FunctionalClass.NONE;
        VcfEffect effMax = null;
        StringBuilder effAll = new StringBuilder();
        StringBuilder otherInfo = new StringBuilder();
        for (VcfEffect eff : ve.parseEffects(formatVersion)) {
            if (eff.getFunClass() != null && funcClass.ordinal() < eff.getFunClass().ordinal()) {
                funcClass = eff.getFunClass();
                effMax = eff;
            }
            effAll.append(eff + "\t");
        }
        if (funcClass != VariantEffect.FunctionalClass.NONE) {
            this.maf(ve);
            String variantAf = ve.alleleFrequencyType().toString();
            Summary summary = new Summary();
            Markers intersect2 = this.intForest.query(ve);
            int sampleNum = 0;
            for (String id : this.sampleIds) {
                int count2;
                String group = this.groups.get(id);
                Boolean caseControl = this.caseControls.get(id);
                if (caseControl != null && (count2 = ve.getVcfGenotype(sampleNum).getGenotypeCode()) > 0) {
                    summary.count(group, caseControl, funcClass, variantAf, count2);
                    for (Marker interval : intersect2) {
                        Summary summaryInt = this.summaryByInterval.getOrCreate(interval);
                        summaryInt.count(group, caseControl, funcClass, variantAf, count2);
                    }
                }
                ++sampleNum;
            }
            for (String oi : this.infoFields) {
                String val = ve.getInfo(oi);
                if (val != null) {
                    otherInfo.append(val + "\t");
                    continue;
                }
                otherInfo.append("\t");
            }
            if (this.headerSummary) {
                System.out.print("chr\tstart\tref\talt\tgene\teffect\taa\t" + summary.toStringTitle(this.groupNamesSorted));
                for (String oi : this.infoFields) {
                    System.out.print(oi + "\t");
                }
                System.out.println("effect (max)\teffects (all)");
                this.headerSummary = false;
            }
            System.out.println(ve.getChromosomeName() + "\t" + (ve.getStart() + 1) + "\t" + ve.getRef() + "\t" + ve.getAltsStr() + "\t" + effMax.getGeneName() + "\t" + (Object)((Object)effMax.getEffectType()) + "\t" + effMax.getAa() + "\t" + summary.toString(this.groupNamesSorted) + otherInfo + "\t" + effMax + "\t" + effAll);
        }
    }

    @Override
    public void run() {
        this.load();
        this.summaryByInterval = new AutoHashMap(new Summary());
        this.infoFields = new ArrayList();
        this.headerSummary = true;
        boolean headerVcf = true;
        VcfFileIterator vcf = new VcfFileIterator(this.vcfFile);
        vcf.setDebug(this.debug);
        for (VcfEntry ve : vcf) {
            if (headerVcf) {
                headerVcf = false;
                this.sampleIds = this.parseSampleIds(vcf);
            }
            this.parseVcfEntry(ve);
        }
        System.err.println("#Summary by interval\n");
        System.err.println("chr\tstart\tend\tname\t" + new Summary().toStringTitle(this.groupNamesSorted));
        for (Variant sc : this.intervals) {
            Summary summary = (Summary)this.summaryByInterval.get(sc);
            if (summary == null) continue;
            System.err.println(sc.getChromosomeName() + "\t" + (sc.getStart() + 1) + "\t" + (sc.getEnd() + 1) + "\t" + sc.getId() + "\t" + summary.toString(this.groupNamesSorted));
        }
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar ccs [-v] [-q] file.tfam file.bed file.vcf");
        System.err.println("Where:");
        System.err.println("\tfile.tfam  : File with genotypes and groups informations (groups are in familyId)");
        System.err.println("\tfile.bed   : File with regions of interest (intervals in BED format)");
        System.err.println("\tfile.vcf   : A VCF file (variants and genotype data)");
        System.err.println("\nOptions:");
        System.err.println("\t-q       : Be quiet");
        System.err.println("\t-v       : Be verbose");
        System.exit(1);
    }
}

