/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.annotate;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.annotate.DbVcfIndex;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;

public class DbVcfTabix
extends DbVcfIndex {
    public static final int MIN_SEEK = 100;

    public DbVcfTabix(String dbFileName) {
        super(dbFileName);
    }

    @Override
    protected boolean dbSeek(String chr, int pos) {
        return this.vcfDbFile.seek(chr, pos);
    }

    @Override
    public void open() {
        if (this.debug) {
            Gpr.debug("Open database file:" + this.dbFileName);
        }
        this.vcfDbFile = new VcfFileIterator(this.dbFileName);
        this.vcfDbFile.setDebug(this.debug);
        if (!this.vcfDbFile.isTabix()) {
            throw new RuntimeException("Could not open VCF file as TABIX-indexed: '" + this.dbFileName + "'");
        }
        this.nextVcfDb = (VcfEntry)this.vcfDbFile.next();
        this.addNextVcfDb();
    }

    @Override
    protected boolean shouldSeek(VcfEntry vcfEntry) {
        return vcfEntry.getEnd() - this.nextVcfDb.getStart() > 100;
    }
}

