/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.annotate;

import ca.mcgill.mcb.pcingola.fileIterator.SeekableBufferedReader;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.annotate.DbVcfIndex;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.FileIndexChrPos;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.io.IOException;

public class DbVcfSorted
extends DbVcfIndex {
    public static final int MIN_SEEK = 1000;
    protected FileIndexChrPos indexDb;

    public DbVcfSorted(String dbFileName) {
        super(dbFileName);
    }

    @Override
    public void close() {
        super.close();
        this.indexDb.close();
    }

    protected void createIndex() {
        if (this.verbose) {
            System.err.println("Index database file:" + this.dbFileName);
        }
        this.indexDb = new FileIndexChrPos(this.dbFileName);
        this.indexDb.setVerbose(this.verbose);
        this.indexDb.setDebug(this.debug);
        this.indexDb.open();
        this.indexDb.index();
        if (this.debug) {
            System.err.println("Index:\n" + this.indexDb);
        }
    }

    @Override
    protected boolean dbSeek(String chr, int pos) {
        long filePosChr = this.indexDb.getStart(chr);
        if (filePosChr < 0L) {
            return false;
        }
        try {
            long filePos = this.indexDb.find(chr, pos, true);
            if (filePos < 0L) {
                this.vcfDbFile.seek(filePosChr);
                return false;
            }
            this.vcfDbFile.seek(filePos);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void open() {
        if (this.debug) {
            Gpr.debug("Open database file:" + this.dbFileName);
        }
        this.createIndex();
        try {
            this.vcfDbFile = new VcfFileIterator(new SeekableBufferedReader(this.dbFileName));
            this.vcfDbFile.setDebug(false);
            this.nextVcfDb = (VcfEntry)this.vcfDbFile.next();
            this.addNextVcfDb();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean shouldSeek(VcfEntry vcfEntry) {
        return vcfEntry.getEnd() - this.nextVcfDb.getStart() > 1000;
    }
}

