/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.annotate;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.annotate.DbVcf;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.FileIndexChrPos;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;

public class DbVcfMem
extends DbVcf {
    public static final int SHOW = 10000;
    public static final int SHOW_LINES = 1000000;
    protected FileIndexChrPos indexDb;

    public DbVcfMem(String dbFileName) {
        super(dbFileName);
    }

    void loadDatabase() {
        this.checkRepeat = false;
        if (this.verbose) {
            Timer.showStdErr("Loading database: '" + this.dbFileName + "'");
        }
        VcfFileIterator dbFile = new VcfFileIterator(this.dbFileName);
        dbFile.setDebug(this.debug);
        int count2 = 1;
        for (VcfEntry vcfDbEntry : dbFile) {
            this.add(vcfDbEntry);
            ++count2;
            if (!this.verbose) continue;
            if (count2 % 1000000 == 0) {
                System.err.print("\n" + count2 + "\t.");
                continue;
            }
            if (count2 % 10000 != 0) continue;
            System.err.print('.');
        }
        if (this.verbose) {
            System.err.println("");
            Timer.showStdErr("Done. Database size: " + this.size());
        }
    }

    @Override
    public void open() {
        this.loadDatabase();
    }

    @Override
    public void readDb(VcfEntry ve) {
    }
}

