/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.annotate;

import ca.mcgill.mcb.pcingola.snpSift.annotate.DbVcf;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;

public abstract class DbVcfIndex
extends DbVcf {
    public DbVcfIndex(String dbFileName) {
        super(dbFileName);
    }

    protected abstract boolean dbSeek(String var1, int var2);

    protected boolean dbSeek(VcfEntry vcfEntry) {
        String chr = "";
        int pos = -1;
        if (this.nextVcfDb != null) {
            pos = this.nextVcfDb.getStart();
            chr = this.nextVcfDb.getChromosomeName();
            if (this.debug) {
                Gpr.debug("Position seek:\t" + chr + ":" + pos + "\t->\t" + vcfEntry.getChromosomeName() + ":" + vcfEntry.getStart());
            }
        }
        if (!this.dbSeek(vcfEntry.getChromosomeName(), vcfEntry.getStart())) {
            return false;
        }
        do {
            this.nextVcfDb = (VcfEntry)this.vcfDbFile.next();
            if (this.nextVcfDb == null) {
                return false;
            }
            if (!this.debug) continue;
            Gpr.debug("After seek: " + this.nextVcfDb.getChromosomeName() + ":" + this.nextVcfDb.getStart() + "\t" + chr + ":" + pos);
        } while (this.nextVcfDb.getChromosomeName().equals(chr) && this.nextVcfDb.getStart() <= pos);
        return true;
    }

    @Override
    public abstract void open();

    @Override
    public void readDb(VcfEntry veInput) {
        if (this.debug) {
            Gpr.debug("ReadDb: Looking for " + veInput.getChromosomeName() + ":" + veInput.getStart() + "\tLatest DB: " + (this.latestVcfDb == null ? "null" : this.latestVcfDb.getChromosomeName() + ":" + this.latestVcfDb.getStart()) + "\tNext DB: " + (this.nextVcfDb == null ? "null" : this.nextVcfDb.getChromosomeName() + ":" + this.nextVcfDb.getStart()));
        }
        while (true) {
            if (this.nextVcfDb == null) {
                this.nextVcfDb = (VcfEntry)this.vcfDbFile.next();
                if (this.nextVcfDb == null) {
                    if (this.latestVcfDb == null) {
                        return;
                    }
                    if (this.latestVcfDb.isSameChromo(veInput)) {
                        if (this.debug) {
                            Gpr.debug("Reading: DB finished reading chromosome " + veInput.getChromosomeName() + "\n" + this);
                        }
                        return;
                    }
                    if (!this.dbSeek(veInput)) {
                        return;
                    }
                    if (this.nextVcfDb == null) {
                        if (this.debug) {
                            Gpr.debug("Reading: No more DB entries for chromosome " + veInput.getChromosomeName() + "\n" + this);
                        }
                        return;
                    }
                }
            }
            if (this.debug) {
                Gpr.debug("ReadDb: Looking for " + veInput.getChromosomeName() + ":" + veInput.getStart() + "\tLatest DB: " + (this.latestVcfDb == null ? "null" : this.latestVcfDb.getChromosomeName() + ":" + this.latestVcfDb.getStart()) + "\tNext DB: " + (this.nextVcfDb == null ? "null" : this.nextVcfDb.getChromosomeName() + ":" + this.nextVcfDb.getStart()));
            }
            if (this.nextVcfDb.isSameChromo(veInput)) {
                if (this.shouldSeek(veInput)) {
                    this.clear();
                    if (!this.dbSeek(veInput)) {
                        return;
                    }
                    this.addNextVcfDb();
                    continue;
                }
                if (veInput.getEnd() >= this.nextVcfDb.getStart()) {
                    if (this.debug) {
                        Gpr.debug("Found Db Entry:" + this.nextVcfDb.getChromosomeName() + ":" + this.nextVcfDb.getStart());
                    }
                    this.addNextVcfDb();
                    this.nextVcfDb = (VcfEntry)this.vcfDbFile.next();
                    continue;
                }
                if (veInput.getEnd() < this.nextVcfDb.getStart()) {
                    if (this.debug) {
                        Gpr.debug("No (more) db entries found:\t" + veInput.getChromosomeName() + ":" + veInput.getStart());
                    }
                    return;
                }
                this.clear();
                this.nextVcfDb = (VcfEntry)this.vcfDbFile.next();
                this.addNextVcfDb();
                continue;
            }
            if (this.latestVcfDb != null && this.latestVcfDb.isSameChromo(veInput)) {
                return;
            }
            if (this.debug) {
                Gpr.debug("Chromosome seek:\t" + this.nextVcfDb.getChromosomeName() + ":" + this.nextVcfDb.getStart() + "\t->\t" + veInput.getChromosomeName() + ":" + veInput.getStart());
            }
            this.clear();
            if (!this.dbSeek(veInput)) {
                return;
            }
            this.addNextVcfDb();
        }
    }

    protected abstract boolean shouldSeek(VcfEntry var1);

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Size: " + this.size() + "\n");
        sb.append("\tLatest VCF entry : " + this.latestVcfDb + "\n");
        sb.append("\tNext VCF entry   : " + this.nextVcfDb + "\n");
        sb.append(super.toString());
        return sb.toString();
    }
}

