/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.annotate;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DbVcf {
    protected boolean debug = false;
    protected boolean checkRepeat = true;
    protected boolean useId = true;
    protected boolean useInfoField = true;
    protected boolean useInfoFieldAll = true;
    protected boolean useRefAlt = true;
    protected boolean verbose = false;
    protected String dbFileName;
    protected VcfFileIterator vcfDbFile;
    protected VcfEntry latestVcfDb = null;
    protected VcfEntry nextVcfDb = null;
    protected Map<String, Map<String, String>> dbCurrentInfo = new HashMap<String, Map<String, String>>();
    protected Set<String> infoFields;
    protected Map<String, String> dbCurrentId = new HashMap<String, String>();
    protected Map<String, Boolean> vcfInfoPerAllele = new HashMap<String, Boolean>();
    protected Map<String, Boolean> vcfInfoPerAlleleRef = new HashMap<String, Boolean>();
    protected Set<String> dbVcfEntryAdded = new HashSet<String>();

    public DbVcf(String dbFileName) {
        this.dbFileName = dbFileName;
    }

    protected void add(VcfEntry vcfDb) {
        Map<String, String> info;
        String key;
        if (vcfDb == null) {
            return;
        }
        if (this.checkRepeat) {
            String keyAdded = this.key(vcfDb);
            if (this.dbVcfEntryAdded.contains(keyAdded)) {
                return;
            }
            this.dbVcfEntryAdded.add(keyAdded);
        }
        if (this.useInfoField) {
            this.discoverInfoFields(vcfDb);
        }
        List<Variant> vars = vcfDb.variants();
        for (Variant var : vars) {
            key = this.key(var);
            this.addId(key, vcfDb.getId());
            if (!this.useInfoField) continue;
            info = this.dbInfoFields(vcfDb, var, false);
            this.addInfo(key, info);
        }
        if (this.useInfoField) {
            for (Variant var : vars) {
                key = this.keyRef(var);
                if (this.dbCurrentInfo.containsKey(key)) continue;
                info = this.dbInfoFields(vcfDb, var, true);
                this.addInfo(key, info);
            }
        }
    }

    protected void addId(String key, String id) {
        if (!this.dbCurrentId.containsKey(key)) {
            this.dbCurrentId.put(key, id);
        } else {
            this.dbCurrentId.put(key, this.dbCurrentId.get(key) + "," + id);
        }
    }

    protected void addInfo(String key, Map<String, String> info) {
        if (!this.dbCurrentInfo.containsKey(key)) {
            this.dbCurrentInfo.put(key, info);
        } else {
            Map<String, String> infoOri = this.dbCurrentInfo.get(key);
            for (Map.Entry<String, String> entry : info.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                if (!infoOri.containsKey(k)) {
                    infoOri.put(k, v);
                    continue;
                }
                infoOri.put(k, infoOri.get(k) + "," + v);
            }
        }
    }

    protected void addNextVcfDb() {
        if (this.debug) {
            Gpr.debug("Adding DB entry: " + this.nextVcfDb);
        }
        this.add(this.nextVcfDb);
        this.latestVcfDb = this.nextVcfDb;
        this.nextVcfDb = null;
    }

    protected void clear() {
        if (this.debug) {
            Gpr.debug("Clear: Current size " + this.size());
        }
        this.dbCurrentId.clear();
        this.dbCurrentInfo.clear();
        this.dbVcfEntryAdded.clear();
    }

    public void close() {
        if (this.vcfDbFile != null) {
            this.vcfDbFile.close();
            this.vcfDbFile = null;
        }
    }

    protected Map<String, String> dbInfoFields(VcfEntry vcfDb, Variant var, boolean onlyRef) {
        HashMap<String, String> info = new HashMap<String, String>();
        for (String fieldName : this.infoFields) {
            if (fieldName.isEmpty()) continue;
            String val = null;
            boolean perAlleleRef = this.isVcfInfoPerAlleleRef(fieldName, vcfDb);
            if (onlyRef) {
                if (!perAlleleRef || (val = vcfDb.getInfo(fieldName, var.getReference())) == null) continue;
                info.put(fieldName, val);
                continue;
            }
            boolean perAllele = this.isVcfInfoPerAllele(fieldName, vcfDb);
            val = perAllele || perAlleleRef ? vcfDb.getInfo(fieldName, var.getGenotype()) : vcfDb.getInfo(fieldName);
            if (val == null) continue;
            info.put(fieldName, val);
        }
        return info;
    }

    protected void discoverInfoFields(VcfEntry vcfEntry) {
        if (!this.useInfoFieldAll) {
            return;
        }
        this.infoFields = new HashSet<String>();
        for (String info : vcfEntry.getInfoKeys()) {
            if (info.isEmpty()) continue;
            this.infoFields.add(info);
        }
    }

    protected boolean findDbExists(Variant var) {
        if (this.dbCurrentId.isEmpty()) {
            return false;
        }
        String key = this.key(var);
        return this.dbCurrentId.containsKey(key);
    }

    protected void findDbId(Variant var, Set<String> idSet) {
        if (!this.useId || this.dbCurrentId.isEmpty()) {
            return;
        }
        String key = this.key(var);
        String idField = this.dbCurrentId.get(key);
        if (idField != null) {
            for (String id : idField.split(";")) {
                idSet.add(id);
            }
        }
    }

    protected void findDbInfo(Variant var, Map<String, String> results) {
        if (!this.useInfoField || this.dbCurrentInfo.isEmpty()) {
            return;
        }
        String key = this.key(var);
        Map<String, String> info = this.dbCurrentInfo.get(key);
        for (String infoFieldName : this.infoFields) {
            String newValue;
            String val;
            if (this.isVcfInfoPerAlleleRef(infoFieldName) && !results.containsKey(infoFieldName)) {
                String keyRef = this.keyRef(var);
                Map<String, String> infoRef = this.dbCurrentInfo.get(keyRef);
                val = infoRef == null ? "." : infoRef.get(infoFieldName);
                results.put(infoFieldName, val);
            }
            if (this.isVcfInfoPerAllele(infoFieldName)) {
                newValue = info == null ? null : info.get(infoFieldName);
                String oldValue = results.get(infoFieldName);
                val = (oldValue == null ? "" : oldValue + ",") + (newValue == null ? "." : newValue);
                results.put(infoFieldName, val);
                continue;
            }
            if (results.containsKey(infoFieldName) || (newValue = info == null ? null : info.get(infoFieldName)) == null) continue;
            results.put(infoFieldName, newValue);
        }
    }

    boolean isVcfInfoPerAllele(String fieldName) {
        return this.isVcfInfoPerAllele(fieldName, null);
    }

    boolean isVcfInfoPerAllele(String fieldName, VcfEntry vcfDb) {
        if (this.vcfInfoPerAllele.get(fieldName) == null) {
            if (vcfDb == null) {
                return false;
            }
            VcfHeaderInfo vcfInfo = vcfDb.getVcfInfo(fieldName);
            boolean isPerAllele = vcfInfo != null && (vcfInfo.isNumberOnePerAllele() || vcfInfo.isNumberAllAlleles());
            this.vcfInfoPerAllele.put(fieldName, isPerAllele);
        }
        return this.vcfInfoPerAllele.get(fieldName);
    }

    boolean isVcfInfoPerAlleleRef(String fieldName) {
        return this.isVcfInfoPerAlleleRef(fieldName, null);
    }

    boolean isVcfInfoPerAlleleRef(String fieldName, VcfEntry vcfDb) {
        if (this.vcfInfoPerAlleleRef.get(fieldName) == null) {
            if (vcfDb == null) {
                return false;
            }
            VcfHeaderInfo vcfInfo = vcfDb.getVcfInfo(fieldName);
            boolean isPerAlleleRef = vcfInfo != null && vcfInfo.isNumberAllAlleles();
            this.vcfInfoPerAlleleRef.put(fieldName, isPerAlleleRef);
        }
        return this.vcfInfoPerAlleleRef.get(fieldName);
    }

    protected String key(Variant variant) {
        if (this.useRefAlt) {
            return variant.getChromosomeName() + ":" + variant.getStart() + "_" + variant.getReference() + "/" + variant.getAlt();
        }
        return variant.getChromosomeName() + ":" + variant.getStart();
    }

    protected String key(VcfEntry ve) {
        return ve.getChromosomeName() + "\t" + ve.getStart() + "\t" + ve.getId() + "\t" + ve.getRef() + "\t" + ve.getAltsStr() + "\t" + ve.getInfoStr();
    }

    protected String keyRef(Variant variant) {
        if (this.useRefAlt) {
            return variant.getChromosomeName() + ":" + variant.getStart() + "_" + variant.getReference() + "/" + variant.getReference();
        }
        return variant.getChromosomeName() + ":" + variant.getStart();
    }

    public abstract void open();

    public abstract void readDb(VcfEntry var1);

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setInfoFields(boolean useInfoField, Collection<String> infoFields) {
        this.useInfoField = useInfoField;
        this.useInfoFieldAll = false;
        if (infoFields == null) {
            this.infoFields = null;
            if (useInfoField) {
                this.useInfoFieldAll = true;
            }
        } else {
            this.infoFields = new HashSet<String>();
            this.infoFields.addAll(infoFields);
        }
    }

    public void setUseId(boolean useId) {
        this.useId = useId;
    }

    public void setUseRefAlt(boolean useRefAlt) {
        this.useRefAlt = useRefAlt;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int size() {
        return Math.max(this.dbCurrentId.size(), this.dbCurrentInfo.size());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IDs (size: " + this.dbCurrentId.size() + "):\n");
        for (String key : this.dbCurrentId.keySet()) {
            sb.append("\t'" + key + "' : '" + this.dbCurrentId.get(key) + "'\n");
        }
        sb.append("INFOs:\n");
        for (String key : this.dbCurrentInfo.keySet()) {
            sb.append("\t'" + key + "'\n");
            Map<String, String> vals = this.dbCurrentInfo.get(key);
            for (String ikey : vals.keySet()) {
                sb.append("\t\t'" + ikey + "' = '" + vals.get(ikey) + "'\n");
            }
        }
        return sb.toString();
    }
}

