/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift.annotate;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpSift.annotate.DbVcf;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AnnotateVcfDb {
    public static final int MAX_ERRORS = 10;
    protected boolean verbose;
    protected boolean debug;
    protected boolean useRefAlt = true;
    protected boolean annotateEmpty;
    protected String chrPrev = "";
    protected String existsInfoField = null;
    protected String prependInfoFieldName;
    protected DbVcf dbVcf;
    protected VcfFileIterator vcfDbFile;
    protected HashMap<String, Integer> errCount;

    public boolean annotate(VcfEntry vcfEntry) throws IOException {
        this.dbVcf.readDb(vcfEntry);
        boolean annotated = false;
        HashSet<String> idSet = new HashSet<String>();
        HashMap<String, String> infos = new HashMap<String, String>();
        boolean exists2 = false;
        List<Variant> vars = vcfEntry.variants();
        for (Variant var : vars) {
            this.dbVcf.findDbId(var, idSet);
            this.dbVcf.findDbInfo(var, infos);
            if (this.existsInfoField == null || exists2) continue;
            exists2 |= this.dbVcf.findDbExists(var);
        }
        annotated |= this.annotateIds(vcfEntry, idSet);
        annotated |= this.annotateInfo(vcfEntry, infos);
        if (exists2) {
            this.annotateExists(vcfEntry);
        }
        if (this.debug) {
            Gpr.debug("Database size: " + this.dbVcf.size());
        }
        return annotated;
    }

    protected void annotateExists(VcfEntry vcfEntry) {
        vcfEntry.addInfo(this.existsInfoField, null);
    }

    protected boolean annotateIds(VcfEntry vcfEntry, Set<String> idSet) {
        if (idSet.isEmpty()) {
            return false;
        }
        boolean annotated = false;
        String id = this.uniqueIds(idSet, vcfEntry.getId());
        if (!id.isEmpty()) {
            annotated = true;
            if (!vcfEntry.getId().isEmpty()) {
                id = vcfEntry.getId() + ";" + id;
            }
            vcfEntry.setId(id);
        }
        return annotated;
    }

    protected boolean annotateInfo(VcfEntry vcfEntry, Map<String, String> info) {
        if (info == null || info.isEmpty()) {
            return false;
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(info.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String value2 = info.get(key);
            if (!this.annotateEmpty && (value2 == null || value2.equals("."))) continue;
            if (this.prependInfoFieldName != null) {
                key = this.prependInfoName(key);
            }
            vcfEntry.addInfo(key, value2);
        }
        return true;
    }

    public void close() {
        this.dbVcf.close();
    }

    public void open() {
        this.dbVcf.open();
    }

    protected String prependInfoName(String infoStr) {
        if (infoStr == null || infoStr.isEmpty()) {
            return infoStr;
        }
        StringBuilder sb = new StringBuilder();
        for (String f2 : infoStr.split(";")) {
            sb.append((sb.length() > 0 ? ";" : "") + this.prependInfoFieldName + f2);
        }
        return sb.toString();
    }

    public void setAnnotateEmpty(boolean annotateEmpty) {
        this.annotateEmpty = annotateEmpty;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.dbVcf.setDebug(debug);
    }

    public void setExistsInfoField(String existsInfoField) {
        this.existsInfoField = existsInfoField;
    }

    public void setInfoFields(boolean useInfoFields, Collection<String> infoFields) {
        this.dbVcf.setInfoFields(useInfoFields, infoFields);
    }

    public void setPrependInfoFieldName(String prependInfoFieldName) {
        this.prependInfoFieldName = prependInfoFieldName;
    }

    public void setUseId(boolean useId) {
        this.dbVcf.setUseId(useId);
    }

    public void setUseRefAlt(boolean useRefAlt) {
        this.dbVcf.setUseRefAlt(useRefAlt);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.dbVcf.setVerbose(verbose);
    }

    protected String uniqueIds(Set<String> idSetDb, String idStrVcf) {
        String[] idsVcf;
        for (String id : idsVcf = idStrVcf.split(";")) {
            idSetDb.remove(id);
        }
        StringBuilder sbId = new StringBuilder();
        ArrayList<String> idsSorted = new ArrayList<String>();
        idsSorted.addAll(idSetDb);
        Collections.sort(idsSorted);
        for (String id : idsSorted) {
            sbId.append((sbId.length() > 0 ? ";" : "") + id);
        }
        return sbId.toString();
    }

    protected void warn(String warn) {
        if (!this.errCount.containsKey(warn)) {
            this.errCount.put(warn, 0);
        }
        int count2 = this.errCount.get(warn);
        this.errCount.put(warn, count2 + 1);
        if (count2 < 10) {
            System.err.println("WARNING: " + warn);
        }
    }
}

