/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import java.util.Iterator;

public class VcfLd {
    public static boolean debug = false;
    int countAB;
    int countAb;
    int countaB;
    int countab;
    int countA;
    int counta;
    int countB;
    int countb;
    double D;
    double Dmin;
    double Dmax;
    double pA;
    double pB;
    double qa;
    double qb;
    double rSquare;
    double Dprime;

    void countGenotypes(int genotypeA, int genotypeB) {
        if (genotypeA == 0) {
            ++this.countA;
            if (genotypeB == 0) {
                ++this.countAB;
                ++this.countB;
            } else {
                ++this.countAb;
                ++this.countb;
            }
        } else {
            ++this.counta;
            if (genotypeB == 0) {
                ++this.countaB;
                ++this.countB;
            } else {
                ++this.countab;
                ++this.countb;
            }
        }
    }

    public double getD() {
        return this.D;
    }

    public double getDmax() {
        return this.Dmax;
    }

    public double getDmin() {
        return this.Dmin;
    }

    public double getDprime() {
        return this.Dprime;
    }

    public double getpA() {
        return this.pA;
    }

    public double getpB() {
        return this.pB;
    }

    public double getQa() {
        return this.qa;
    }

    public double getQb() {
        return this.qb;
    }

    public double getrSquare() {
        return this.rSquare;
    }

    public double ld() {
        double countXX = this.countAB + this.countAb + this.countaB + this.countab;
        double pAB = (double)this.countAB / countXX;
        double pAb = (double)this.countAb / countXX;
        double paB = (double)this.countaB / countXX;
        double pab = (double)this.countab / countXX;
        double countX = this.countA + this.counta;
        this.pA = (double)this.countA / countX;
        this.qa = (double)this.counta / countX;
        this.pB = (double)this.countB / countX;
        this.qb = (double)this.countb / countX;
        if (countX != (double)(this.countB + this.countb)) {
            throw new RuntimeException("Counts do not math.\n\tcountA  : " + this.countA + "\tcounta : " + this.counta + "\tTotal: " + (this.countA + this.counta) + "\n\tcountB : " + this.countB + "\tcountb : " + this.countb + "\tTotal : " + (this.countB + this.countb));
        }
        this.D = pAB * pab - pAb * paB;
        this.Dmin = Math.max(-this.pA * this.pB, -this.qa * this.qb);
        this.Dmax = Math.min(this.pA * this.qb, this.qa * this.pB);
        this.rSquare = this.D * this.D / (this.pA * this.qa * this.pB * this.qb);
        double d = this.Dprime = this.D >= 0.0 ? this.D / this.Dmax : this.D / this.Dmin;
        if (debug) {
            Gpr.debug("\n\tD    : " + this.D + "\n\tDmin : " + this.Dmin + "\n\tDmax : " + this.Dmax + "\n\tD'   : " + this.Dprime + "\n\tr^2  : " + this.rSquare + "\n" + "\n\tcountAB : " + this.countAB + "\tcountAb: " + this.countAb + "\tcountaB: " + this.countaB + "\tcountab: " + this.countab + "\tcountXX: " + countXX + "\n\tpAB : " + pAB + "\tpAb : " + pAb + "\tpaB : " + paB + "\tpab : " + pab + "\n" + "\n\tcountA: " + this.countA + "\tcounta: " + this.counta + "\tTotal: " + (this.countA + this.counta) + "\n\tpA : " + this.pA + "\tqa : " + this.qa + "\n" + "\n\tcountB: " + this.countB + "\tcountb: " + this.countb + "\tTotal: " + (this.countB + this.countb) + "\n\tpB : " + this.pB + "\tqb : " + this.qb);
        }
        if (this.D < this.Dmin || this.D > this.Dmax) {
            throw new RuntimeException("D out of range. This should never happen!\n\tD    : " + this.D + "\n\tDmin : " + this.Dmin + "\n\tDmax : " + this.Dmax);
        }
        return this.D;
    }

    public double ld(VcfEntry vcfEntryA, VcfEntry vcfEntryB) {
        String sanity = this.sanityCheck(vcfEntryA, vcfEntryB);
        if (!sanity.isEmpty()) {
            throw new RuntimeException(sanity);
        }
        this.countab = 0;
        this.countaB = 0;
        this.countAb = 0;
        this.countAB = 0;
        this.countb = 0;
        this.countB = 0;
        this.counta = 0;
        this.countA = 0;
        Iterator<VcfGenotype> ita = vcfEntryA.iterator();
        Iterator<VcfGenotype> itb = vcfEntryB.iterator();
        while (ita.hasNext() && itb.hasNext()) {
            VcfGenotype ga = ita.next();
            VcfGenotype gb = itb.next();
            if (!ga.isPhased()) {
                throw new RuntimeException("Only phased genotypes can be used\n\tvcfEntryA:\t" + vcfEntryA);
            }
            if (!gb.isPhased()) {
                throw new RuntimeException("Only phased genotypes can be used\n\tvcfEntryB:\t" + vcfEntryB);
            }
            int[] genA = ga.getGenotype();
            int[] genB = gb.getGenotype();
            this.countGenotypes(genA[0], genB[0]);
            this.countGenotypes(genA[1], genB[1]);
            Gpr.debug(ga + "\tgenA: " + genA[0] + " , " + genA[1] + "\tcountA: " + this.countA);
        }
        return this.ld();
    }

    public String sanityCheck(VcfEntry vcfEntryA, VcfEntry vcfEntryB) {
        if (vcfEntryA.getAlts().length != 1) {
            return "Only entries with one ALT are accepted:\n\tvcfEntryA:\t" + vcfEntryA;
        }
        if (vcfEntryB.getAlts().length != 1) {
            return "Only entries with one ALT are accepted:\n\tvcfEntryB:\t" + vcfEntryB;
        }
        if (vcfEntryA.getVcfGenotypes().size() != vcfEntryB.getVcfGenotypes().size()) {
            return "Number of genotypes do not match\n\tvcfEntryA:\t" + vcfEntryA + "\n\tvcfEntryB:\t" + vcfEntryB;
        }
        return "";
    }

    public void setCount(int countAB, int countAb, int countaB, int countab, int countA, int counta, int countB, int countb) {
        this.countAB = countAB;
        this.countAb = countAb;
        this.countaB = countaB;
        this.countab = countab;
        this.countA = countA;
        this.counta = counta;
        this.countB = countB;
        this.countb = countb;
    }
}

