/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;

public class SnpSiftCmdVcfCheck
extends SnpSift {
    public SnpSiftCmdVcfCheck() {
        super(null, null);
    }

    public SnpSiftCmdVcfCheck(String[] args) {
        super(args, "alleleMatrix");
    }

    void check(String vcfFile) {
        if (this.verbose) {
            Timer.showStdErr("Processing file '" + vcfFile + "'");
        }
        VcfFileIterator vcf = new VcfFileIterator(vcfFile);
        vcf.setDebug(true);
        int count2 = 1;
        for (VcfEntry ve : vcf) {
            Gpr.showMark(count2++, 1000);
        }
        if (this.verbose) {
            Timer.showStdErr("Finished file '" + vcfFile + "'");
        }
    }

    @Override
    public void parse(String[] args) {
        if (args.length < 1) {
            this.usage(null);
        }
    }

    @Override
    public void run() {
        for (String vcfFile : this.args) {
            this.check(vcfFile);
        }
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar vcfCheck file_1.vcf [file_2.vcf ... file_N.vcf]");
        System.exit(1);
    }
}

