/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.ped.PedPedigree;
import ca.mcgill.mcb.pcingola.ped.TfamEntry;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;

public class SnpSiftCmdVcf2Tped
extends SnpSift {
    boolean onlySnp;
    boolean onlyBiAllelic;
    boolean force;
    boolean useNumbers;
    UseMissing useMissing;
    String vcfFile;
    String tfamFile;
    String outputFileName;
    String outTpedFile;
    String outTfamFile;
    PedPedigree pedigree;

    public SnpSiftCmdVcf2Tped(String[] args) {
        super(args, "vcf2tped");
    }

    @Override
    public void init() {
        this.onlySnp = false;
        this.onlyBiAllelic = false;
        this.force = false;
        this.useNumbers = false;
        this.useMissing = UseMissing.MISSING;
    }

    void loadTfam() {
        if (this.verbose) {
            Timer.showStdErr("Loading TFAM file '" + this.tfamFile + "'");
        }
        this.pedigree = new PedPedigree();
        this.pedigree.loadTfam(this.tfamFile);
    }

    @Override
    public void parse(String[] args) {
        if (args.length <= 0) {
            this.usage(null);
        }
        for (int argc = 0; argc < args.length; ++argc) {
            if (args[argc].equals("-useMissingRef")) {
                this.useMissing = UseMissing.REFERENCE;
                continue;
            }
            if (args[argc].equals("-useMissing")) {
                this.useMissing = UseMissing.MISSING;
                continue;
            }
            if (args[argc].equalsIgnoreCase("-num")) {
                this.useNumbers = true;
                continue;
            }
            if (args[argc].equalsIgnoreCase("-onlySnp")) {
                this.onlySnp = true;
                continue;
            }
            if (args[argc].equalsIgnoreCase("-onlyBiAllelic")) {
                this.onlyBiAllelic = true;
                continue;
            }
            if (args[argc].equalsIgnoreCase("-f")) {
                this.force = true;
                continue;
            }
            if (this.isOpt(args[argc])) {
                this.usage("Unknown option '" + args[argc] + "'");
                continue;
            }
            if (this.tfamFile == null) {
                this.tfamFile = args[argc];
                continue;
            }
            if (this.vcfFile == null) {
                this.vcfFile = args[argc];
                continue;
            }
            if (this.outputFileName != null) continue;
            this.outputFileName = args[argc];
        }
        if (this.tfamFile == null) {
            this.usage("Missing paramter 'file.tped'");
        }
        if (this.vcfFile == null) {
            this.usage("Missing paramter 'file.vcf'");
        }
        if (this.outputFileName == null) {
            this.usage("Missing paramter 'outputName'");
        }
        if (!Gpr.canRead(this.vcfFile)) {
            this.fatalError("Cannot read file '" + this.vcfFile + "'");
        }
        if (!Gpr.canRead(this.tfamFile)) {
            this.fatalError("Cannot read file '" + this.tfamFile + "'");
        }
    }

    @Override
    public void run() {
        this.outTpedFile = this.outputFileName + ".tped";
        this.outTfamFile = this.outputFileName + ".tfam";
        if (!this.force && Gpr.canRead(this.outTpedFile)) {
            this.fatalError("VCF file '" + this.outTpedFile + "' already exists.");
        }
        if (!this.force && Gpr.canRead(this.outTfamFile)) {
            this.fatalError("TFAM file '" + this.outTfamFile + "' already exists.");
        }
        this.vcf2Tped(this.vcfFile, this.tfamFile, this.outTfamFile, this.outTpedFile);
    }

    String snpGenotype(VcfEntry ve, VcfGenotype gen, int genoNum) {
        String base = "";
        base = ve.isSnp() ? (genoNum < 0 ? ve.getRef() : gen.getGenotype(genoNum)) : (genoNum < 0 ? "A" : (gen.getGenotype(genoNum).equals(ve.getRef()) ? "A" : "T"));
        if (!this.useNumbers) {
            return base;
        }
        if (base.equalsIgnoreCase("A")) {
            return "1";
        }
        if (base.equalsIgnoreCase("C")) {
            return "2";
        }
        if (base.equalsIgnoreCase("G")) {
            return "3";
        }
        if (base.equalsIgnoreCase("T")) {
            return "4";
        }
        return "0";
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar vcf2tped [options] file.tfam file.vcf outputName");
        System.err.println("Options:");
        System.err.println("\t-f             : Force. Overwrite new files if they exist. Default: " + this.force);
        System.err.println("\t-num           : Use only numbers {1, 2, 3, 4} instead of bases {A, C, G, T}. Default: " + this.useNumbers);
        System.err.println("\t-onlySnp       : Use only SNPs when converting VCF to TPED. Default: " + this.onlySnp);
        System.err.println("\t-onlyBiAllelic : Use only bi-allelic variants. Default: " + this.onlyBiAllelic);
        System.err.println("\t-useMissing    : Use entries with missing genotypes (otherwise they are filtered out). Default: " + (this.useMissing == UseMissing.MISSING));
        System.err.println("\t-useMissingRef : Use entries with missing genotypes marking them as 'reference' instead of 'missing'. Default: " + (this.useMissing == UseMissing.REFERENCE));
        System.err.println("Parameters:");
        System.err.println("\tfile.tfam      : File with genotypes and groups information (in PLINK's TFAM format)");
        System.err.println("\tfile.vcf       : A VCF file (variants and genotype data)");
        System.err.println("\toutputName     : Base name for the new TPED and TFAM files.");
        System.exit(1);
    }

    public void vcf2Tped(String vcfFile, String tfamFile, String outTfamFile, String outTpedFile) {
        if (this.verbose) {
            Timer.showStdErr("Converting file '" + vcfFile + "' to TPED format: '" + outTpedFile + "'");
        }
        int countVcf = 1;
        int countTped = 0;
        int skipMissing = 0;
        int skipNotSnp = 0;
        int skipNonBiAllelic = 0;
        boolean[] useSample = null;
        try {
            VcfFileIterator vcf = new VcfFileIterator(vcfFile);
            vcf.setDebug(this.debug);
            BufferedWriter tped = new BufferedWriter(new FileWriter(outTpedFile));
            boolean isHeader = true;
            for (VcfEntry ve : vcf) {
                if (isHeader) {
                    useSample = this.vcfAndTfamSamples(vcf, tfamFile, outTfamFile);
                    isHeader = false;
                }
                try {
                    if (this.onlyBiAllelic && ve.getAlts().length != 1) {
                        ++skipNonBiAllelic;
                        if (this.debug) {
                            System.err.println("Skipping line " + vcf.getLineNum() + ": Not bi-allelic");
                        }
                    } else if (this.onlySnp && !ve.isSnp()) {
                        ++skipNotSnp;
                        if (this.debug) {
                            System.err.println("Skipping line " + vcf.getLineNum() + ": Not a SNP");
                        }
                    } else {
                        boolean missingValues = false;
                        StringBuilder tpedLine = new StringBuilder();
                        int pos = ve.getStart() + 1;
                        String chr = ve.getChromosomeName();
                        String id = chr + "_" + pos;
                        tpedLine.append(chr + " ");
                        tpedLine.append(id + " ");
                        tpedLine.append("0 ");
                        tpedLine.append(pos + " ");
                        int i = 0;
                        for (VcfGenotype gen : ve) {
                            if (!useSample[i++]) continue;
                            if (gen.getGenotypeCode() < 0) {
                                missingValues = true;
                                if (this.useMissing == UseMissing.REFERENCE) {
                                    String ref = this.snpGenotype(ve, gen, -1);
                                    tpedLine.append(ref + " " + ref + " ");
                                    continue;
                                }
                                tpedLine.append("0 0 ");
                                continue;
                            }
                            String gen0 = this.snpGenotype(ve, gen, 0);
                            String gen1 = this.snpGenotype(ve, gen, 1);
                            if (gen.getGenotype().length == 2) {
                                tpedLine.append(gen0 + " " + gen1 + " ");
                                continue;
                            }
                            if (this.useMissing == UseMissing.REFERENCE) {
                                String ref = ve.getRef();
                                tpedLine.append(ref + " " + ref + " ");
                                continue;
                            }
                            tpedLine.append("0 0 ");
                        }
                        int lastChar = tpedLine.length() - 1;
                        if (tpedLine.charAt(lastChar) == ' ') {
                            tpedLine.deleteCharAt(lastChar);
                        }
                        tpedLine.append('\n');
                        if (this.useMissing != UseMissing.DO_NOT_USE || !missingValues) {
                            tped.write(tpedLine.toString());
                            ++countTped;
                        } else {
                            ++skipMissing;
                            if (this.debug) {
                                System.err.println("Skipping line " + vcf.getLineNum() + ": Missing values");
                            }
                        }
                    }
                    if (!this.verbose || ++countVcf % 1000 != 0) continue;
                    Timer.showStdErr("\tLine " + countVcf + "\t" + ve.getChromosomeName() + ":" + (ve.getStart() + 1));
                }
                catch (Exception e) {
                    Gpr.debug("Exception processing VCF entry : " + ve);
                    e.printStackTrace();
                }
            }
            tped.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.verbose) {
            Timer.showStdErr("Done: \n\tVCF entries converted     : " + countVcf + "\n\tTPED entries              : " + countTped + "\n\tSkipped Non Biallelic     : " + skipNonBiAllelic + "\n\tSkipped Non SNPs          : " + skipNotSnp + "\n\tSkipped Missing genotypes : " + skipMissing);
        }
    }

    boolean[] vcfAndTfamSamples(VcfFileIterator vcf, String tfamFile, String outTfamFile) {
        PedPedigree tfam = new PedPedigree(tfamFile);
        List<String> sampleNamesVcf = vcf.getSampleNames();
        HashSet<String> stfam = new HashSet<String>();
        stfam.addAll(tfam.getSampleIds());
        boolean[] use = new boolean[sampleNamesVcf.size()];
        int i = 0;
        for (String sampleNameVcf : vcf.getSampleNames()) {
            use[i++] = stfam.contains(sampleNameVcf);
        }
        PedPedigree newTfam = new PedPedigree();
        for (String sampleIdVcf : vcf.getSampleNames()) {
            TfamEntry te = tfam.get(sampleIdVcf);
            if (te == null) continue;
            newTfam.add(te);
        }
        if (sampleNamesVcf.size() != tfam.size()) {
            System.err.println("WARNING: Number of samples in TFAM file and VCF file do not match\n\tSamples in VCF file   : " + sampleNamesVcf.size() + "\n\tSamples in TFAM file  : " + tfam.size() + "\n\tSamples in both files : " + newTfam.size());
        }
        if (newTfam.size() <= 0) {
            throw new RuntimeException("New TFAM file has no entries!");
        }
        if (this.verbose) {
            Timer.showStdErr("Saving new TFAM file '" + outTfamFile + "'");
        }
        newTfam.saveTfam(outTfamFile);
        return use;
    }

    public static enum UseMissing {
        DO_NOT_USE,
        MISSING,
        REFERENCE;

    }
}

