/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderInfo;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;
import java.util.HashMap;
import java.util.List;

public class SnpSiftCmdVarType
extends SnpSift {
    public static final int SHOW = 10000;
    public static final int SHOW_LINES = 1000000;
    public static final String VARTYPE = "VARTYPE";
    String vcfFile;
    HashMap<String, String> db = new HashMap();

    public SnpSiftCmdVarType(String[] args) {
        super(args, "varType");
    }

    @Override
    public void annotate(VcfEntry vcfEntry) {
        Boolean isHet;
        if (vcfEntry.getVariantType() != null) {
            vcfEntry.addInfo(vcfEntry.getVariantType().toString(), null);
        }
        if ((isHet = vcfEntry.calcHetero()) != null) {
            vcfEntry.addInfo(isHet != false ? "HET" : "HOM", null);
        }
        StringBuilder sb = new StringBuilder();
        for (Variant sq : vcfEntry.variants()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((Object)sq.getVariantType());
        }
        if (sb.length() > 0) {
            vcfEntry.addInfo(VARTYPE, sb.toString());
        }
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> newHeaders = super.headers();
        newHeaders.add(new VcfHeaderInfo(VARTYPE, VcfInfoType.String, VcfHeaderInfo.VcfInfoNumber.ALLELE.toString(), "Comma separated list of variant types. One per allele"));
        newHeaders.add(new VcfHeaderInfo("SNP", VcfInfoType.Flag, VcfHeaderInfo.VcfInfoNumber.ALLELE.toString(), "Variant is a SNP"));
        newHeaders.add(new VcfHeaderInfo("MNP", VcfInfoType.Flag, VcfHeaderInfo.VcfInfoNumber.ALLELE.toString(), "Variant is a MNP"));
        newHeaders.add(new VcfHeaderInfo("INS", VcfInfoType.Flag, VcfHeaderInfo.VcfInfoNumber.ALLELE.toString(), "Variant is a INS"));
        newHeaders.add(new VcfHeaderInfo("DEL", VcfInfoType.Flag, VcfHeaderInfo.VcfInfoNumber.ALLELE.toString(), "Variant is a DEL"));
        newHeaders.add(new VcfHeaderInfo("MIXED", VcfInfoType.Flag, VcfHeaderInfo.VcfInfoNumber.ALLELE.toString(), "Variant is a MIXED"));
        newHeaders.add(new VcfHeaderInfo("HOM", VcfInfoType.Flag, VcfHeaderInfo.VcfInfoNumber.ALLELE.toString(), "Variant is homozygous"));
        newHeaders.add(new VcfHeaderInfo("HET", VcfInfoType.Flag, VcfHeaderInfo.VcfInfoNumber.ALLELE.toString(), "Variant is heterozygous"));
        return newHeaders;
    }

    @Override
    public void parse(String[] args) {
        int argNum = 0;
        if (args.length == 0) {
            this.usage(null);
        }
        if (args.length >= argNum) {
            this.vcfFile = args[argNum++];
        } else {
            this.usage("Missing 'file.vcf'");
        }
    }

    @Override
    public void run() {
        if (this.verbose) {
            Timer.showStdErr("Annotating variants type entries from: '" + this.vcfFile + "'");
        }
        VcfFileIterator vcf = new VcfFileIterator(this.vcfFile);
        vcf.setDebug(this.debug);
        boolean showHeader = true;
        for (VcfEntry vcfEntry : vcf) {
            if (showHeader) {
                this.addHeaders(vcf);
                String headerStr = vcf.getVcfHeader().toString();
                if (!headerStr.isEmpty()) {
                    System.out.println(headerStr);
                }
                showHeader = false;
            }
            this.annotate(vcfEntry);
            System.out.println(vcfEntry);
        }
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar varType file.vcf > newFile.vcf.");
        System.exit(1);
    }
}

