/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class SnpSiftCmdSplit
extends SnpSift {
    public static final int SHOW = 1000;
    public static final int SHOW_LINES = 100000;
    public static String[] exts = new String[]{".vcf", ".vcf.gz"};
    boolean join;
    String vcfFile;
    StringBuilder header = new StringBuilder();
    int numLines;
    ArrayList<String> fileNames;

    public SnpSiftCmdSplit(String[] args) {
        super(args, "split");
    }

    public ArrayList<String> getFileNames() {
        return this.fileNames;
    }

    public String join(boolean createString) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String file : this.fileNames) {
            if (first) {
                VcfFileIterator vcf = new VcfFileIterator(file);
                vcf.setDebug(this.debug);
                vcf.next();
                if (createString) {
                    sb.append(vcf.getVcfHeader() + "\n");
                } else {
                    System.out.println(vcf.getVcfHeader());
                }
                first = false;
                vcf.close();
            }
            LineFileIterator lfi = new LineFileIterator(file);
            for (String line : lfi) {
                if (line.startsWith("#")) continue;
                if (createString) {
                    sb.append(line + "\n");
                    continue;
                }
                System.out.println(line);
            }
        }
        return sb.toString();
    }

    BufferedWriter newFile(String baseName, String chr, int fileNumber) {
        String outFileName = "";
        outFileName = this.numLines <= 0 ? baseName + "." + chr + ".vcf" : String.format("%s.%03d.vcf", baseName, fileNumber);
        this.fileNames.add(outFileName);
        if (this.verbose) {
            System.err.println("");
            Timer.showStdErr("Creating new file '" + outFileName + "'");
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outFileName));
            out.write(this.header.toString());
            return out;
        }
        catch (Exception e) {
            throw new RuntimeException("Error opening file '" + outFileName + "'");
        }
    }

    @Override
    public void parse(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        this.numLines = -1;
        this.fileNames = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-j")) {
                this.join = true;
                continue;
            }
            if (args[i].equals("-l")) {
                if (i + 1 < args.length) {
                    String numStr = args[++i];
                    this.numLines = Gpr.parseIntSafe(numStr);
                    if (this.numLines > 0) continue;
                    this.usage("Number of lines must be a positive number. num = '" + numStr + "'");
                    continue;
                }
                this.usage("Missing 'num' argument");
                continue;
            }
            if (this.vcfFile != null) continue;
            if (this.join) {
                this.fileNames.add(args[i]);
                continue;
            }
            this.vcfFile = args[i];
        }
        if (this.join) {
            if (this.numLines > 0) {
                this.usage("Cannot use option '-l' when joining files (option '-j').");
            }
            if (this.fileNames.size() <= 1) {
                this.usage("Cannot 'join' less than two files.");
            }
        } else if (this.vcfFile == null) {
            this.usage("Missing 'file.vcf'");
        }
    }

    @Override
    public void run() {
        if (this.join) {
            this.join(false);
        } else {
            this.split();
        }
    }

    void split() {
        if (this.verbose) {
            Timer.showStdErr("Splitting file '" + this.vcfFile + "'");
        }
        String baseName = Gpr.removeExt(this.vcfFile, exts);
        boolean isHeader = true;
        int lineNum = 1;
        int fileNum = 0;
        String chrPrev = "";
        try {
            BufferedWriter out = null;
            LineFileIterator lfi = new LineFileIterator(this.vcfFile);
            for (String line : lfi) {
                if (isHeader) {
                    if (line.startsWith("#")) {
                        this.header.append(line);
                        this.header.append("\n");
                    } else {
                        isHeader = false;
                    }
                }
                if (isHeader) continue;
                String[] fields = line.split("\t", 2);
                String chr = fields[0];
                if (out == null || this.numLines > 0 && this.numLines < lineNum || this.numLines <= 0 && !chr.equals(chrPrev)) {
                    if (out != null) {
                        out.close();
                    }
                    out = this.newFile(baseName, chr, fileNum);
                    ++fileNum;
                    chrPrev = chr;
                    lineNum = 1;
                }
                out.write(line);
                out.write("\n");
                if (this.verbose) {
                    Gpr.showMark(lineNum, 1000);
                }
                ++lineNum;
            }
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing data!");
        }
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar splitChr [-j] [-l <num>] file.vcf [file_2.vcf ... file_N.vcf]");
        System.err.println("Options:");
        System.err.println("\t-j         : Join all files in command line (output = STDOUT).");
        System.err.println("\t-l <num>   : Split by 'num' lines.");
        System.err.println("\tDefault    : Split by chromosome (one file per chromosome).");
        System.exit(1);
    }
}

