/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.align.NeedlemanWunsch;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;

public class SnpSiftCmdSimplifyIndels
extends SnpSift {
    String vcfFileName;

    public SnpSiftCmdSimplifyIndels(String[] args) {
        super(args, "SimplifyIndels");
    }

    @Override
    public void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                this.usage("Unknown command line option '" + arg + "'");
                continue;
            }
            if (this.vcfFileName == null) {
                this.vcfFileName = arg;
                continue;
            }
            this.usage("Unknown argunment '" + arg + "'");
        }
        if (this.vcfFileName == null) {
            this.usage("Missing VCF file");
        }
    }

    @Override
    public void run() {
        VcfFileIterator vcf = new VcfFileIterator(this.vcfFileName);
        vcf.setDebug(this.debug);
        for (VcfEntry ve : vcf) {
            if (vcf.isHeadeSection()) {
                System.out.println(vcf.getVcfHeader());
            }
            if (ve.isInDel()) {
                if (ve.isMultiallelic()) {
                    System.out.println(ve);
                    continue;
                }
                System.out.println(this.simplifyInDel(ve));
                continue;
            }
            System.out.println(ve);
        }
    }

    String simplifyInDel(VcfEntry ve) {
        String line = ve.toString();
        NeedlemanWunsch nw = new NeedlemanWunsch(ve.getRef(), ve.getAltsStr());
        nw.align();
        int startDiff = nw.getOffset();
        String ch = nw.getAlignment();
        if (!ch.startsWith("-") && !ch.startsWith("+")) {
            return ve.toString();
        }
        int pos = ve.getStart() + startDiff;
        String ref = "";
        String alt = "";
        if (ve.getRef().length() < ve.getAltsStr().length()) {
            if (startDiff > 0) {
                ref = "" + ve.getRef().charAt(startDiff - 1);
            }
            alt = ref + nw.getAlignment().substring(1);
        } else {
            if (startDiff > 0) {
                alt = "" + ve.getRef().charAt(startDiff - 1);
            }
            ref = alt + nw.getAlignment().substring(1);
        }
        String[] fields = line.split("\t");
        fields[1] = "" + pos;
        fields[3] = ref;
        fields[4] = alt;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            sb.append((i > 0 ? "\t" : "") + fields[i]);
        }
        return sb.toString();
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar SimplifyIndels [options] file.vcf");
        System.exit(1);
    }
}

