/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.HashSet;

public class SnpSiftCmdRmInfo
extends SnpSift {
    String vcfFileName;
    HashSet<String> infos;
    boolean rmId;

    public SnpSiftCmdRmInfo(String[] args) {
        super(args, "rmInfo");
    }

    @Override
    public void parse(String[] args) {
        this.infos = new HashSet();
        this.rmId = false;
        if (args.length == 0) {
            this.usage(null);
        }
        for (String arg : args) {
            if (this.isOpt(arg)) {
                if (arg.equals("-id")) {
                    this.rmId = true;
                    continue;
                }
                this.usage("Unknown option " + arg);
                continue;
            }
            if (this.vcfFileName == null) {
                this.vcfFileName = arg;
                continue;
            }
            this.infos.add(arg);
        }
        if (this.infos.size() <= 0 && !this.rmId) {
            this.usage("No INFO field names provided.");
        }
    }

    @Override
    public void run() {
        Timer.showStdErr("Reading STDIN");
        VcfFileIterator vcfFile = new VcfFileIterator(this.vcfFileName);
        vcfFile.setDebug(this.debug);
        int entryNum = 1;
        for (VcfEntry vcfEntry : vcfFile) {
            String headerStr;
            if (entryNum == 1 && !(headerStr = vcfFile.getVcfHeader().toString()).isEmpty()) {
                System.out.println(headerStr);
            }
            for (String info : this.infos) {
                vcfEntry.rmInfo(info);
            }
            if (this.rmId) {
                vcfEntry.setId("");
            }
            System.out.println(vcfEntry);
            ++entryNum;
        }
        Timer.showStdErr("Done");
    }

    @Override
    public void usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("Error: " + errMsg);
        }
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + "" + ".jar rmInfo [options] file.vcf infoField_1 infoField_2 ... infoField_N > file_out.vcf");
        System.exit(1);
    }
}

