/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import java.util.List;

public class SnpSiftCmdRemoveReferenceGenotypes
extends SnpSift {
    public static final int SHOW_EVERY = 1000;
    public static final int SHOW_EVERY_NL = 100000;
    String vcfFileName;

    public SnpSiftCmdRemoveReferenceGenotypes(String[] args) {
        super(args, "RemoveReferenceGenotypes");
    }

    @Override
    public void parse(String[] args) {
        if (args.length <= 0) {
            this.vcfFileName = "-";
        } else if (args.length == 1) {
            this.vcfFileName = args[0];
        } else {
            this.usage("Too many arguments");
        }
    }

    @Override
    public void run() {
        Timer.showStdErr("Reading STDIN");
        VcfFileIterator vcfFile = new VcfFileIterator(this.vcfFileName);
        vcfFile.setDebug(this.debug);
        vcfFile.setCreateChromos(true);
        int entryNum = 1;
        for (VcfEntry vcfEntry : vcfFile) {
            String headerStr;
            VcfGenotype nogenotype = null;
            if (entryNum == 1 && !(headerStr = vcfFile.getVcfHeader().toString()).isEmpty()) {
                System.out.println(headerStr);
            }
            List<VcfGenotype> genotypes = vcfEntry.getVcfGenotypes();
            for (int i = 0; i < genotypes.size(); ++i) {
                VcfGenotype genotype = genotypes.get(i);
                if (genotype.isVariant()) continue;
                if (nogenotype == null) {
                    nogenotype = new VcfGenotype(vcfEntry, vcfEntry.getFormat(), ".");
                }
                genotypes.set(i, nogenotype);
            }
            System.out.println(vcfEntry);
            if (entryNum % 1000 == 0) {
                if (entryNum % 100000 == 0) {
                    System.err.println('.');
                } else {
                    System.err.print('.');
                }
            }
            ++entryNum;
        }
        Timer.showStdErr("Done");
    }

    @Override
    public void usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("Error: " + errMsg);
        }
        System.err.println("Usage: cat file.vcf | java -jar " + SnpSift.class.getSimpleName() + "" + ".jar rmRefGen [file.vcf] > file_noref.vcf");
        System.err.println("Options: ");
        System.err.println("\t file.vcf : Input VCF file. Default : STDIN");
        System.exit(1);
    }
}

