/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.ped.PedPedigree;
import ca.mcgill.mcb.pcingola.ped.TfamEntry;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.stats.CountByType;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import java.util.ArrayList;
import java.util.List;

public class SnpSiftCmdPrivate
extends SnpSift {
    boolean headerSummary = true;
    int countLines = 0;
    int countAnnotated = 0;
    String tfamFile;
    String[] sampleNum2group;
    List<String> sampleIds;
    PedPedigree pedigree;

    public SnpSiftCmdPrivate(String[] args) {
        super(args, "private");
    }

    @Override
    public void annotate(VcfEntry ve) {
        String privateGorup = this.privateGroup(ve);
        if (privateGorup != null) {
            ve.addInfo("Private", privateGorup);
            ++this.countAnnotated;
        }
        ++this.countLines;
    }

    void loadTfam() {
        if (this.verbose) {
            Timer.showStdErr("Loading TFAM file '" + this.tfamFile + "'");
        }
        this.pedigree = new PedPedigree();
        this.pedigree.loadTfam(this.tfamFile);
    }

    @Override
    public void parse(String[] args) {
        if (args.length <= 0) {
            this.usage(null);
        }
        for (int argc = 0; argc < args.length; ++argc) {
            if (this.isOpt(args[argc])) {
                this.usage("Unknown option '" + args[argc] + "'");
                continue;
            }
            if (this.tfamFile == null) {
                this.tfamFile = args[argc];
                continue;
            }
            if (this.vcfInputFile != null) continue;
            this.vcfInputFile = args[argc];
        }
        if (this.tfamFile == null) {
            this.usage("Missing paramter 'file.tped'");
        }
    }

    List<String> parseSampleIds(VcfFileIterator vcf) {
        this.sampleIds = vcf.getSampleNames();
        CountByType countByGroup = new CountByType();
        this.sampleNum2group = new String[this.sampleIds.size()];
        int sampleNum = 0;
        int missing = 0;
        for (String id : this.sampleIds) {
            TfamEntry tfam = this.pedigree.get(id);
            String groupId = "";
            if (tfam == null) {
                ++missing;
                System.err.println("WARNING: VCF sample '" + id + "' not found in TFAM file.");
            } else {
                groupId = tfam.getFamilyId();
            }
            this.sampleNum2group[sampleNum] = groupId;
            countByGroup.inc(groupId);
            ++sampleNum;
        }
        if (missing == this.sampleIds.size()) {
            throw new RuntimeException("All samples are missing in TFAM file!");
        }
        if (this.verbose) {
            System.err.println("Counts by group:\nGroup\tCount\n" + countByGroup);
        }
        return this.sampleIds;
    }

    String privateGroup(VcfEntry ve) {
        String groupPrev = null;
        int sampleNum = 0;
        for (VcfGenotype gen : ve) {
            String group;
            if (gen.isVariant() && !(group = this.sampleNum2group[sampleNum]).isEmpty()) {
                if (groupPrev == null) {
                    groupPrev = group;
                } else if (!group.equals(groupPrev)) {
                    return null;
                }
            }
            ++sampleNum;
        }
        return groupPrev;
    }

    @Override
    public void run() {
        this.run(false);
    }

    public List<VcfEntry> run(boolean createList) {
        this.loadTfam();
        this.countLines = 0;
        this.countAnnotated = 0;
        ArrayList<VcfEntry> vcfEntries = new ArrayList<VcfEntry>();
        VcfFileIterator vcf = this.openVcfInputFile();
        vcf.setDebug(this.debug);
        for (VcfEntry ve : vcf) {
            if (vcf.isHeadeSection()) {
                this.sampleIds = this.parseSampleIds(vcf);
                vcf.getVcfHeader().addLine("##INFO=<ID=Private,Number=1,Type=String,Description=\"If the variant is private (i.e. belongs only to one group or family) the group name is shown. Groups from file = '" + this.tfamFile + "'\">");
                if (!createList) {
                    System.out.println(vcf.getVcfHeader());
                }
            }
            this.annotate(ve);
            if (createList) {
                vcfEntries.add(ve);
                continue;
            }
            System.out.println(ve);
        }
        if (this.verbose) {
            Timer.showStdErr("Done.\n\tVCF entries: " + this.countLines + "\n\tVCF entries annotated: " + this.countAnnotated);
        }
        return vcfEntries;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar private file.tfam file.vcf");
        System.err.println("Where:");
        System.err.println("\tfile.tfam  : File with genotypes and groups information (in PLINK's TFAM format)");
        System.err.println("\tfile.vcf   : A VCF file (variants and genotype data). Default: 'STDIN'");
        System.exit(1);
    }
}

