/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.BedFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SnpSiftCmdPhastCons
extends SnpSift {
    public static final String START_FIELD = "start=";
    public static final String FIXED_STEP_FIELD = "fixedStep";
    public static final String VCF_INFO_PHASTCONS_FIELD = "PhastCons";
    public static final int SHOW_EVERY = 1000;
    boolean bed;
    boolean extract;
    int minBases;
    double minScore;
    String phastConsDir;
    String vcfFile;
    HashMap<String, Integer> chromoSize;
    short[] score;

    public SnpSiftCmdPhastCons(String[] args) {
        super(args, "phastCons");
    }

    void annotateBed(Variant seqChange) {
        float score = this.score(seqChange);
        this.printBed(seqChange, score);
    }

    void annotateVcf(VcfEntry ve) {
        float score = this.score(ve);
        if ((double)score > this.minScore) {
            ve.addInfo(VCF_INFO_PHASTCONS_FIELD, String.format("%.3f", Float.valueOf(score)));
        }
    }

    int chromoSize(String chromo) {
        Integer len = this.chromoSize.get(Chromosome.simpleName(chromo));
        return len == null ? 0 : len;
    }

    void extractBed(Variant seqChange) {
        for (int start = seqChange.getStart(); start <= seqChange.getEnd() - this.minBases; ++start) {
            Variant sc = this.extractBed(seqChange, start);
            if (sc == null) continue;
            this.printBed(sc, this.score(sc));
            start = sc.getEnd() + 1;
        }
    }

    Variant extractBed(Variant seqChange, int start) {
        int prevEnd = -1;
        int end = start + this.minBases - 1;
        Variant scPrev = new Variant(seqChange.getParent(), start, end, seqChange.getId());
        Variant sc = scPrev;
        float score = this.score(sc);
        if ((double)score < this.minScore) {
            return null;
        }
        while ((double)score >= this.minScore) {
            scPrev = sc;
            prevEnd = end++;
            sc = new Variant(seqChange.getParent(), start, end, seqChange.getId());
            score = this.score(sc);
        }
        if (prevEnd > 0) {
            return scPrev;
        }
        return null;
    }

    String findPhastConsFile(String dirName, String regex) {
        try {
            File dir = new File(dirName);
            for (File f2 : dir.listFiles()) {
                String fname = f2.getCanonicalPath();
                if (!fname.matches(regex)) continue;
                return fname;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Timer.showStdErr("Cannot find any file in directory '" + dirName + "' matching regular expression '" + regex + "'");
        return null;
    }

    @Override
    public void init() {
        this.minScore = 0.0;
        this.bed = false;
    }

    boolean loadChromo(String chromo, Marker marker) {
        chromo = Chromosome.simpleName(chromo);
        this.score = null;
        String wigFile = this.findPhastConsFile(this.phastConsDir, ".*/chr" + chromo + "\\..*wigFix.*");
        if (wigFile == null || !Gpr.exists(wigFile)) {
            if (wigFile != null) {
                Timer.showStdErr("Cannot open PhastCons file '" + wigFile + "' for chromosome '" + chromo + "'\n\tEntry:\t" + marker);
            }
            return false;
        }
        if (this.verbose) {
            Timer.showStdErr("Loading phastCons data for chromosome '" + chromo + "', file '" + wigFile + "'");
        }
        int chrSize = this.chromoSize(chromo) + 1;
        this.score = new short[chrSize];
        for (int i = 0; i < this.score.length; ++i) {
            this.score[i] = 0;
        }
        LineFileIterator lfi = new LineFileIterator(wigFile);
        int index = 0;
        int countHeaders = 1;
        for (String line : lfi) {
            if (line.startsWith(FIXED_STEP_FIELD)) {
                String[] fields;
                for (String f2 : fields = line.split("\\s+")) {
                    if (!f2.startsWith(START_FIELD)) continue;
                    String value2 = f2.substring(START_FIELD.length());
                    index = Gpr.parseIntSafe(value2) - 1;
                    if (!this.verbose) continue;
                    Gpr.showMark(countHeaders++, 1000);
                }
                continue;
            }
            if (index >= this.score.length) {
                Timer.showStdErr("PhastCons index out of chromosome boundaries.\n\tIndex             : " + index + "\n\tChromosome length : " + this.score.length);
                break;
            }
            this.score[index] = (short)(Gpr.parseFloatSafe(line) * 1000.0f);
            ++index;
        }
        if (this.verbose) {
            int countNonZero = 0;
            for (int i = 0; i < this.score.length; ++i) {
                if (this.score[i] == 0) continue;
                ++countNonZero;
            }
            double perc = 100.0 * (double)countNonZero / (double)this.score.length;
            System.err.println("");
            Timer.showStdErr(String.format("Total non-zero scores: %d / %d [%.2f%%]", countNonZero, this.score.length, perc));
        }
        return index > 0;
    }

    void loadFaidx() {
        String file = this.phastConsDir + "/genome.fai";
        if (!Gpr.exists(file)) {
            throw new RuntimeException("Cannot find fasta index file '" + file + "'\n\tYou can create one by running 'samtools faidx' command and copying the resulting index file to " + file + "\n\n");
        }
        this.chromoSize = new HashMap();
        String txt = Gpr.readFile(file);
        for (String line : txt.split("\n")) {
            String[] fields = line.split("\\s+");
            String chrName = Chromosome.simpleName(fields[0]);
            int len = Gpr.parseIntSafe(fields[1]);
            this.chromoSize.put(chrName, len);
        }
    }

    @Override
    public void parse(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        for (int argNum = 0; argNum < args.length; ++argNum) {
            String arg = args[argNum];
            if (this.isOpt(arg)) {
                if (arg.equals("-bed")) {
                    this.bed = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-minScore")) {
                    if (argNum >= args.length) {
                        this.usage("Missing 'minScore' number");
                    }
                    this.minScore = Gpr.parseDoubleSafe(args[++argNum]);
                    continue;
                }
                if (arg.equalsIgnoreCase("-extract")) {
                    if (argNum >= args.length) {
                        this.usage("Missing 'extract' number");
                    }
                    this.extract = true;
                    this.minBases = Gpr.parseIntSafe(args[++argNum]);
                    continue;
                }
                this.usage("Unknown command line option '" + arg + "'");
                continue;
            }
            if (this.phastConsDir == null) {
                this.phastConsDir = args[argNum];
                continue;
            }
            if (this.vcfFile != null) continue;
            this.vcfFile = args[argNum];
        }
        if (this.phastConsDir == null) {
            this.usage("Missing 'phastConsDir' parameter.");
        }
        if (this.vcfFile == null) {
            this.usage("Missing 'inputFile' parameter.");
        }
        if (this.extract && this.minBases <= 0) {
            this.usage("Number of bases to extract should be greater than zero.");
        }
    }

    void printBed(Variant seqChange, float score) {
        System.out.print(seqChange.getChromosomeName() + "\t" + seqChange.getStart() + "\t" + (seqChange.getEnd() + 1) + "\t" + seqChange.getId());
        if ((double)score > this.minScore) {
            System.out.print(String.format("\t%.3f", Float.valueOf(score)));
        }
        System.out.println("");
    }

    @Override
    public void run() {
        this.run(false);
    }

    public List<VcfEntry> run(boolean createList) {
        this.loadFaidx();
        if (this.bed) {
            this.runBed();
            return new ArrayList<VcfEntry>();
        }
        return this.runVcf(createList);
    }

    void runBed() {
        BedFileIterator bedFile = new BedFileIterator(this.vcfFile);
        String chrPrev = "";
        for (Variant sc : bedFile) {
            if (!chrPrev.equals(sc.getChromosomeName())) {
                chrPrev = sc.getChromosomeName();
                this.loadChromo(chrPrev, sc);
            }
            if (this.extract) {
                this.extractBed(sc);
                continue;
            }
            this.annotateBed(sc);
        }
    }

    List<VcfEntry> runVcf(boolean createList) {
        ArrayList<VcfEntry> list2 = new ArrayList<VcfEntry>();
        VcfFileIterator vcf = new VcfFileIterator(this.vcfFile);
        vcf.setDebug(this.debug);
        String chrPrev = "";
        for (VcfEntry ve : vcf) {
            if (vcf.isHeadeSection()) {
                vcf.getVcfHeader().addLine("##INFO=<ID=PhastCons,Number=1,Type=Float,Description=\"PhastCons conservation score\">");
                if (!createList) {
                    System.out.println(vcf.getVcfHeader());
                }
            }
            if (!chrPrev.equals(ve.getChromosomeName())) {
                chrPrev = ve.getChromosomeName();
                this.loadChromo(chrPrev, ve);
            }
            this.annotateVcf(ve);
            if (createList) {
                list2.add(ve);
                continue;
            }
            System.out.println(ve);
        }
        return list2;
    }

    float score(Marker marker) {
        int pos = marker.getEnd();
        if (this.score == null || pos >= this.score.length) {
            return Float.MIN_VALUE;
        }
        if (marker.size() == 1) {
            return (float)this.score[marker.getStart()] / 1000.0f;
        }
        int sum2 = 0;
        for (int p = marker.getStart(); p <= marker.getEnd(); ++p) {
            sum2 += this.score[p];
        }
        return (float)sum2 / (1000.0f * (float)marker.size());
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar [options] path/to/phastCons/dir inputFile");
        System.err.println("Arguments:");
        System.err.println("\tinputFile       : VCF or BED file.");
        System.err.println("Options:");
        System.err.println("\t-bed            : Input is a BED file.");
        System.err.println("\t-extract <num>  : Extract sub intervals of at least 'num' bases, having a conservarion score of at least 'minScore'. Only when input is a BED file.");
        System.err.println("\t-minScore <num> : Only annotate is score is greater to 'num'. Default: " + this.minScore);
        System.exit(1);
    }
}

