/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.BedFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.FileIndexChrPos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SnpSiftCmdIntervalsIndex
extends SnpSift {
    boolean listCommandLine;
    List<Variant> seqChanges;
    Genome genome;
    int inOffset;
    String vcfFile;
    String bedFile;

    public SnpSiftCmdIntervalsIndex(String[] args) {
        super(args, "intidx");
    }

    @Override
    public void init() {
        this.genome = new Genome("genome");
        this.listCommandLine = false;
        this.seqChanges = new ArrayList<Variant>();
        this.inOffset = 0;
        this.vcfFile = null;
        this.bedFile = null;
    }

    public void loadIntervals() {
        if (this.verbose) {
            Timer.showStdErr("Reading BED file '" + this.bedFile + "'");
        }
        BedFileIterator bf = new BedFileIterator(this.bedFile, this.genome);
        bf.setCreateChromos(true);
        this.seqChanges = bf.load();
        Collections.sort(this.seqChanges);
        if (this.verbose) {
            Timer.showStdErr("Total " + this.seqChanges.size() + " intervals added.");
        }
    }

    @Override
    public void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (this.isOpt(args[i])) {
                if (args[i].equals("-if")) {
                    if (i + 1 >= args.length) continue;
                    this.inOffset = Gpr.parseIntSafe(args[++i]);
                    continue;
                }
                if (!args[i].equals("-i")) continue;
                this.listCommandLine = true;
                this.inOffset = 1;
                continue;
            }
            if (this.vcfFile == null) {
                this.vcfFile = args[i];
                continue;
            }
            if (this.bedFile != null) continue;
            if (this.listCommandLine) {
                this.seqChanges.add(this.parsePos(args[i]));
                continue;
            }
            this.bedFile = args[i];
        }
        if (this.vcfFile == null) {
            this.usage("Missing BED file");
        }
        if (this.listCommandLine && this.seqChanges.size() <= 0) {
            this.usage("Missing intervals");
        }
        if (!this.listCommandLine && this.bedFile == null) {
            this.usage("Missing VCF file");
        }
    }

    Variant parsePos(String pos) {
        String[] recs = pos.split(":");
        if (recs.length != 2) {
            this.usage("Invalid interval '" + pos + "'. Format 'chr:start-end'");
        }
        String chr = recs[0];
        String[] p = recs[1].split("-");
        if (p.length != 2) {
            this.usage("Invalid interval '" + pos + "'. Format 'chr:start-end'");
        }
        int start = Gpr.parseIntSafe(p[0]) - this.inOffset;
        int end = Gpr.parseIntSafe(p[1]) - this.inOffset;
        Chromosome chromo = new Chromosome(this.genome, 0, 0, chr);
        return new Variant((Marker)chromo, start, end, "");
    }

    @Override
    public void run() {
        if (!this.listCommandLine) {
            this.loadIntervals();
        }
        VcfFileIterator vcfFileIt = new VcfFileIterator(this.vcfFile);
        vcfFileIt.setDebug(this.debug);
        vcfFileIt.iterator().next();
        this.addHeaders(vcfFileIt);
        String headerStr = vcfFileIt.getVcfHeader().toString();
        if (!headerStr.isEmpty()) {
            System.out.println(headerStr);
        }
        vcfFileIt.close();
        FileIndexChrPos fileIndexChrPos = new FileIndexChrPos(this.vcfFile);
        if (this.verbose) {
            Timer.showStdErr("Indexing file '" + this.vcfFile + "'");
        }
        fileIndexChrPos.setVerbose(this.verbose);
        fileIndexChrPos.setDebug(this.debug);
        fileIndexChrPos.open();
        fileIndexChrPos.index();
        if (this.verbose) {
            Timer.showStdErr("Done");
        }
        int scNum = 1;
        for (Variant sc : this.seqChanges) {
            try {
                if (this.verbose) {
                    Timer.showStdErr(scNum + " / " + this.seqChanges.size() + "\t\tFinding interval: " + sc.getChromosomeName() + ":" + (sc.getStart() + 1) + "-" + (sc.getEnd() + 1));
                }
                fileIndexChrPos.dump(sc.getChromosomeName(), sc.getStart(), sc.getEnd(), false);
                ++scNum;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (this.verbose) {
            Timer.showStdErr("Done");
        }
    }

    public void setInOffset(int inOffset) {
        this.inOffset = inOffset;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar intidx [-if N] [-i] file.vcf ( file.bed | chr:start1-end1 chr:start2-end2 ... chr:startN-endN )");
        System.err.println("Option:");
        System.err.println("\t-if <N>   : Input offset. Default 0 (i.e. zero-based coordinates).");
        System.err.println("\t-i        : Genomic intervals in command line.");
        System.exit(1);
    }
}

