/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SnpSiftCmdIntersect
extends SnpSift {
    int cluster;
    int minOverlap;
    boolean intersect;
    List<String> fileNames;
    List<String> notFileNames;
    List<IntervalForest> forests;
    List<IntervalForest> notForests;

    public SnpSiftCmdIntersect(String[] args) {
        super(args, "intersect");
    }

    Marker intersect(Marker m) {
        boolean updated2;
        if (this.forests.size() == 1) {
            return m;
        }
        HashSet<Marker> done = new HashSet<Marker>();
        done.add(m);
        int numIntersect = 1;
        do {
            updated2 = false;
            for (IntervalForest forest : this.forests) {
                Markers query = forest.query(m);
                for (Marker q : query) {
                    if (done.contains(q) || m.intersectSize(q) < this.minOverlap) continue;
                    ++numIntersect;
                    String newId = m.getId() + "+" + q.getId();
                    m = this.intersect ? m.intersect(q) : m.union(q);
                    m.setId(newId);
                }
            }
        } while (updated2);
        if (numIntersect >= this.cluster) {
            return m;
        }
        return null;
    }

    boolean isNot(Marker marker) {
        if (this.notForests.isEmpty()) {
            return false;
        }
        for (IntervalForest intfor : this.notForests) {
            if (intfor.query(marker).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void parse(String[] args) {
        if (args.length <= 0) {
            this.usage(null);
        }
        this.intersect = true;
        this.cluster = 2;
        this.minOverlap = 1;
        this.fileNames = new ArrayList<String>();
        this.notFileNames = new ArrayList<String>();
        for (int argc = 0; argc < args.length; ++argc) {
            if (this.isOpt(args[argc])) {
                String arg = args[argc].toLowerCase();
                if (arg.equals("-intersect")) {
                    this.intersect = true;
                    continue;
                }
                if (arg.equals("-union")) {
                    this.intersect = false;
                    continue;
                }
                if (arg.equals("-minoverlap")) {
                    this.minOverlap = Gpr.parseIntSafe(args[++argc]);
                    continue;
                }
                if (arg.equals("-cluster")) {
                    this.cluster = Gpr.parseIntSafe(args[++argc]);
                    continue;
                }
                if (arg.equals("-not")) {
                    this.notFileNames.add(args[++argc]);
                    continue;
                }
                this.usage("Unknown option '" + args[argc] + "'");
                continue;
            }
            this.fileNames.add(args[argc]);
        }
        if (this.fileNames.size() < 1) {
            this.usage("Missing files to intersect");
        }
    }

    @Override
    public void run() {
        IntervalForest ifor;
        Markers markers;
        Markers markersAll = new Markers();
        Markers markersNotAll = new Markers();
        this.forests = new ArrayList<IntervalForest>();
        for (String fileName : this.fileNames) {
            if (this.verbose) {
                Timer.showStdErr("Loading file '" + fileName + "'");
            }
            markers = Markers.readMarkers(fileName);
            if (this.verbose) {
                Timer.showStdErr("Done. Markers in file : " + markers.size());
            }
            ifor = new IntervalForest();
            ifor.add(markers);
            ifor.build();
            this.forests.add(ifor);
            if (this.verbose) {
                Timer.showStdErr("Interval forest added.");
            }
            markersAll.add(markers);
        }
        if (this.verbose) {
            Timer.showStdErr("Total number of markers (all files) : " + markersAll.size());
        }
        this.notForests = new ArrayList<IntervalForest>();
        for (String fileName : this.notFileNames) {
            if (this.verbose) {
                Timer.showStdErr("Loading 'NOT' file '" + fileName + "'");
            }
            markers = Markers.readMarkers(fileName);
            if (this.verbose) {
                Timer.showStdErr("Done. Markers in file : " + markers.size());
            }
            ifor = new IntervalForest();
            ifor.add(markers);
            ifor.build();
            this.notForests.add(ifor);
            if (this.verbose) {
                Timer.showStdErr("Interval forest added.");
            }
            markersNotAll.add(markers);
        }
        if (this.verbose && !this.notFileNames.isEmpty()) {
            Timer.showStdErr("Total number of 'NOT' markers (all files) : " + markersNotAll.size());
        }
        System.out.println("# SnpSift 4.1i (build 2015-08-14), by Pablo Cingolani");
        System.out.println("# Command line: " + this.commandLineStr());
        int coutFilteredOut = 0;
        HashSet<String> done = new HashSet<String>();
        markersAll.sort();
        for (Marker m : markersAll) {
            Marker mi = this.intersect(m);
            if (mi == null) continue;
            if (this.isNot(mi)) {
                ++coutFilteredOut;
                continue;
            }
            String key = mi.getChromosomeName() + "\t" + mi.getStart() + "\t" + (mi.getEnd() + 1);
            if (done.contains(key)) continue;
            System.out.println(key + "\t" + mi.getId());
            done.add(key);
        }
        if (this.verbose) {
            Timer.showStdErr("Total number of markers intersected : " + done.size() + (coutFilteredOut > 0 ? "\n\tFiltered out : " + coutFilteredOut : ""));
        }
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar [options] file_1.bed file_2.bed ... file_N.bed");
        System.err.println("Options:");
        System.err.println("\t-minOverlap <num> : Minimum number of bases that two intervals have to overlap. Default : " + this.minOverlap);
        System.err.println("\t-cluster <num>    : An interval has to intersect at least 'num' intervals (from other files) to be considered. Default: " + this.cluster);
        System.err.println("\t-intersect        : Report the intersection of all intervals. Default: " + this.intersect);
        System.err.println("\t-union            : Report the union of all intervals. Default: " + !this.intersect);
        System.err.println("\t-not <file>       : Only report if it does NOT intersect with any interval in this file (i.e. filter out if intersects)");
        System.exit(1);
    }
}

