/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.snpSift.gwasCatalog.GwasCatalog;
import ca.mcgill.mcb.pcingola.snpSift.gwasCatalog.GwasCatalogEntry;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderInfo;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;
import java.util.List;

public class SnpSiftCmdGwasCatalog
extends SnpSift {
    public final String GWAS_CATALOG_TRAIT = "GWASCAT";
    public static final int SHOW = 10000;
    public static final int SHOW_LINES = 1000000;
    GwasCatalog gwasCatalog;

    public SnpSiftCmdGwasCatalog(String[] args) {
        super(args, "gwasCat");
    }

    void annotate() {
        this.readDb();
        VcfFileIterator vcf = this.openVcfInputFile();
        vcf.setDebug(this.debug);
        int countAnnotated = 0;
        int count2 = 0;
        boolean showHeader = true;
        for (VcfEntry vcfEntry : vcf) {
            if (showHeader) {
                this.addHeaders(vcf);
                String headerStr = vcf.getVcfHeader().toString();
                if (!headerStr.isEmpty()) {
                    System.out.println(headerStr);
                }
                showHeader = false;
            }
            boolean annotated = false;
            List<GwasCatalogEntry> list2 = this.gwasCatalog.get(vcfEntry.getChromosomeName(), vcfEntry.getStart());
            if (list2 != null && !list2.isEmpty()) {
                annotated = true;
                String annotation = this.vcfAnnotation(list2);
                vcfEntry.addInfo("GWASCAT", annotation);
            }
            System.out.println(vcfEntry);
            if (annotated) {
                ++countAnnotated;
            }
            ++count2;
        }
        double perc = 100.0 * (double)countAnnotated / (double)count2;
        if (this.verbose) {
            Timer.showStdErr("Done.\n\tTotal annotated entries : " + countAnnotated + "\n\tTotal entries           : " + count2 + "\n\tPercent                 : " + String.format("%.2f%%", perc));
        }
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> newHeaders = super.headers();
        newHeaders.add(new VcfHeaderInfo("GWASCAT", VcfInfoType.String, VcfHeaderInfo.VcfInfoNumber.UNLIMITED.toString(), "Trait related to this chromosomal position, according to GWAS catalog"));
        return newHeaders;
    }

    @Override
    public void init() {
        this.needsConfig = true;
        this.needsDb = true;
        this.dbTabix = false;
        this.dbType = "gwascatalog";
    }

    @Override
    public void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg) && (arg.equals("-h") || arg.equals("-help"))) {
                this.usage(null);
                continue;
            }
            if (this.vcfInputFile == null) {
                this.vcfInputFile = arg;
                continue;
            }
            this.usage("VCF input file already assigned to '" + this.vcfInputFile + "'");
        }
    }

    public void readDb() {
        if (this.verbose) {
            Timer.showStdErr("Loading database: '" + this.dbFileName + "'");
        }
        this.gwasCatalog = new GwasCatalog(this.dbFileName);
    }

    @Override
    public void run() {
        if (this.config == null) {
            this.loadConfig();
        }
        this.dbFileName = this.databaseFindOrDownload();
        if (this.verbose) {
            Timer.showStdErr("Annotating\n\tInput file    : '" + (this.vcfInputFile != null ? this.vcfInputFile : "STDIN") + "'\n" + "\tDatabase file : '" + this.dbFileName + "'");
        }
        this.annotate();
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar gwasCat [file.vcf] > newFile.vcf.");
        this.usageGenericAndDb();
        System.exit(1);
    }

    String vcfAnnotation(List<GwasCatalogEntry> list2) {
        StringBuilder sb = new StringBuilder();
        for (GwasCatalogEntry ge : list2) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(ge.getTraitCode());
        }
        return sb.toString();
    }
}

