/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.snpSift.lang.LangFactory;
import ca.mcgill.mcb.pcingola.snpSift.lang.Value;
import ca.mcgill.mcb.pcingola.snpSift.lang.expression.Expression;
import ca.mcgill.mcb.pcingola.snpSift.lang.expression.FieldIterator;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.EffFormatVersion;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderEntry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class SnpSiftCmdGtFilter
extends SnpSift {
    boolean inverse;
    boolean exceptionIfNotFound;
    String expression;
    String gtFieldName;
    String gtFieldValue;
    Expression expr;
    String filterId;
    ArrayList<HashSet<String>> sets;
    EffFormatVersion formatVersion;

    public SnpSiftCmdGtFilter() {
        super(null, "filter");
    }

    public SnpSiftCmdGtFilter(String[] args) {
        super(args, "filter");
    }

    public void addSet(String fileName) {
        String file = Gpr.readFile(fileName);
        if (file.isEmpty()) {
            throw new RuntimeException("Could not read any entries from file '" + fileName + "'");
        }
        HashSet<String> set = new HashSet<String>();
        for (String str : file.split("\n")) {
            set.add(str.trim());
        }
        this.sets.add(set);
        if (this.verbose) {
            System.err.println("Adding set '" + fileName + "', " + set.size() + " elements.");
        }
    }

    void addVcfFilter(VcfEntry vcfEntry, String filterStr) {
        String filter2 = vcfEntry.getFilterPass();
        if (filter2.equals(".")) {
            filter2 = "";
        }
        filter2 = filter2 + (!filter2.isEmpty() ? ";" : "") + filterStr;
        vcfEntry.setFilterPass(filter2);
    }

    void delVcfFilter(VcfEntry vcfEntry, String filterStr) {
        String filter2 = vcfEntry.getFilterPass();
        StringBuilder sbFilter = new StringBuilder();
        boolean removed = false;
        for (String f2 : filter2.split(";")) {
            if (!f2.equals(filterStr)) {
                sbFilter.append((sbFilter.length() > 0 ? ";" : "") + f2);
                continue;
            }
            removed = true;
        }
        if (removed) {
            if (this.debug) {
                Gpr.debug("REMOVE:" + filter2 + "\t" + filterStr + "\t=>\t" + sbFilter);
            }
            vcfEntry.setFilterPass(sbFilter.toString());
        }
    }

    boolean evaluate(VcfEntry vcfEntry) {
        if (this.debug) {
            Gpr.debug(vcfEntry.toStringNoGt());
        }
        boolean ok = false;
        for (VcfGenotype vgt : vcfEntry) {
            boolean change = this.evaluate(vcfEntry, vgt);
            if (this.debug) {
                Gpr.debug("\t\tevaluate:" + change + "\t" + vgt);
            }
            if (!change) continue;
            ok = true;
            vgt.set(this.gtFieldName, this.gtFieldValue);
        }
        if (this.debug && ok) {
            Gpr.debug("VCF entry changed:\t" + vcfEntry);
        }
        return ok;
    }

    boolean evaluate(VcfEntry vcfEntry, VcfGenotype vcfGenotype) {
        FieldIterator fieldIterator = FieldIterator.get();
        fieldIterator.reset();
        boolean all = true;
        boolean any = false;
        if (this.debug) {
            Gpr.debug("VCF entry:" + vcfEntry.toStringNoGt() + "\t" + vcfGenotype);
        }
        while (true) {
            Value eval = this.expr.eval(vcfGenotype);
            if (this.debug) {
                Gpr.debug("\tEval: " + eval + "\tFieldIterator: " + fieldIterator);
            }
            any |= eval.asBool();
            if (fieldIterator.getType() == -2 && !(all &= eval.asBool())) {
                boolean ret = this.inverse ^ all;
                if (this.debug) {
                    Gpr.debug("\tResult [ALL]: " + ret);
                }
                return ret;
            }
            if (fieldIterator.getType() == -1 && any) {
                boolean ret = this.inverse ^ any;
                if (this.debug) {
                    Gpr.debug("\tResult [ANY]: " + ret);
                }
                return ret;
            }
            if (!fieldIterator.hasNext()) break;
            fieldIterator.next();
        }
        boolean ret = false;
        if (fieldIterator.getType() == -2) {
            ret = all;
            if (this.debug) {
                Gpr.debug("\tResult [ALL]: " + ret);
            }
        } else {
            ret = any;
            if (this.debug) {
                Gpr.debug("\tResult [ANY]: " + ret);
            }
        }
        ret = this.inverse ^ ret;
        if (this.debug && this.inverse) {
            Gpr.debug("\tResult [INV]: " + ret);
        }
        return ret;
    }

    public List<VcfEntry> filter(String fileName, String expression, boolean createList) {
        this.vcfInputFile = fileName;
        this.expression = expression;
        return this.run(createList);
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> addHeader = super.headers();
        String expr = this.expression.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim();
        if (!this.filterId.isEmpty()) {
            addHeader.add(new VcfHeaderEntry("##FILTER=<ID=" + this.filterId + ",Description=\"" + "SnpSift 4.1i (build 2015-08-14), by Pablo Cingolani" + ", Expression used: " + expr + "\">"));
        }
        return addHeader;
    }

    @Override
    public void init() {
        this.verbose = false;
        this.inverse = false;
        this.vcfInputFile = "-";
        this.filterId = SnpSift.class.getSimpleName();
        this.sets = new ArrayList();
        this.formatVersion = null;
        this.exceptionIfNotFound = false;
        this.gtFieldName = "GT";
        this.gtFieldValue = ".";
    }

    @Override
    public void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                if (arg.equals("-h") || arg.equalsIgnoreCase("-help")) {
                    this.usage(null);
                    continue;
                }
                if (arg.equals("-f") || arg.equalsIgnoreCase("--file")) {
                    this.vcfInputFile = args[++i];
                    continue;
                }
                if (arg.equals("-s") || arg.equalsIgnoreCase("--set")) {
                    this.addSet(args[++i]);
                    continue;
                }
                if (arg.equalsIgnoreCase("--errMissing")) {
                    this.exceptionIfNotFound = true;
                    continue;
                }
                if (arg.equals("-n") || arg.equalsIgnoreCase("--inverse")) {
                    this.inverse = true;
                    continue;
                }
                if (arg.equals("-gn") || arg.equalsIgnoreCase("--field")) {
                    this.gtFieldName = args[++i];
                    continue;
                }
                if (arg.equals("-gv") || arg.equalsIgnoreCase("--value")) {
                    this.gtFieldValue = args[++i];
                    continue;
                }
                if (arg.equalsIgnoreCase("--format")) {
                    String formatVer;
                    if ((formatVer = args[++i]).equals("2")) {
                        this.formatVersion = EffFormatVersion.FORMAT_EFF_2;
                        continue;
                    }
                    if (formatVer.equals("3")) {
                        this.formatVersion = EffFormatVersion.FORMAT_EFF_3;
                        continue;
                    }
                    this.usage("Unknown format version '" + formatVer + "'");
                    continue;
                }
                if (arg.equals("-e") || arg.equalsIgnoreCase("--exprfile")) {
                    String exprFile = args[++i];
                    if (this.verbose) {
                        System.err.println("Reading expression from file '" + exprFile + "'");
                    }
                    this.expression = Gpr.readFile(exprFile);
                    continue;
                }
                this.usage("Unknown option '" + arg + "'");
                continue;
            }
            if (this.expression == null) {
                this.expression = arg;
                continue;
            }
            if (this.vcfInputFile == null) {
                this.vcfInputFile = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.expression == null) {
            this.usage("Missing filter expression!");
        }
    }

    public Expression parseExpression(String expression) throws Exception {
        if (this.debug) {
            Gpr.debug("Parse expression: \"" + expression + "\"");
        }
        LangFactory lf = new LangFactory();
        this.expr = lf.compile(expression);
        if (this.expr == null) {
            System.err.println("Fatal error: Cannot build expression tree.");
            System.exit(-1);
        }
        if (this.debug) {
            Gpr.debug("Expression: " + this.expr);
        }
        return this.expr;
    }

    @Override
    public void run() {
        this.run(false);
    }

    public List<VcfEntry> run(boolean createList) {
        if (this.debug) {
            Expression.debug = true;
        }
        try {
            this.parseExpression(this.expression);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.usage("Error parsing expression: '" + this.expression + "'");
        }
        LinkedList<VcfEntry> passEntries = createList ? new LinkedList<VcfEntry>() : null;
        VcfFileIterator vcfFile = this.openVcfInputFile();
        this.showHeader = !createList;
        for (VcfEntry vcfEntry : vcfFile) {
            this.processVcfHeader(vcfFile);
            this.evaluate(vcfEntry);
            if (passEntries != null) {
                passEntries.add(vcfEntry);
                continue;
            }
            System.out.println(vcfEntry);
        }
        return passEntries;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.out.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + "" + ".jar filter [options] 'expression' [input.vcf]");
        System.err.println("Options:");
        System.err.println("\t-e  | --exprFile <file>    : Read expression from a file");
        System.err.println("\t-f|--file <input.vcf>      : VCF input file. Default: STDIN");
        System.err.println("\t-gn | --field <name>       : Field name to replace if filter is true. Default: '" + this.gtFieldName + "'");
        System.err.println("\t-gv | --value <value>      : Field value to replace if filter is true. Default: '" + this.gtFieldValue + "'");
        System.err.println("\t-n  | --inverse            : Inverse. Show lines that do not match filter expression");
        System.err.println("\t-s  | --set <file>         : Create a SET using 'file'");
        System.err.println("\t--errMissing               : Error is a field is missing. Default: " + this.exceptionIfNotFound);
        System.err.println("\t--format <format>          : SnpEff format version: {2, 3}. Default: " + (this.formatVersion == null ? "Auto" : this.formatVersion));
        System.exit(-1);
    }
}

