/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.geneSets.GeneSet;
import ca.mcgill.mcb.pcingola.geneSets.GeneSets;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.stats.CountByType;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderInfo;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class SnpSiftCmdGeneSets
extends SnpSift {
    public static final int SHOW = 10000;
    public static final int SHOW_LINES = 1000000;
    public static final String INFO_GENE_SETS = "MSigDb";
    String vcfFile;
    String msigdb;
    GeneSets geneSets;
    CountByType countByGeneSet = new CountByType();

    public SnpSiftCmdGeneSets(String[] args) {
        super(args, "geneSets");
    }

    @Override
    public void annotate(VcfEntry vcfEntry) {
        HashSet<String> sets = null;
        for (VcfEffect eff : vcfEntry.parseEffects()) {
            HashSet<GeneSet> geneSetsByGene;
            String gene = eff.getGeneName();
            if (gene == null || gene.isEmpty()) continue;
            if (sets == null) {
                sets = new HashSet<String>();
            }
            if ((geneSetsByGene = this.geneSets.getGeneSetsByGene(gene)) == null) continue;
            for (GeneSet gs : geneSetsByGene) {
                String geneSetName = gs.getName();
                sets.add(geneSetName);
            }
        }
        if (sets != null && !sets.isEmpty()) {
            for (String geneSetName : sets) {
                this.countByGeneSet.inc(geneSetName);
            }
            ArrayList setsSorted = new ArrayList();
            setsSorted.addAll(sets);
            Collections.sort(setsSorted);
            StringBuilder setssb = new StringBuilder();
            for (String s : setsSorted) {
                String setName = VcfEntry.vcfInfoSafe(s);
                setssb.append((setssb.length() > 0 ? "," : "") + setName);
            }
            vcfEntry.addInfo(INFO_GENE_SETS, setssb.toString());
        }
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> newHeaders = super.headers();
        newHeaders.add(new VcfHeaderInfo(INFO_GENE_SETS, VcfInfoType.String, VcfHeaderInfo.VcfInfoNumber.UNLIMITED.toString(), "Gene set from MSigDB database (GSEA)"));
        return newHeaders;
    }

    @Override
    public void parse(String[] args) {
        int argNum = 0;
        if (args.length == 0) {
            this.usage(null);
        }
        if (args.length > argNum) {
            this.msigdb = args[argNum++];
        }
        if (args.length > argNum) {
            this.vcfFile = args[argNum++];
        }
        if (this.msigdb == null) {
            this.usage("Missing 'msigdb.gmt'");
        }
        if (this.vcfFile == null) {
            this.usage("Missing 'file.vcf'");
        }
    }

    @Override
    public void run() {
        this.run(false);
    }

    public List<VcfEntry> run(boolean createList) {
        LinkedList<VcfEntry> results = new LinkedList<VcfEntry>();
        if (this.verbose) {
            Timer.showStdErr("Reading MSigDb from file: '" + this.msigdb + "'");
        }
        this.geneSets = new GeneSets(this.msigdb);
        if (this.verbose) {
            Timer.showStdErr("Done. Total:\n\t" + this.geneSets.getGeneSetCount() + " gene sets\n\t" + this.geneSets.getGeneCount() + " genes");
        }
        if (this.verbose) {
            Timer.showStdErr("Annotating variants from: '" + this.vcfFile + "'");
        }
        VcfFileIterator vcf = new VcfFileIterator(this.vcfFile);
        vcf.setDebug(this.debug);
        for (VcfEntry vcfEntry : vcf) {
            if (vcf.isHeadeSection()) {
                this.addHeaders(vcf);
                String headerStr = vcf.getVcfHeader().toString();
                if (!headerStr.isEmpty()) {
                    this.print(headerStr);
                }
            }
            this.annotate(vcfEntry);
            this.print(vcfEntry);
            if (!createList) continue;
            results.add(vcfEntry);
        }
        if (this.verbose) {
            Timer.showStdErr("Done.");
            System.err.println("# Summary");
            System.err.println("#\tgene_set\tgene_set_size\tvariants");
            for (String gs : this.countByGeneSet.keysSorted()) {
                System.err.println("#\t" + gs + "\t" + this.geneSets.getGeneSet(gs).size() + "\t" + this.countByGeneSet.get(gs));
            }
        }
        return results;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar miSigDb.gmt file.vcf > file.geneSets.vcf");
        System.exit(1);
    }
}

