/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.collections.AutoHashMap;
import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import gnu.trove.set.hash.TIntHashSet;
import java.util.LinkedList;
import java.util.List;

public class SnpSiftCmdFilterChrPos
extends SnpSift {
    AutoHashMap<String, TIntHashSet> chrpos = new AutoHashMap(new TIntHashSet());
    String chrPosFile;
    int countChrPosLines = 0;
    int countChrPosAdded = 0;
    int countVcfFiltered = 0;

    public SnpSiftCmdFilterChrPos(String[] args) {
        super(args, "filterChrPos");
    }

    protected boolean filter(VcfEntry vcfEntry) {
        return this.hasPos(vcfEntry.getChromosomeName(), vcfEntry.getStart());
    }

    boolean hasPos(String chr, int pos) {
        TIntHashSet posSet = (TIntHashSet)this.chrpos.get(chr);
        if (posSet == null) {
            return false;
        }
        return posSet.contains(pos);
    }

    void loadChrPos() {
        if (this.verbose) {
            Timer.showStdErr("Reading 'chr:pos' from file '" + this.chrPosFile + "'.");
        }
        LineFileIterator lfi = new LineFileIterator(this.chrPosFile);
        for (String line : lfi) {
            ++this.countChrPosLines;
            if (line.startsWith("#")) continue;
            String[] fields = line.split("\t", 3);
            String chr = fields[0];
            int pos = Gpr.parseIntSafe(fields[1]);
            if (pos <= 0 || !this.chrpos.getOrCreate(chr = Chromosome.simpleName(chr)).add(--pos)) continue;
            ++this.countChrPosAdded;
        }
        if (this.verbose) {
            Timer.showStdErr("Done.\n\t\tLines         : " + this.countChrPosLines + "\n\t\tEntries added : " + this.countChrPosAdded);
        }
    }

    @Override
    public void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) continue;
            if (this.chrPosFile == null) {
                this.chrPosFile = arg;
                continue;
            }
            if (this.vcfInputFile == null) {
                this.vcfInputFile = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.chrPosFile == null) {
            this.usage("No chrpos.txt file provided.");
        }
    }

    @Override
    public void run() {
        this.run(false);
    }

    public List<VcfEntry> run(boolean createList) {
        LinkedList<VcfEntry> passEntries = createList ? new LinkedList<VcfEntry>() : null;
        this.loadChrPos();
        this.showHeader = !createList;
        VcfFileIterator vcfFile = this.openVcfInputFile();
        int countVcfLines = 0;
        for (VcfEntry vcfEntry : vcfFile) {
            ++countVcfLines;
            this.processVcfHeader(vcfFile);
            if (this.filter(vcfEntry)) {
                this.print(vcfEntry);
                ++this.countVcfFiltered;
                if (passEntries != null) {
                    passEntries.add(vcfEntry);
                }
            }
            if (!this.verbose) continue;
            Gpr.showMark(countVcfLines, SHOW_EVERY_VCFLINES);
        }
        if (this.verbose) {
            Timer.showStdErr("Done filtering.\n\t\tVCF lines                : " + countVcfLines + "\n\t\tVCF lines passing filter : " + this.countVcfFiltered + "\n\t\tChrPos lines             : " + this.countChrPosLines + "\n\t\tChrPos entries added     : " + this.countChrPosAdded);
        }
        return passEntries;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.out.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + "" + ".jar filter [options] chrpos.txt [input.vcf]");
        System.err.println("\nFile 'chrpos.txt' is parsed as follows:");
        System.err.println("\t- First two (tab-separated) columns are 'chr' and 'pos'.");
        System.err.println("\t- Other columns are ignored.");
        System.err.println("\t- Lines starting with '#' are ignored.");
        System.err.println("\t- Positions are one-based (same as in VCF files).");
        System.exit(-1);
    }
}

