/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.DbNsfpEntry;
import ca.mcgill.mcb.pcingola.fileIterator.DbNsfpFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SnpSiftCmdDbNsfp
extends SnpSift {
    public static final String VCF_INFO_PREFIX = "dbNSFP_";
    public static final String DEFAULT_FIELDS_NAMES_TO_ADD = "Uniprot_acc,Interpro_domain,SIFT_pred,Polyphen2_HDIV_pred,Polyphen2_HVAR_pred,LRT_pred,MutationTaster_pred,GERP++_NR,GERP++_RS,phastCons100way_vertebrate,,1000Gp1_AF,1000Gp1_AFR_AF,1000Gp1_EUR_AF,1000Gp1_AMR_AF,1000Gp1_ASN_AF,ESP6500_AA_AF,ESP6500_EA_AF,MutationTaster_pred,MutationAssessor_pred,FATHMM_pred,PROVEAN_pred,CADD_phred,MetaSVM_pred,1000Gp3_AC,1000Gp3_AF,1000Gp3_AFR_AC,1000Gp3_AFR_AF,1000Gp3_EUR_AC,1000Gp3_EUR_AF,1000Gp3_AMR_AC,1000Gp3_AMR_AF,1000Gp3_EAS_AC,1000Gp3_EAS_AF,1000Gp3_SAS_AC,1000Gp3_SAS_AF,ESP6500_AA_AC,ESP6500_AA_AF,ESP6500_EA_AC,ESP6500_EA_AF,ExAC_AC,ExAC_AF,ExAC_Adj_AC,ExAC_Adj_AF,ExAC_AFR_AC,ExAC_AFR_AF,ExAC_AMR_AC,ExAC_AMR_AF,ExAC_EAS_AC,ExAC_EAS_AF,ExAC_FIN_AC,ExAC_FIN_AF,ExAC_NFE_AC,ExAC_NFE_AF,ExAC_SAS_AC,ExAC_SAS_AF";
    public static final int MIN_JUMP = 100;
    public static final int SHOW_ANNOTATED = 1;
    protected Map<String, String> fieldsToAdd;
    protected Map<String, String> fieldsDescription;
    protected Map<String, String> fieldsType;
    protected boolean annotateEmpty;
    protected boolean collapseRepeatedValues;
    protected boolean inverseFieldSelection;
    protected boolean tabixCheck = true;
    protected String vcfFileName;
    protected int count = 0;
    protected int countAnnotated = 0;
    protected DbNsfpFileIterator dbNsfpFile;
    protected VcfFileIterator vcfFile;
    protected DbNsfpEntry currentDbEntry;
    protected String fieldsNamesToAdd;
    String latestChromo = "";

    public SnpSiftCmdDbNsfp(String[] args) {
        super(args, "dbnsfp");
    }

    @Override
    public boolean addHeaders(VcfFileIterator vcfFile) {
        super.addHeaders(vcfFile);
        for (String fieldName : this.fieldsToAdd.keySet()) {
            String type = this.fieldsType.get(fieldName);
            if (type == null) {
                System.err.println("WARNING: Cannot find type for field '" + fieldName + "', using 'String'.");
                type = VcfInfoType.String.toString();
            }
            vcfFile.getVcfHeader().addLine("##INFO=<ID=dbNSFP_" + fieldName + ",Number=A,Type=" + type + ",Description=\"" + this.fieldsToAdd.get(fieldName) + "\">");
        }
        return false;
    }

    ArrayList<VcfEntry> annotate(boolean createList) {
        ArrayList<VcfEntry> list2 = createList ? new ArrayList<VcfEntry>() : null;
        try {
            this.initAnnotate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.verbose) {
            Timer.showStdErr("Annotating file '" + this.vcfFileName + "'");
        }
        boolean showHeader = true;
        int pos = -1;
        String chr = "";
        for (VcfEntry vcfEntry : this.vcfFile) {
            try {
                if (showHeader) {
                    this.addHeaders(this.vcfFile);
                    String headerStr = this.vcfFile.getVcfHeader().toString();
                    if (!headerStr.isEmpty()) {
                        this.print(headerStr);
                    }
                    showHeader = false;
                    this.checkFieldsToAdd();
                }
                if (vcfEntry.getChromosomeName().equals(chr) && vcfEntry.getStart() < pos) {
                    this.fatalError("Your VCF file should be sorted!\n\tPrevious entry " + chr + ":" + pos + "\n\tCurrent entry  " + vcfEntry.getChromosomeName() + ":" + (vcfEntry.getStart() + 1));
                }
                this.annotate(vcfEntry);
                this.print(vcfEntry);
                if (list2 != null) {
                    list2.add(vcfEntry);
                }
                ++this.count;
                chr = vcfEntry.getChromosomeName();
                pos = vcfEntry.getStart();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.endAnnotate();
        if (this.verbose) {
            double perc = 100.0 * (double)this.countAnnotated / (double)this.count;
            Timer.showStdErr("Done.\n\tTotal annotated entries : " + this.countAnnotated + "\n\tTotal entries           : " + this.count + "\n\tPercent                 : " + String.format("%.2f%%", perc));
        }
        return list2;
    }

    @Override
    public void annotate(VcfEntry vcf) {
        DbNsfpEntry dbEntry = this.findDbEntry(vcf);
        if (dbEntry == null) {
            return;
        }
        boolean annotated = false;
        StringBuilder info = new StringBuilder();
        for (String fieldKey : this.fieldsToAdd.keySet()) {
            info.setLength(0);
            for (String alt : vcf.getAlts()) {
                String val = dbEntry.getCsv(alt, fieldKey);
                if (this.annotateEmpty) {
                    if (val == null) {
                        val = ".";
                    }
                } else if (this.isDbNsfpValueEmpty(val)) {
                    val = null;
                }
                if (val == null) continue;
                if (info.length() > 0) {
                    info.append(',');
                }
                info.append(val);
            }
            if (!this.annotateEmpty && info.length() <= 0) continue;
            String infoStr = info.toString();
            if (infoStr.isEmpty()) {
                infoStr = ".";
            }
            infoStr = infoStr.replace(';', ',').replace('\t', '_').replace(' ', '_');
            vcf.addInfo(VCF_INFO_PREFIX + fieldKey, infoStr);
            annotated = true;
        }
        if (annotated) {
            ++this.countAnnotated;
            if (this.debug) {
                Gpr.debug("Annotated: " + vcf.getChromosomeName() + ":" + vcf.getStart());
            } else if (this.verbose && this.countAnnotated % 1 == 0) {
                if (this.countAnnotated % 100 == 0) {
                    System.err.print(".\n" + this.countAnnotated + "\t" + vcf.getChromosomeName() + ":" + vcf.getStart() + "\t");
                } else {
                    System.err.print('.');
                }
            }
        }
    }

    public void checkFieldsToAdd() throws IOException {
        if (this.verbose) {
            for (String filedName : this.dbNsfpFile.getFieldNames()) {
                if (this.fieldsDescription.get(filedName) != null) continue;
                System.err.println("WARNING: Field (column) '" + filedName + "' does not have an approriate field descriptor.");
            }
        }
        for (String fieldKey : this.fieldsToAdd.keySet()) {
            if (this.dbNsfpFile.hasField(fieldKey)) continue;
            this.fatalError("dbNsfp does not have field '" + fieldKey + "' (file '" + this.dbFileName + "')");
        }
    }

    public void endAnnotate() {
        this.vcfFile.close();
        this.dbNsfpFile.close();
    }

    public DbNsfpEntry findDbEntry(VcfEntry vcfEntry) {
        if (this.debug) {
            System.err.println("Looking for " + vcfEntry.getChromosomeName() + ":" + vcfEntry.getStart() + ". Current DB: " + (this.currentDbEntry == null ? "null" : this.currentDbEntry.getChromosomeName() + ":" + this.currentDbEntry.getStart()));
        }
        while (true) {
            if (this.currentDbEntry == null) {
                this.currentDbEntry = (DbNsfpEntry)this.dbNsfpFile.next();
                if (this.currentDbEntry == null) {
                    if (this.latestChromo.equals(vcfEntry.getChromosomeName())) {
                        return null;
                    }
                    if (this.debug) {
                        Gpr.debug("New chromosome '" + this.latestChromo + "' != '" + vcfEntry.getChromosomeName() + "': We should jump");
                    }
                    this.dbNsfpFile.seek(vcfEntry.getChromosomeName(), vcfEntry.getStart());
                    this.currentDbEntry = (DbNsfpEntry)this.dbNsfpFile.next();
                    if (this.currentDbEntry == null) {
                        this.latestChromo = vcfEntry.getChromosomeName();
                        return null;
                    }
                }
            }
            if (this.debug) {
                Gpr.debug("Current Db Entry:" + this.currentDbEntry.getChromosomeName() + ":" + this.currentDbEntry.getStart() + "\tLooking for: " + vcfEntry.getChromosomeName() + ":" + vcfEntry.getStart());
            }
            if (this.currentDbEntry.getChromosomeName().equals(vcfEntry.getChromosomeName())) {
                if (vcfEntry.getStart() == this.currentDbEntry.getStart()) {
                    if (this.debug) {
                        Gpr.debug("Found Db Entry:" + this.currentDbEntry.getChromosomeName() + ":" + this.currentDbEntry.getStart());
                    }
                    return this.currentDbEntry;
                }
                if (vcfEntry.getStart() < this.currentDbEntry.getStart()) {
                    if (this.debug) {
                        Gpr.debug("No db entry found:\t" + vcfEntry.getChromosomeName() + ":" + vcfEntry.getStart());
                    }
                    return null;
                }
                if (vcfEntry.getStart() - this.currentDbEntry.getStart() > 100) {
                    if (this.debug) {
                        Gpr.debug("Position jump:\t" + this.currentDbEntry.getChromosomeName() + ":" + this.currentDbEntry.getStart() + "\t->\t" + vcfEntry.getChromosomeName() + ":" + vcfEntry.getStart());
                    }
                    this.dbNsfpFile.seek(vcfEntry.getChromosomeName(), vcfEntry.getStart());
                    this.currentDbEntry = (DbNsfpEntry)this.dbNsfpFile.next();
                } else {
                    this.currentDbEntry = (DbNsfpEntry)this.dbNsfpFile.next();
                }
            } else if (!this.currentDbEntry.getChromosomeName().equals(vcfEntry.getChromosomeName())) {
                if (this.debug) {
                    Gpr.debug("Chromosome jump:\t" + this.currentDbEntry.getChromosomeName() + ":" + this.currentDbEntry.getStart() + "\t->\t" + vcfEntry.getChromosomeName() + ":" + vcfEntry.getStart());
                }
                if (!this.dbNsfpFile.seek(vcfEntry.getChromosomeName(), vcfEntry.getStart())) {
                    return null;
                }
                this.currentDbEntry = (DbNsfpEntry)this.dbNsfpFile.next();
            }
            if (this.currentDbEntry == null) continue;
            this.latestChromo = this.currentDbEntry.getChromosomeName();
        }
    }

    public Map<String, String> getFieldsType() {
        return this.fieldsType;
    }

    @Override
    public void init() {
        this.needsConfig = true;
        this.needsDb = true;
        this.dbTabix = true;
        this.dbType = "dbnsfp";
        this.fieldsToAdd = new HashMap<String, String>();
        this.fieldsType = new HashMap<String, String>();
        this.fieldsDescription = new HashMap<String, String>();
        this.annotateEmpty = false;
        this.collapseRepeatedValues = false;
    }

    public void initAnnotate() throws IOException {
        int i;
        this.vcfFile = new VcfFileIterator(this.vcfFileName);
        this.vcfFile.setDebug(this.debug);
        this.dbNsfpFile = new DbNsfpFileIterator(this.dbFileName);
        this.dbNsfpFile.setCollapseRepeatedValues(this.collapseRepeatedValues);
        if (this.tabixCheck && !this.dbNsfpFile.isTabix()) {
            this.fatalError("Tabix index not found for database '" + this.dbFileName + "'.\n\t\tSnpSift dbNSFP only works with tabix indexed databases, please create or download index.");
        }
        if (this.verbose) {
            Timer.showStdErr("Guessing data types");
        }
        if (!this.dbNsfpFile.guessVcfTypes(this.verbose)) {
            if (this.verbose) {
                String[] fnames = this.dbNsfpFile.getFieldNamesSorted();
                VcfInfoType[] types = this.dbNsfpFile.getTypes();
                Timer.showStdErr("Some data types are missing (using 'string')");
                for (i = 0; i < fnames.length; ++i) {
                    if (types[i] != null) continue;
                    System.err.println("\tColumn " + (i + 1) + "\t" + fnames[i]);
                }
            }
            this.dbNsfpFile.forceMissingTypesAsString();
        }
        if (this.verbose) {
            Timer.showStdErr("Done");
        }
        VcfInfoType[] types = this.dbNsfpFile.getTypes();
        String[] fieldNames = this.dbNsfpFile.getFieldNamesSorted();
        if (this.verbose) {
            Timer.showStdErr("Database fields:");
        }
        for (i = 0; i < fieldNames.length; ++i) {
            String[] type = types[i] != null ? types[i].toString() : "String";
            this.fieldsType.put(fieldNames[i], (String)type);
            this.fieldsDescription.put(fieldNames[i], "Field '" + fieldNames[i] + "' from dbNSFP");
            if (!this.verbose) continue;
            System.err.println("\t'" + fieldNames[i] + "'");
        }
        this.currentDbEntry = null;
        if (this.inverseFieldSelection) {
            String[] fields = new HashSet();
            fields.addAll(this.fieldsDescription.keySet());
            if (this.fieldsNamesToAdd != null) {
                for (String fn : this.fieldsNamesToAdd.split(",")) {
                    fields.remove(fn);
                }
            }
            ArrayList fieldsSort = new ArrayList();
            fieldsSort.addAll(fields);
            Collections.sort(fieldsSort);
            for (String fn : fieldsSort) {
                this.fieldsToAdd.put(fn, this.fieldsDescription.get(fn));
            }
        } else {
            if (this.fieldsNamesToAdd == null) {
                this.fieldsNamesToAdd = DEFAULT_FIELDS_NAMES_TO_ADD;
            }
            for (String fn : this.fieldsNamesToAdd.split(",")) {
                if (this.fieldsDescription.get(fn) == null) {
                    if (this.fieldsNamesToAdd == DEFAULT_FIELDS_NAMES_TO_ADD) {
                        if (!this.verbose) continue;
                        Timer.showStdErr("Warning: Default field name '" + fn + "' not found, ignoring");
                        continue;
                    }
                    this.usage("Error: Field name '" + fn + "' not found");
                    continue;
                }
                this.fieldsToAdd.put(fn, this.fieldsDescription.get(fn));
            }
        }
        if (this.verbose) {
            ArrayList<String> fieldsSort = new ArrayList<String>();
            fieldsSort.addAll(this.fieldsToAdd.keySet());
            Collections.sort(fieldsSort);
            Timer.showStdErr("Fields to add:");
            for (String fn : fieldsSort) {
                System.err.println("\t\t\t" + fn);
            }
        }
    }

    boolean isDbNsfpValueEmpty(String values2) {
        if (values2 == null || values2.isEmpty() || values2.equals(".")) {
            return true;
        }
        for (String val : values2.split(",")) {
            if (val.isEmpty() || val.equals(".")) continue;
            return false;
        }
        return true;
    }

    @Override
    public void parse(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-a")) {
                this.annotateEmpty = true;
                continue;
            }
            if (arg.equals("-f")) {
                this.fieldsNamesToAdd = args[++i];
                continue;
            }
            if (arg.equalsIgnoreCase("-noCollapse")) {
                this.collapseRepeatedValues = false;
                continue;
            }
            if (arg.equalsIgnoreCase("-collapse")) {
                this.collapseRepeatedValues = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-n")) {
                this.inverseFieldSelection = true;
                continue;
            }
            if (this.vcfFileName == null) {
                this.vcfFileName = arg;
                continue;
            }
            this.usage("Unknown extra parameter '" + arg + "'");
        }
        if (this.vcfFileName == null) {
            this.usage("Missing 'file.vcf'");
        }
    }

    @Override
    public void run() {
        this.run(false);
    }

    public List<VcfEntry> run(boolean createList) {
        if (this.config == null) {
            this.loadConfig();
        }
        this.dbFileName = this.databaseFindOrDownload();
        if (this.verbose) {
            Timer.showStdErr("Annotating\n\tInput file    : '" + this.vcfFileName + "'\n" + "\tDatabase file : '" + this.dbFileName + "'");
        }
        return this.annotate(createList);
    }

    public void setTabixCheck(boolean tabixCheck) {
        this.tabixCheck = tabixCheck;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        StringBuilder sb = new StringBuilder();
        for (String f2 : DEFAULT_FIELDS_NAMES_TO_ADD.split(",")) {
            sb.append("\t                - " + f2 + "\n");
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar " + this.command + " [options] file.vcf > newFile.vcf\n" + "Options:\n" + "\t-a            : Annotate fields, even if the database has an empty value (annotates using '.' for empty).\n" + "\t-collapse     : Collapse repeated values from dbNSFP. Default: " + this.collapseRepeatedValues + "\n" + "\t-noCollapse   : Switch off 'collapsing' repeated values from dbNSFP. Default: " + !this.collapseRepeatedValues + "\n" + "\t-n            : Invert 'fields to add' selection (i.e. use all fields except the ones specified in option '-f').\n" + "\t-f            : A comma separated list of fields to add.\n" + "\t                Default fields to add:\n" + sb);
        this.usageGenericAndDb();
        System.err.println("Note: Databse (dbNSFP.txt.gz) must be bgzip and tabix indexed file.\n      The corresponding index file (dbNSFP.txt.gz.tbi) must be present.\n");
        System.exit(1);
    }
}

