/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.collections.AutoHashMap;
import ca.mcgill.mcb.pcingola.fileIterator.SeekableBufferedReader;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.stats.CountByType;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.FileIndexChrPos;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SnpSiftCmdConcordance
extends SnpSift {
    public static final String MISSING_GENOTYPE = "MISSING_GT";
    public static final String MISSING_ENTRY = "MISSING_ENTRY";
    public static final String SEP = "_";
    public static final String SEP_GT = "/";
    public static final int SHOW_EVERY = 10000;
    int countEntries;
    String vcfFileName1;
    String vcfFileName2;
    String name1;
    String name2;
    String chrPrev = "";
    String restrictSamplesFile;
    int[] idx2toidx1;
    String[] sampleNameIdx2;
    CountByType errors = new CountByType();
    CountByType concordance = new CountByType();
    AutoHashMap<String, CountByType> concordanceBySample = new AutoHashMap(new CountByType());
    List<String> labels;
    FileIndexChrPos indexVcf;
    StringBuilder summary = new StringBuilder();
    HashSet<String> restrictSamples;
    protected VcfEntry latestVcfEntry = null;
    int latestVcfPos = 0;
    String latestVcfChr = "";
    boolean writeSummaryFile;
    boolean writeBySampleFile;
    boolean errorOnNonBiallelic;

    public SnpSiftCmdConcordance(String[] args) {
        super(args, "concordance");
    }

    String check(VcfEntry ve1, VcfEntry ve2) {
        if (ve1 == null && ve2 == null) {
            return "ERROR_BOTH_NULL";
        }
        if (ve1 == null || ve2 == null) {
            return "";
        }
        if (this.errorOnNonBiallelic) {
            if (ve1.getAlts().length > 1) {
                this.errors(ve1, ve2, "Multiple ALT in file '" + this.vcfFileName1 + "'");
                return "ERROR_NON_BIALLELIC_" + this.vcfFileName1 + ":" + ve1.getAlts();
            }
            if (ve2.getAlts().length > 1) {
                this.errors(ve1, ve2, "Multiple ALT in file '" + this.vcfFileName2 + "'S");
                return "ERROR_NON_BIALLELIC_" + this.vcfFileName2 + ":" + ve2.getAlts();
            }
        }
        if (!ve1.getAltsStr().equals(ve2.getAltsStr()) && ve1.getAlts().length == 1 && ve2.getAlts().length == 1) {
            this.errors(ve1, ve2, "ALT field does not match");
            return "ERROR_ALT_DOES_NOT_MATCH:" + ve1.getAltsStr() + SEP_GT + ve2.getAltsStr();
        }
        if (!ve1.getRef().equals(ve2.getRef())) {
            this.errors(ve1, ve2, "REF fields does not match");
            return "ERROR_REF_DOES_NOT_MATCH:" + ve1.getRef() + SEP_GT + ve2.getRef();
        }
        if (!ve1.getChromosomeName().equals(ve2.getChromosomeName())) {
            this.errors(ve1, ve2, "CHROMO field does not match");
            return "ERROR_CHROMO_DOES_NOT_MATCH";
        }
        if (ve1.getStart() != ve2.getStart()) {
            this.errors(ve1, ve2, "POS field does not match");
            return "ERROR_POS_DOES_NOT_MATCH";
        }
        return "";
    }

    void concordance(VcfEntry ve1, VcfEntry ve2) {
        String err2 = this.check(ve1, ve2);
        if (this.debug) {
            String s1 = ve1 == null ? "null" : ve1.toStr();
            String s2 = ve2 == null ? "null" : ve2.toStr();
            Gpr.debug("Concordance: " + s1 + "\t" + s2 + "\tErr: " + err2);
        }
        CountByType count2 = new CountByType();
        int gtMax = this.idx2toidx1.length;
        for (int idx2 = 0; idx2 < gtMax; ++idx2) {
            int idx1 = this.idx2toidx1[idx2];
            if (idx1 >= 0) {
                CountByType countBySample = (CountByType)this.concordanceBySample.get(this.sampleNameIdx2[idx2]);
                String key = "";
                if (err2.isEmpty()) {
                    String gen1Str = this.genotypeKey(ve1, idx1, this.name1);
                    String gen2Str = this.genotypeKey(ve2, idx2, this.name2);
                    key = gen1Str + SEP_GT + gen2Str;
                } else {
                    key = "ERROR";
                }
                if (this.debug) {
                    Gpr.debug("Sample " + this.sampleNameIdx2[idx2] + "\tkey:" + key);
                }
                this.concordanceCount(key, count2, countBySample);
                continue;
            }
            if (!this.debug) continue;
            Gpr.debug("Unmatched sample '" + this.sampleNameIdx2[idx2] + "' (number " + idx2 + ") in file " + this.name2);
        }
        this.print(this.showCounts(count2, ve1 != null ? ve1 : ve2, null, err2));
    }

    void concordanceCount(String label, CountByType count2, CountByType countBySample) {
        this.concordance.inc(label);
        count2.inc(label);
        countBySample.inc(label);
    }

    List<String> createLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (int gtCode1 = -2; gtCode1 <= 2; ++gtCode1) {
            for (int gtCode2 = -2; gtCode2 <= 2; ++gtCode2) {
                String label = this.genotypKey(gtCode1, this.name1) + SEP_GT + this.genotypKey(gtCode2, this.name2);
                labels.add(label);
            }
        }
        labels.add("ERROR");
        return labels;
    }

    void errors(VcfEntry ve1, VcfEntry ve2, String message) {
        this.errors.inc(message);
        if (this.verbose) {
            System.err.println("ERROR: " + message + "\n\tVCF entry " + this.name1 + "\t" + ve1 + "\n\tVCF entry " + this.name2 + "\t" + ve2);
        }
    }

    VcfEntry find(VcfFileIterator vcfFile, VcfEntry vcfEntry) throws IOException {
        String chr = vcfEntry.getChromosomeName();
        if (!chr.equals(this.chrPrev) && !this.jumpToChromo(vcfFile, chr)) {
            return null;
        }
        this.chrPrev = chr;
        if (this.latestVcfEntry != null) {
            if (!this.latestVcfEntry.getChromosomeName().equals(chr)) {
                if (this.debug) {
                    Gpr.debug("Find: Different chromosomes :\t" + this.latestVcfEntry.toStr() + "\t" + vcfEntry.toStr());
                }
                return null;
            }
            if (vcfEntry.getStart() < this.latestVcfEntry.getStart()) {
                if (this.debug) {
                    Gpr.debug("Find: Not there yet         :\t" + this.latestVcfEntry.toStr() + "\t" + vcfEntry.toStr());
                }
                return null;
            }
            if (vcfEntry.getStart() == this.latestVcfEntry.getStart()) {
                if (this.debug) {
                    Gpr.debug("Find: Match!                :\t" + this.latestVcfEntry.toStr() + "\t" + vcfEntry.toStr());
                }
                VcfEntry ve = this.latestVcfEntry;
                this.latestVcfEntry = null;
                return ve;
            }
            this.concordance(this.latestVcfEntry, null);
        }
        for (VcfEntry ve : vcfFile) {
            ++this.countEntries;
            if (this.latestVcfChr.equals(ve.getChromosomeName()) && this.latestVcfPos > ve.getStart()) {
                this.fatalError("VCF file '" + this.vcfFileName2 + "' is not properly sorted. Position " + this.latestVcfChr + ":" + (this.latestVcfPos + 1) + " is after position " + this.latestVcfChr + ":" + (ve.getStart() + 1));
            }
            this.latestVcfEntry = ve;
            this.latestVcfChr = ve.getChromosomeName();
            this.latestVcfPos = ve.getStart();
            if (!ve.getChromosomeName().equals(chr)) {
                return null;
            }
            if (vcfEntry.getStart() < this.latestVcfEntry.getStart()) {
                return null;
            }
            if (vcfEntry.getStart() == this.latestVcfEntry.getStart()) {
                this.latestVcfEntry = null;
                return ve;
            }
            this.concordance(this.latestVcfEntry, null);
        }
        if (this.debug) {
            Gpr.debug("Find: No more entried in VCF_1    :\t\t" + vcfEntry.toStr());
        }
        return null;
    }

    String genotypeKey(VcfEntry ve, int gtIndx, String name) {
        if (ve == null) {
            return "MISSING_ENTRY_" + name;
        }
        VcfGenotype gt = ve.getVcfGenotype(gtIndx);
        if (gt.isMissing()) {
            return "MISSING_GT_" + name;
        }
        return this.genotypKey(gt.getGenotypeCode(), name);
    }

    String genotypKey(int gtCode, String name) {
        if (gtCode == -2) {
            return "MISSING_ENTRY_" + name;
        }
        if (gtCode == -1) {
            return "MISSING_GT_" + name;
        }
        if (gtCode == 0) {
            return "REF";
        }
        return "ALT_" + gtCode;
    }

    public CountByType getConcordance() {
        return this.concordance;
    }

    public AutoHashMap<String, CountByType> getConcordanceBySample() {
        return this.concordanceBySample;
    }

    public int getCountEntries() {
        return this.countEntries;
    }

    @Override
    public void init() {
        this.writeBySampleFile = true;
        this.writeSummaryFile = true;
        this.errorOnNonBiallelic = false;
    }

    boolean jumpToChromo(VcfFileIterator vcfFile, String chr) throws IOException {
        if (this.debug) {
            Gpr.debug("Find: Looking for chromosome '" + chr + "'");
        }
        this.readUntilChromosomeEnd(vcfFile, this.chrPrev);
        long start = this.indexVcf.getStart(chr);
        if (start < 0L) {
            this.warn("Chromosome '" + chr + "' not found in database.");
            return false;
        }
        vcfFile.seek(start);
        this.latestVcfEntry = null;
        if (this.verbose) {
            Timer.showStdErr("Chromosome: '" + chr + "'");
        }
        return true;
    }

    @Override
    public void parse(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (args[i].equals("-s")) {
                this.restrictSamplesFile = args[++i];
                continue;
            }
            if (this.vcfFileName1 == null) {
                this.vcfFileName1 = arg;
                continue;
            }
            if (this.vcfFileName2 != null) continue;
            this.vcfFileName2 = arg;
        }
        if (this.vcfFileName2 == null) {
            this.usage("Missing vcf file");
        }
    }

    void parseVcfSampleNames(VcfFileIterator vcf1, VcfFileIterator vcf2) {
        vcf1.readHeader();
        vcf2.readHeader();
        if (vcf1.getSampleNames() == null) {
            this.fatalError("Unable to parse sample names from file '" + this.vcfFileName1 + "'. Missing header line?");
        }
        if (vcf2.getSampleNames() == null) {
            this.fatalError("Unable to parse sample names from file '" + this.vcfFileName2 + "'. Missing header line?");
        }
        HashMap<String, Integer> vcf1Name2Idx = new HashMap<String, Integer>();
        int idx = 0;
        for (String sampleName : vcf1.getSampleNames()) {
            vcf1Name2Idx.put(sampleName, idx++);
        }
        HashMap<String, Integer> vcf2Name2Idx = new HashMap<String, Integer>();
        this.idx2toidx1 = new int[vcf2.getSampleNames().size()];
        this.sampleNameIdx2 = new String[vcf2.getSampleNames().size()];
        idx = 0;
        int shared = 0;
        for (String sampleName : vcf2.getSampleNames()) {
            vcf2Name2Idx.put(sampleName, idx);
            if (this.restrictSamples == null || this.restrictSamples.contains(sampleName)) {
                if (vcf1Name2Idx.containsKey(sampleName)) {
                    ++shared;
                    this.idx2toidx1[idx] = (Integer)vcf1Name2Idx.get(sampleName);
                    this.sampleNameIdx2[idx] = sampleName;
                    this.concordanceBySample.getOrCreate(sampleName);
                    if (this.debug) {
                        System.err.println("\tMap\tSample " + sampleName + "\t" + this.name2 + "[" + idx + "]\t->\t" + this.name1 + "[" + this.idx2toidx1[idx] + "]");
                    }
                } else {
                    this.idx2toidx1[idx] = -1;
                }
            } else {
                this.idx2toidx1[idx] = -1;
            }
            ++idx;
        }
        this.summary("Number of samples:");
        this.summary("\t" + vcf1.getSampleNames().size() + "\tFile " + this.vcfFileName1);
        this.summary("\t" + vcf2.getSampleNames().size() + "\tFile " + this.vcfFileName2);
        if (this.restrictSamples != null) {
            this.summary("\t" + this.restrictSamples.size() + "\tFile " + this.restrictSamplesFile);
        }
        this.summary("\t" + shared + "\tBoth files");
    }

    void readUntilChromosomeEnd(VcfFileIterator vcf, String chr) {
        VcfEntry ve;
        if (this.latestVcfEntry != null) {
            if (this.latestVcfEntry.getChromosomeName().equals(chr)) {
                this.concordance(this.latestVcfEntry, null);
            } else {
                return;
            }
        }
        Iterator iterator2 = vcf.iterator();
        while (iterator2.hasNext() && (ve = (VcfEntry)iterator2.next()).getChromosomeName().equals(chr)) {
            this.concordance(ve, null);
            if (this.verbose && this.countEntries >= 10000) {
                this.countEntries = 0;
                Timer.showStdErr("\t" + (this.latestVcfEntry != null ? this.latestVcfEntry.getChromosomeName() + ":" + (this.latestVcfEntry.getStart() + 1) : "") + "\t" + ve.getChromosomeName() + ":" + (ve.getStart() + 1));
            }
            ++this.countEntries;
        }
    }

    @Override
    public void run() {
        VcfFileIterator vcf2;
        VcfFileIterator vcf1;
        if (this.restrictSamplesFile != null) {
            this.restrictSamples = new HashSet();
            for (String s : Gpr.readFile(this.restrictSamplesFile).split("\n")) {
                this.restrictSamples.add(s.trim());
            }
        }
        this.name1 = this.vcfFile2name(this.vcfFileName1);
        this.name2 = this.vcfFile2name(this.vcfFileName2);
        if (this.verbose) {
            Timer.showStdErr("Indexing file '" + this.vcfFileName1 + "'");
        }
        this.indexVcf = new FileIndexChrPos(this.vcfFileName1);
        this.indexVcf.setVerbose(this.verbose);
        this.indexVcf.setDebug(this.debug);
        this.indexVcf.open();
        this.indexVcf.index();
        this.indexVcf.close();
        try {
            if (this.verbose) {
                Timer.showStdErr("Open VCF file '" + this.vcfFileName1 + "'");
            }
            vcf1 = new VcfFileIterator(new SeekableBufferedReader(this.vcfFileName1));
            vcf1.setDebug(this.debug);
            if (this.verbose) {
                Timer.showStdErr("Open VCF file '" + this.vcfFileName2 + "'");
            }
            vcf2 = new VcfFileIterator(this.vcfFileName2);
            vcf2.setDebug(this.debug);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.parseVcfSampleNames(vcf1, vcf2);
        StringBuilder title = new StringBuilder();
        StringBuilder titleBySample = new StringBuilder();
        title.append("chr\tpos\tref\talt");
        titleBySample.append("sample\t\t\t");
        this.labels = this.createLabels();
        for (String label : this.labels) {
            title.append("\t" + label);
            titleBySample.append("\t" + label);
        }
        this.print(title);
        try {
            int latestPos = 0;
            String latestChr = "";
            for (VcfEntry ve2 : vcf2) {
                if (latestChr.equals(ve2.getChromosomeName()) && latestPos > ve2.getStart()) {
                    this.fatalError("VCF file '" + this.vcfFileName2 + "' is not properly sorted. Position " + latestChr + ":" + (latestPos + 1) + " is after position " + latestChr + ":" + (ve2.getStart() + 1));
                }
                VcfEntry ve1 = this.find(vcf1, ve2);
                this.concordance(ve1, ve2);
                if (this.verbose && this.countEntries >= 10000) {
                    this.countEntries = 0;
                    Timer.showStdErr("\t" + (this.latestVcfEntry != null ? this.latestVcfEntry.getChromosomeName() + ":" + (this.latestVcfEntry.getStart() + 1) : "") + "\t" + ve2.getChromosomeName() + ":" + (ve2.getStart() + 1));
                }
                ++this.countEntries;
                latestChr = ve2.getChromosomeName();
                latestPos = ve2.getStart();
            }
            this.readUntilChromosomeEnd(vcf1, this.chrPrev);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.showResults(titleBySample.toString());
    }

    public void setWriteBySampleFile(boolean writeBySampleFile) {
        this.writeBySampleFile = writeBySampleFile;
    }

    public void setWriteSummaryFile(boolean writeSummaryFile) {
        this.writeSummaryFile = writeSummaryFile;
    }

    String showCounts(CountByType count2, VcfEntry ve, String rowTitle, String error) {
        StringBuilder sb = new StringBuilder();
        if (ve != null) {
            sb.append(ve.getChromosomeName() + "\t" + (ve.getStart() + 1) + "\t" + ve.getRef() + "\t" + ve.getAltsStr());
        } else if (rowTitle != null) {
            sb.append(rowTitle + "\t\t\t");
        } else {
            sb.append("#Total\t.\t.\t.");
        }
        for (String label : this.labels) {
            sb.append("\t" + count2.get(label));
        }
        sb.append("\t" + error);
        sb.append("\n");
        return sb.toString();
    }

    void showResults(String titleBySample) {
        this.print(this.showCounts(this.concordance, null, null, ""));
        if (this.writeBySampleFile) {
            String bySampleFile = "concordance_" + this.name1 + SEP + this.name2 + ".by_sample.txt";
            Timer.showStdErr("Writing concordance by sample to file '" + bySampleFile + "'");
            StringBuilder bySample = new StringBuilder();
            bySample.append(titleBySample + "\n");
            ArrayList sampleNames = new ArrayList();
            sampleNames.addAll(this.concordanceBySample.keySet());
            Collections.sort(sampleNames);
            for (String sample : sampleNames) {
                bySample.append(this.showCounts((CountByType)this.concordanceBySample.get(sample), null, sample, ""));
            }
            Gpr.toFile(bySampleFile, bySample);
        }
        if (this.writeSummaryFile) {
            String summaryFile = "concordance_" + this.name1 + SEP + this.name2 + ".summary.txt";
            Timer.showStdErr("Writing summary file '" + summaryFile + "'");
            if (!this.errors.isEmpty()) {
                this.summary("\n# Errors:");
                for (String l : this.errors.keySet()) {
                    this.summary("\t" + l + "\t" + this.errors.get(l));
                }
            }
            Gpr.toFile(summaryFile, this.summary);
        }
    }

    void summary(String message) {
        this.summary.append(message + "\n");
        if (this.verbose) {
            System.err.println(message);
        }
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar " + this.command + " [options] reference.vcf sequencing.vcf\n");
        System.err.println("Options:\n");
        System.err.println("\t -s <file>  : Only use sample IDs in file (format: one sample ID per line).");
        System.exit(1);
    }

    String vcfFile2name(String vcf) {
        if (vcf.isEmpty() || vcf.equals("-")) {
            return "stdin";
        }
        return Gpr.removeExt(Gpr.baseName(vcf));
    }
}

