/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.snpSift.annotate.AnnotateVcfDb;
import ca.mcgill.mcb.pcingola.snpSift.annotate.AnnotateVcfDbMem;
import ca.mcgill.mcb.pcingola.snpSift.annotate.AnnotateVcfDbSorted;
import ca.mcgill.mcb.pcingola.snpSift.annotate.AnnotateVcfDbTabix;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeader;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderInfo;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SnpSiftCmdAnnotate
extends SnpSift {
    public static final int SHOW = 10000;
    public static final int SHOW_LINES = 1000000;
    protected boolean annotateEmpty;
    protected boolean useId;
    protected boolean useInfoField;
    protected boolean useRefAlt;
    protected AnnotationMethod method;
    protected int countBadRef = 0;
    int countAnnotated = 0;
    int count = 0;
    protected String chrPrev = "";
    protected String prependInfoFieldName;
    protected String existsInfoField;
    protected ArrayList<String> infoFields;
    protected VcfFileIterator vcfFile;
    protected AnnotateVcfDb annotateDb;

    public SnpSiftCmdAnnotate(String[] args) {
        super(args, "annotate");
    }

    protected SnpSiftCmdAnnotate(String[] args, String command) {
        super(args, command);
    }

    ArrayList<VcfEntry> annotate(boolean createList) {
        ArrayList<VcfEntry> list2;
        ArrayList<VcfEntry> arrayList = list2 = createList ? new ArrayList<VcfEntry>() : null;
        if (this.verbose) {
            Timer.showStdErr("Annotating entries from: '" + this.vcfInputFile + "'");
        }
        this.vcfFile = this.openVcfInputFile();
        try {
            this.annotateInit(this.vcfFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int pos = -1;
        String chr = "";
        for (VcfEntry vcfEntry : this.vcfFile) {
            try {
                this.processVcfHeader(this.vcfFile);
                if (vcfEntry.getChromosomeName().equals(chr) && vcfEntry.getStart() < pos) {
                    this.fatalError("Your VCF file should be sorted!\n\tPrevious entry " + chr + ":" + pos + "\n\tCurrent entry  " + vcfEntry.getChromosomeName() + ":" + (vcfEntry.getStart() + 1));
                }
                this.annotate(vcfEntry);
                if (list2 != null) {
                    list2.add(vcfEntry);
                }
                chr = vcfEntry.getChromosomeName();
                pos = vcfEntry.getStart();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.annotateDb.close();
        if (this.verbose) {
            double perc = 100.0 * (double)this.countAnnotated / (double)this.count;
            Timer.showStdErr("Done.\n\tTotal annotated entries : " + this.countAnnotated + "\n\tTotal entries           : " + this.count + "\n\tPercent                 : " + String.format("%.2f%%", perc) + "\n\tErrors (bad references) : " + this.countBadRef);
        }
        return list2;
    }

    @Override
    public void annotate(VcfEntry vcfEntry) {
        boolean annotated = false;
        if (vcfEntry.isVariant()) {
            try {
                annotated = this.annotateDb.annotate(vcfEntry);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.suppressOutput) {
            this.print(vcfEntry);
        }
        if (annotated) {
            ++this.countAnnotated;
        }
        ++this.count;
    }

    @Override
    public boolean annotateFinish() {
        return false;
    }

    @Override
    public boolean annotateInit(VcfFileIterator vcfFile) {
        this.dbFileName = this.databaseFindOrDownload();
        this.method = this.guessAnnotationMethod();
        this.dbFileName = this.fixDbName();
        if (this.verbose) {
            Timer.showStdErr("Annotating\n" + (this.vcfInputFile != null ? "\tInput file    : '" + this.vcfInputFile + "'\n" : "") + "\tDatabase file : '" + this.dbFileName + "'");
        }
        if (this.verbose) {
            Timer.showStdErr("Annotating method: " + (Object)((Object)this.method));
        }
        switch (this.method) {
            case MEMORY: {
                this.annotateDb = new AnnotateVcfDbMem(this.dbFileName);
                break;
            }
            case SORTED_VCF: {
                this.annotateDb = new AnnotateVcfDbSorted(this.dbFileName);
                break;
            }
            case TABIX: {
                this.annotateDb = new AnnotateVcfDbTabix(this.dbFileName);
                break;
            }
            default: {
                throw new RuntimeException("Unknwon method '" + (Object)((Object)this.method) + "'");
            }
        }
        this.annotateDb.setUseId(this.useId);
        this.annotateDb.setUseRefAlt(this.useRefAlt);
        this.annotateDb.setInfoFields(this.useInfoField, this.infoFields);
        this.annotateDb.setExistsInfoField(this.existsInfoField);
        this.annotateDb.setPrependInfoFieldName(this.prependInfoFieldName);
        this.annotateDb.setDebug(this.debug);
        this.annotateDb.setVerbose(this.verbose);
        this.annotateDb.open();
        return false;
    }

    String fixDbName() {
        if (this.method == AnnotationMethod.TABIX && !this.dbFileName.endsWith(".gz") && Gpr.exists(this.dbFileName + ".gz")) {
            return this.dbFileName + ".gz";
        }
        return this.dbFileName;
    }

    AnnotationMethod guessAnnotationMethod() {
        if (this.method != null) {
            return this.method;
        }
        if (this.dbFileName.endsWith(".gz")) {
            if (Gpr.exists(this.dbFileName + ".tbi")) {
                return AnnotationMethod.TABIX;
            }
            return AnnotationMethod.MEMORY;
        }
        if (Gpr.exists(this.dbFileName + ".gz") && Gpr.exists(this.dbFileName + ".gz.tbi")) {
            return AnnotationMethod.TABIX;
        }
        return AnnotationMethod.SORTED_VCF;
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> headerInfos = super.headers();
        if (this.useInfoField) {
            VcfFileIterator vcfDb = new VcfFileIterator(this.dbFileName);
            VcfHeader vcfDbHeader = vcfDb.readHeader();
            for (VcfHeaderInfo vcfHeaderDb : vcfDbHeader.getVcfInfo()) {
                String id = (this.prependInfoFieldName != null ? this.prependInfoFieldName : "") + vcfHeaderDb.getId();
                VcfHeaderInfo vcfHeaderFile = this.vcfFile.getVcfHeader().getVcfInfo(id);
                if (!this.isAnnotateInfo(vcfHeaderDb) || vcfHeaderDb.isImplicit() || vcfHeaderFile != null && !vcfHeaderFile.isImplicit()) continue;
                VcfHeaderInfo newHeader = new VcfHeaderInfo(vcfHeaderDb);
                if (this.prependInfoFieldName != null) {
                    newHeader.setId(id);
                }
                headerInfos.add(newHeader);
            }
        }
        if (this.existsInfoField != null) {
            VcfHeaderInfo existsHeader = new VcfHeaderInfo(this.existsInfoField, VcfInfoType.Flag, "1", "Variant exists in file '" + Gpr.baseName(this.dbFileName) + "'");
            headerInfos.add(existsHeader);
        }
        return headerInfos;
    }

    @Override
    public void init() {
        this.useInfoField = true;
        this.useId = true;
        this.useRefAlt = true;
        this.method = null;
        this.needsConfig = true;
        this.needsDb = true;
        this.dbTabix = true;
    }

    boolean isAnnotateInfo(VcfHeaderInfo vcfInfo) {
        if (this.infoFields == null) {
            return true;
        }
        for (String info : this.infoFields) {
            if (!vcfInfo.getId().equals(info)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void parse(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                if (arg.equals("-a")) {
                    this.annotateEmpty = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-id")) {
                    this.useId = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-info")) {
                    if (args.length <= i + 1) {
                        this.usage("Missing parameter -info");
                    }
                    this.useInfoField = true;
                    this.infoFields = new ArrayList();
                    for (String infoField : args[++i].split(",")) {
                        this.infoFields.add(infoField);
                    }
                    continue;
                }
                if (arg.equalsIgnoreCase("-exists")) {
                    if (args.length > i + 1) {
                        this.existsInfoField = args[++i];
                        continue;
                    }
                    this.usage("Missing parameter -exists");
                    continue;
                }
                if (arg.equalsIgnoreCase("-noId")) {
                    this.useId = false;
                    continue;
                }
                if (arg.equalsIgnoreCase("-noInfo")) {
                    this.useInfoField = false;
                    continue;
                }
                if (arg.equalsIgnoreCase("-name")) {
                    if (args.length > i + 1) {
                        this.prependInfoFieldName = args[++i];
                        continue;
                    }
                    this.usage("Missing parameter -name");
                    continue;
                }
                if (arg.equalsIgnoreCase("-noAlt")) {
                    this.useRefAlt = false;
                    continue;
                }
                if (arg.equalsIgnoreCase("-dbSnp")) {
                    this.dbType = "dbsnp";
                    this.method = AnnotationMethod.TABIX;
                    continue;
                }
                if (arg.equalsIgnoreCase("-clinVar")) {
                    this.dbType = "clinvar";
                    this.method = AnnotationMethod.TABIX;
                    continue;
                }
                if (arg.equalsIgnoreCase("-mem")) {
                    this.method = AnnotationMethod.MEMORY;
                    continue;
                }
                if (arg.equalsIgnoreCase("-sorted")) {
                    this.method = AnnotationMethod.SORTED_VCF;
                    continue;
                }
                if (arg.equalsIgnoreCase("-tabix")) {
                    this.method = AnnotationMethod.TABIX;
                    continue;
                }
                this.usage("Unknown command line option '" + arg + "'");
                continue;
            }
            if (this.dbType == null && this.dbFileName == null) {
                this.dbFileName = arg;
                continue;
            }
            if (this.vcfInputFile == null) {
                this.vcfInputFile = arg;
                continue;
            }
            this.usage("Unknown extra parameter '" + arg + "'");
        }
        if (this.dbType == null && this.dbFileName == null) {
            this.usage("Missing database option or file: [-dbSnp | -clinVar | database.vcf ]");
        }
    }

    @Override
    public void run() {
        this.run(false);
    }

    public List<VcfEntry> run(boolean createList) {
        if (this.config == null) {
            this.loadConfig();
        }
        return this.annotate(createList);
    }

    public void setAnnotateEmpty(boolean annotateEmpty) {
        this.annotateEmpty = annotateEmpty;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar " + this.command + " [options] [-dbSnp | -clinvar | database.vcf] file.vcf > newFile.vcf");
        System.err.println("\nDatabase options:");
        System.err.println("\tdatabase.vcf         : Use 'database.vcf' file as annotations database. Note: The VCF file can be bgzipped and tabix-indexed.");
        System.err.println("\t-dbsnp               : Use DbSnp database.");
        System.err.println("\t-clinvar             : Use ClinVar database.");
        System.err.println("\nCommand Options:");
        System.err.println("\t-a                   : Annotate fields, even if the database has an empty value (annotates using '.' for empty).");
        System.err.println("\t-exists <tag>        : Annotate whether the variant exists or not in the database (using 'tag' as an INFO field FLAG).");
        System.err.println("\t-id                  : Only annotate ID field (do not add INFO field). Default: " + this.useId);
        System.err.println("\t-info <list>         : Annotate using a list of info fields (list is a comma separated list of fields). Default: ALL.");
        System.err.println("\t-mem                 : VCF database is loaded in memory. Default: " + (this.method == AnnotationMethod.MEMORY));
        System.err.println("\t-name str            : Prepend 'str' to all annotated INFO fields. Default: ''.");
        System.err.println("\t-noAlt               : Do not use REF and ALT fields when comparing database.vcf entries to file.vcf entries. Default: " + !this.useRefAlt);
        System.err.println("\t-noId                : Do not annotate ID field. Default: " + !this.useId);
        System.err.println("\t-noInfo              : Do not annotate INFO fields. Default: " + !this.useInfoField);
        System.err.println("\t-sorted              : VCF database is sorted and uncompressed. Default: " + (this.method == AnnotationMethod.SORTED_VCF));
        System.err.println("\t-tabix               : VCF database is tabix-indexed. Default: " + (this.method == AnnotationMethod.TABIX));
        this.usageGenericAndDb();
        System.err.println("Note: According the the VCF's database format provided, SnpSift annotate uses different strategies");
        System.err.println("\t  i) plain VCF       : SnpSift indexes the VCF file (creating an index in memory).");
        System.err.println("\t ii) bgzip+tabix     : SnpSift uses tabix's index.");
        System.err.println("\tiii) gzip            : SnpSift loads the whole VCF file in memory (very inneficient).");
        System.exit(1);
    }

    static enum AnnotationMethod {
        SORTED_VCF,
        MEMORY,
        TABIX;

    }
}

