/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSift;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;

public class SnpSiftCmdAlleleMatrix
extends SnpSift {
    public static String SEPARATOR = "";
    public static int SHOW_EVERY = 1000;

    public SnpSiftCmdAlleleMatrix() {
        super(null, null);
    }

    public SnpSiftCmdAlleleMatrix(String[] args) {
        super(args, "alleleMatrix");
    }

    @Override
    public void parse(String[] args) {
        if (args.length <= 0) {
            this.usage(null);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) continue;
            this.vcfInputFile = arg;
        }
    }

    public int processStr(VcfEntry vcfEntry, StringBuilder sbcodes) {
        String sep = "";
        int countNonRef = 0;
        for (VcfGenotype gen : vcfEntry.getVcfGenotypes()) {
            int score = gen.getGenotypeCode();
            String sc = ".";
            if (score >= 0) {
                sc = Integer.toString(score);
                if (score > 0) {
                    ++countNonRef;
                }
            }
            sbcodes.append(sep + sc);
            sep = SEPARATOR;
        }
        return countNonRef;
    }

    @Override
    public void run() {
        int i = 1;
        VcfFileIterator vcf = this.openVcfInputFile();
        for (VcfEntry ve : vcf) {
            if (vcf.isHeadeSection()) {
                System.out.print("#CHROM\tPOS\tREF\tALT");
                for (String sample : vcf.getVcfHeader().getSampleNames()) {
                    System.out.print("\t" + sample);
                }
                System.out.println("");
            }
            StringBuilder sbcodes = new StringBuilder();
            this.processStr(ve, sbcodes);
            System.out.println(ve.getChromosomeName() + "\t" + (ve.getStart() + 1) + "\t" + ve.getRef() + "\t" + ve.getAltsStr() + "\t" + sbcodes.toString());
            if (!this.verbose) continue;
            Gpr.showMark(i++, SHOW_EVERY);
        }
        if (this.verbose) {
            Timer.showStdErr("Done");
        }
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar alleleMat file.vcf > allele.matrix.txt");
        System.exit(1);
    }
}

