/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpSift;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.VcfAnnotator;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdAlleleMatrix;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdAnnotate;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdConcordance;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdCovarianceMatrix;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdDbNsfp;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdExtractFields;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdFilter;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdFilterChrPos;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdGeneSets;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdGt;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdGtFilter;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdGwasCatalog;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdIntersect;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdIntervals;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdIntervalsIndex;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdJoin;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdPedShow;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdPhastCons;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdPrivate;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdRemoveReferenceGenotypes;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdRmInfo;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdSimplifyIndels;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdSplit;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdTsTv;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdVarType;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdVcf2Tped;
import ca.mcgill.mcb.pcingola.snpSift.SnpSiftCmdVcfCheck;
import ca.mcgill.mcb.pcingola.snpSift.caseControl.SnpSiftCmdCaseControl;
import ca.mcgill.mcb.pcingola.snpSift.caseControl.SnpSiftCmdCaseControlSummary;
import ca.mcgill.mcb.pcingola.snpSift.hwe.SnpSiftCmdHwe;
import ca.mcgill.mcb.pcingola.util.Download;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfHeaderEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SnpSift
implements VcfAnnotator {
    public static final String BUILD = "2015-08-14";
    public static final String SOFTWARE_NAME = "SnpSift";
    public static final String VERSION_MAJOR = "4.1";
    public static final String REVISION = "i";
    public static final String VERSION_SHORT = "4.1i";
    public static final String VERSION_NO_NAME = "4.1i (build 2015-08-14), by Pablo Cingolani";
    public static final String VERSION = "SnpSift 4.1i (build 2015-08-14), by Pablo Cingolani";
    public static final int MAX_ERRORS = 10;
    public static int SHOW_EVERY_VCFLINES = 100;
    protected boolean help;
    protected boolean verbose;
    protected boolean debug;
    protected boolean quiet;
    protected boolean log;
    protected boolean download = true;
    protected boolean showHeader = true;
    protected boolean saveOutput = false;
    protected boolean suppressOutput = false;
    protected boolean needsConfig;
    protected boolean needsDb;
    protected boolean dbTabix;
    protected String[] args;
    protected String command;
    protected String vcfInputFile;
    protected String dbFileName;
    protected String dbType;
    protected int numWorkers = 1;
    protected StringBuilder output = new StringBuilder();
    protected HashMap<String, Integer> errCount;
    protected String configFile;
    protected Config config;
    protected String dataDir;

    public static void main(String[] args) {
        SnpSift snpSift = new SnpSift(args, null);
        snpSift.run();
    }

    public SnpSift(String[] args, String command) {
        this.args = args;
        this.command = command;
        this.errCount = new HashMap();
        this.init();
        if (args != null) {
            this.parse(args);
        }
    }

    @Override
    public boolean addHeaders(VcfFileIterator vcfFile) {
        for (VcfHeaderEntry hinf : this.headers()) {
            vcfFile.getVcfHeader().add(hinf);
        }
        return false;
    }

    @Override
    public void annotate(VcfEntry vcfEntry) {
        throw new RuntimeException("Unimplemented method!");
    }

    @Override
    public boolean annotateFinish() {
        throw new RuntimeException("Unimplemented method!");
    }

    @Override
    public boolean annotateInit(VcfFileIterator vcfFile) {
        throw new RuntimeException("Unimplemented method!");
    }

    protected String commandLineStr() {
        if (this.args == null) {
            return "";
        }
        StringBuilder argsList = new StringBuilder();
        argsList.append("SnpSift " + this.command + " ");
        if (this.args != null) {
            for (String arg : this.args) {
                if ((arg = arg.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim()).indexOf(32) > 0) {
                    arg = "'" + arg + "'";
                }
                argsList.append(arg + " ");
            }
        }
        return argsList.toString().trim();
    }

    protected boolean databaseDownload() {
        if (!this.download) {
            return false;
        }
        String dbUrl = this.config.getDatabaseRepository(this.dbType);
        if (dbUrl == null) {
            this.fatalError("Database URL name is missing (missing entry in config file?).");
        }
        Timer.showStdErr("Downlading database from " + dbUrl);
        Download download = new Download();
        download.setVerbose(this.verbose);
        download.setDebug(this.debug);
        boolean ok = download.download(dbUrl, this.dbFileName);
        if (!ok) {
            return false;
        }
        if (this.dbTabix) {
            String indexUrl = this.config.getDatabaseRepository(this.dbType) + ".tbi";
            Timer.showStdErr("Downlading index from " + indexUrl);
            download = new Download();
            download.setVerbose(this.verbose);
            download.setDebug(this.debug);
            ok &= download.download(indexUrl, this.dbFileName + ".tbi");
        }
        return ok;
    }

    protected String databaseFindOrDownload() {
        if (this.dbType == null && this.dbFileName == null) {
            throw new RuntimeException("Neither database type nor database file name set: This should never happen!");
        }
        if (this.dbFileName == null || this.dbFileName.isEmpty()) {
            this.dbFileName = this.config.getDatabaseLocal(this.dbType);
            if (this.dbFileName == null || this.dbFileName.isEmpty()) {
                this.fatalError("Database file name is empty. Missing 'database.local." + this.dbType + "' entry in SnpEff's config file?");
            }
            if (!Gpr.exists(this.dbFileName)) {
                Timer.showStdErr("Database file '" + this.dbFileName + "' not found.");
                if (!this.databaseDownload()) {
                    this.fatalError("Could not download database.");
                }
            }
        }
        return this.dbFileName;
    }

    public void error(Throwable e, String message) {
        if (this.verbose && e != null) {
            e.printStackTrace();
        }
        if (!this.quiet) {
            System.err.println(message);
        }
    }

    public void fatalError(String message) {
        System.err.println("Fatal error: " + message);
        System.exit(-1);
    }

    public Config getConfig() {
        return this.config;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getOutput() {
        return this.output.toString();
    }

    protected List<VcfHeaderEntry> headers() {
        ArrayList<VcfHeaderEntry> newHeaders = new ArrayList<VcfHeaderEntry>();
        newHeaders.add(new VcfHeaderEntry("##SnpSiftVersion=\"SnpSift 4.1i (build 2015-08-14), by Pablo Cingolani\""));
        newHeaders.add(new VcfHeaderEntry("##SnpSiftCmd=\"" + this.commandLineStr() + "\""));
        return newHeaders;
    }

    public void init() {
    }

    protected boolean isOpt(String arg) {
        return arg.startsWith("-") && arg.length() > 1;
    }

    protected void loadConfig() {
        if (this.config != null) {
            return;
        }
        if (this.configFile == null || this.configFile.isEmpty()) {
            this.configFile = "snpEff.config";
        }
        if (this.verbose) {
            Timer.showStdErr("Reading configuration file '" + this.configFile + "'");
        }
        this.config = new Config("", this.configFile, this.dataDir, null);
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        this.config.setDebug(this.debug);
        this.config.setVerbose(this.verbose);
    }

    protected VcfFileIterator openVcfInputFile() {
        if (this.vcfInputFile == null || this.vcfInputFile.isEmpty() || this.vcfInputFile.equals("-")) {
            this.vcfInputFile = "-";
        }
        if (this.verbose) {
            Timer.showStdErr("Opening VCF input '" + (this.vcfInputFile.equals("-") ? "STDIN" : this.vcfInputFile) + "'");
        }
        VcfFileIterator vcf = new VcfFileIterator(this.vcfInputFile);
        vcf.setDebug(this.debug);
        return vcf;
    }

    public void parse(String[] args) {
        if (args.length < 1) {
            this.usage(null);
        }
        this.command = args[0];
        ArrayList<String> argsList = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-noLog")) {
                this.log = false;
                continue;
            }
            if (arg.equals("-h") || arg.equalsIgnoreCase("-help")) {
                this.help = true;
                continue;
            }
            if (arg.equals("-v") || arg.equalsIgnoreCase("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (arg.equals("-q") || arg.equalsIgnoreCase("-quiet")) {
                this.quiet = true;
                continue;
            }
            if (arg.equals("-d") || arg.equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-noLog")) {
                this.log = false;
                continue;
            }
            if (arg.equalsIgnoreCase("-noDownload")) {
                this.download = false;
                continue;
            }
            if (arg.equals("-c") || arg.equalsIgnoreCase("-config")) {
                if (i + 1 < args.length) {
                    this.configFile = args[++i];
                    continue;
                }
                this.usage("Option '-c' without config file argument");
                continue;
            }
            if (arg.equalsIgnoreCase("-dataDir")) {
                if (i + 1 < args.length) {
                    this.dataDir = args[++i];
                    continue;
                }
                this.usage("Option '-dataDir' without data_dir argument");
                continue;
            }
            if (arg.equals("-db") || arg.equalsIgnoreCase("-database")) {
                if (args.length <= i) {
                    this.usage("Missing argument for command line option '-db'");
                }
                this.dbFileName = args[++i];
                continue;
            }
            if (arg.equals("-cpus")) {
                if (args.length <= i) {
                    this.usage("Missing argument for command line option '-cpus'");
                }
                this.numWorkers = Gpr.parseIntSafe(args[++i]);
                if (this.numWorkers > 0) continue;
                this.usage("Error: Number of cpus must be positive");
                continue;
            }
            if (arg.equalsIgnoreCase("-version")) {
                System.out.println(VERSION_SHORT);
                System.exit(0);
                continue;
            }
            argsList.add(args[i]);
        }
        this.args = argsList.toArray(new String[0]);
    }

    void print(Object o) {
        if (this.saveOutput) {
            this.output.append(o.toString() + "\n");
        } else if (!this.suppressOutput) {
            System.out.println(o.toString());
        }
    }

    protected String processVcfHeader(VcfFileIterator vcf) {
        if (!vcf.isHeadeSection() && vcf.getLineNum() > 1) {
            return "";
        }
        this.addHeaders(vcf);
        if (this.showHeader) {
            String headerStr = vcf.getVcfHeader().toString();
            if (!headerStr.isEmpty()) {
                this.print(headerStr);
            }
            return headerStr;
        }
        return "";
    }

    public void run() {
        SnpSift cmd = this.snpSiftCmd();
        cmd.run();
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setDbFileName(String dbFileName) {
        this.dbFileName = dbFileName;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setSaveOutput(boolean saveOutput) {
        this.saveOutput = saveOutput;
    }

    public void setSuppressOutput(boolean suppressOutput) {
        this.suppressOutput = suppressOutput;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void showCmd() {
        System.err.print(SnpSift.class.getSimpleName() + " " + this.command + " ");
        if (this.args != null) {
            for (String a : this.args) {
                System.err.print(a + " ");
            }
        }
        System.err.println("");
    }

    public void showVersion() {
        System.err.println(SnpSift.class.getSimpleName() + " version " + VERSION_NO_NAME + "\n");
    }

    public SnpSift snpSiftCmd() {
        SnpSift cmd = null;
        this.command = this.command.trim().toUpperCase();
        if (this.command.startsWith("ALL")) {
            cmd = new SnpSiftCmdAlleleMatrix(this.args);
        } else if (this.command.startsWith("ANN")) {
            cmd = new SnpSiftCmdAnnotate(this.args);
        } else if (this.command.startsWith("CA")) {
            cmd = new SnpSiftCmdCaseControl(this.args);
        } else if (this.command.startsWith("CCS")) {
            cmd = new SnpSiftCmdCaseControlSummary(this.args);
        } else if (this.command.startsWith("CONC")) {
            cmd = new SnpSiftCmdConcordance(this.args);
        } else if (this.command.startsWith("COVMAT")) {
            cmd = new SnpSiftCmdCovarianceMatrix(this.args);
        } else if (this.command.startsWith("DBNSFP")) {
            cmd = new SnpSiftCmdDbNsfp(this.args);
        } else if (this.command.startsWith("EX")) {
            cmd = new SnpSiftCmdExtractFields(this.args);
        } else if (this.command.startsWith("FILTERC")) {
            cmd = new SnpSiftCmdFilterChrPos(this.args);
        } else if (this.command.startsWith("FI")) {
            cmd = new SnpSiftCmdFilter(this.args);
        } else if (this.command.startsWith("GENESETS")) {
            cmd = new SnpSiftCmdGeneSets(this.args);
        } else if (this.command.startsWith("GTF")) {
            cmd = new SnpSiftCmdGtFilter(this.args);
        } else if (this.command.startsWith("GT")) {
            cmd = new SnpSiftCmdGt(this.args);
        } else if (this.command.startsWith("GWASCAT")) {
            cmd = new SnpSiftCmdGwasCatalog(this.args);
        } else if (this.command.startsWith("HW")) {
            cmd = new SnpSiftCmdHwe(this.args);
        } else if (this.command.startsWith("INTIDX")) {
            cmd = new SnpSiftCmdIntervalsIndex(this.args);
        } else if (this.command.startsWith("INTERS")) {
            cmd = new SnpSiftCmdIntersect(this.args);
        } else if (this.command.startsWith("INTERV")) {
            cmd = new SnpSiftCmdIntervals(this.args);
        } else if (this.command.startsWith("JOIN")) {
            cmd = new SnpSiftCmdJoin(this.args);
        } else if (this.command.startsWith("PEDSHOW")) {
            cmd = new SnpSiftCmdPedShow(this.args);
        } else if (this.command.startsWith("PHASTCONS")) {
            cmd = new SnpSiftCmdPhastCons(this.args);
        } else if (this.command.startsWith("PRIVATE")) {
            cmd = new SnpSiftCmdPrivate(this.args);
        } else if (this.command.startsWith("RMINFO")) {
            cmd = new SnpSiftCmdRmInfo(this.args);
        } else if (this.command.startsWith("RMREF")) {
            cmd = new SnpSiftCmdRemoveReferenceGenotypes(this.args);
        } else if (this.command.startsWith("SIMPLIFYINDELS")) {
            cmd = new SnpSiftCmdSimplifyIndels(this.args);
        } else if (this.command.startsWith("SPLIT")) {
            cmd = new SnpSiftCmdSplit(this.args);
        } else if (this.command.startsWith("TS")) {
            cmd = new SnpSiftCmdTsTv(this.args);
        } else if (this.command.startsWith("VARTYPE")) {
            cmd = new SnpSiftCmdVarType(this.args);
        } else if (this.command.startsWith("VCF2TPED")) {
            cmd = new SnpSiftCmdVcf2Tped(this.args);
        } else if (this.command.startsWith("VCFCHECK")) {
            cmd = new SnpSiftCmdVcfCheck(this.args);
        } else {
            this.usage("Unknown command '" + this.command + "'");
        }
        if (this.help) {
            ((SnpSift)cmd).usage(null);
        }
        if (!this.help && (this.verbose || this.debug)) {
            Timer.showStdErr("SnpSift version 4.1i (build 2015-08-14), by Pablo Cingolani");
            Timer.showStdErr("Command: '" + this.command + "'");
        }
        cmd.verbose = this.verbose;
        cmd.quiet = this.quiet;
        cmd.debug = this.debug;
        cmd.help = this.help;
        cmd.suppressOutput = this.suppressOutput;
        cmd.numWorkers = this.numWorkers;
        cmd.needsConfig = this.needsConfig;
        cmd.configFile = this.configFile;
        cmd.config = this.config;
        cmd.download = this.download;
        cmd.log = this.log;
        cmd.needsDb = this.needsDb;
        if (cmd.dbFileName == null) {
            cmd.dbFileName = this.dbFileName;
        }
        if (cmd.dbType == null) {
            cmd.dbType = this.dbType;
        }
        return cmd;
    }

    public String unSanitize(String str) {
        str = str.replaceAll("__lt__", "<");
        str = str.replaceAll("__gt__", ">");
        str = str.replaceAll("__sq__", "'");
        str = str.replaceAll("__dq__", "\"");
        str = str.replaceAll("__ob__", "[");
        str = str.replaceAll("__cb__", "]");
        str = str.replaceAll("__oc__", "{");
        str = str.replaceAll("__cc__", "}");
        str = str.replaceAll("__oc__", "{");
        str = str.replaceAll("__at__", "@");
        str = str.replaceAll("__cn__", "\n");
        str = str.replaceAll("__cr__", "\r");
        str = str.replaceAll("__tc__", "\t");
        return str;
    }

    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar [command] params..." + "\nCommand is one of:" + "\n\talleleMat     : Create an allele matrix output." + "\n\tannotate      : Annotate 'ID' from a database (e.g. dbSnp). Assumes entries are sorted." + "\n\tannMem        : Annotate 'ID' from a database (e.g. dbSnp). Loads db in memory. Does not assume sorted entries." + "\n\tcaseControl   : Compare how many variants are in 'case' and in 'control' groups; calculate p-values." + "\n\tccs           : Case control summary. Case and control summaries by region, allele frequency and variant's functional effect." + "\n\tconcordance   : Concordance metrics between two VCF files." + "\n\tcovMat        : Create an covariance matrix output (allele matrix as input)." + "\n\tdbnsfp        : Annotate with multiple entries from dbNSFP." + "\n\textractFields : Extract fields from VCF file into tab separated format." + "\n\tfilter        : Filter using arbitrary expressions" + "\n\tgeneSets      : Annotate using MSigDb gene sets (MSigDb includes: GO, KEGG, Reactome, BioCarta, etc.)" + "\n\tgt            : Add Genotype to INFO fields and remove genotype fields when possible." + "\n\tgwasCat       : Annotate using GWAS catalog" + "\n\thwe           : Calculate Hardy-Weimberg parameters and perform a godness of fit test." + "\n\tintersect     : Intersect intervals (genomic regions)." + "\n\tintervals     : Keep variants that intersect with intervals." + "\n\tintIdx        : Keep variants that intersect with intervals. Index-based method: Used for large VCF file and a few intervals to retrieve" + "\n\tjoin          : Join files by genomic region." + "\n\tphastCons     : Annotate using conservation scores (phastCons)." + "\n\tprivate       : Annotate if a variant is private to a family or group." + "\n\trmRefGen      : Remove reference genotypes." + "\n\trmInfo        : Remove INFO fields." + "\n\tsplit         : Split VCF by chromosome." + "\n\ttstv          : Calculate transiton to transversion ratio." + "\n\tvarType       : Annotate variant type (SNP,MNP,INS,DEL or MIXED)." + "\n\tvcfCheck      : Check that VCF file is well formed." + "\n\tvcf2tped      : Convert VCF to TPED.");
        this.usageGenericAndDb();
        System.exit(1);
    }

    protected void usageGenericAndDb() {
        System.err.println("\nOptions common to all SnpSift commands:\n" + (this.needsConfig ? "\t-c , -config <file>  : Specify config file\n" : "") + "\t-d                   : Debug.\n" + (this.needsDb ? "\t-db <file>           : Database file name (for commands that require databases).\n" : "") + "\t-download            : Download database, if not available locally. Default: " + this.download + ".\n" + "\t-noDownload          : Do not download a database, if not available locally.\n" + "\t-noLog               : Do not report usage statistics to server.\n" + "\t-h                   : Help.\n" + "\t-v                   : Verbose.\n");
    }

    protected void warn(String warn) {
        if (!this.errCount.containsKey(warn)) {
            this.errCount.put(warn, 0);
        }
        int count2 = this.errCount.get(warn);
        this.errCount.put(warn, count2 + 1);
        if (count2 < 10) {
            System.err.println("WARNING: " + warn);
        }
    }
}

