/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.testCases.unity.TestCasesBase;
import ca.mcgill.mcb.pcingola.util.Gpr;
import org.junit.Test;

public class TestCasesSpliceSite
extends TestCasesBase {
    public static int N = 1000;

    @Override
    protected void init() {
        super.init();
        this.randSeed = 20141205;
        this.minExons = 2;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        for (int i = 0; i < N; ++i) {
            this.initSnpEffPredictor();
            if (this.verbose) {
                System.out.println("Splice Test iteration: " + i + "\n" + this.transcript);
            } else {
                Gpr.showMark(i + 1, 1);
            }
            for (Intron intron : this.transcript.introns()) {
                Variant variant;
                int pos;
                int ssBases = Math.min(1, intron.size());
                EffectType effectNotExpected = intron.size() > 4 ? EffectType.SPLICE_SITE_ACCEPTOR : null;
                for (pos = intron.getStart(); pos <= intron.getStart() + ssBases; ++pos) {
                    variant = new Variant((Marker)this.chromosome, pos, "A", "T");
                    this.checkEffect(variant, EffectType.SPLICE_SITE_DONOR, effectNotExpected, VariantEffect.EffectImpact.HIGH);
                }
                effectNotExpected = intron.size() > 4 ? EffectType.SPLICE_SITE_DONOR : null;
                for (pos = intron.getEnd() - ssBases; pos <= intron.getEnd(); ++pos) {
                    variant = new Variant((Marker)this.chromosome, pos, "A", "T");
                    this.checkEffect(variant, EffectType.SPLICE_SITE_ACCEPTOR, effectNotExpected, VariantEffect.EffectImpact.HIGH);
                }
            }
        }
        System.err.println("");
    }
}

