/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.stats.IntStats;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesIntStats {
    public static double EPSILON = 1.0E-6;
    boolean verbose = false;
    Random rand;

    public TestCasesIntStats() {
        this.initRand();
    }

    void initRand() {
        this.rand = new Random(20110328L);
    }

    @Test
    public void test_01() {
        String[] lines2;
        Gpr.debug("Test");
        String fileName = "tests/intStats_test_01.txt";
        String file = Gpr.readFile(fileName);
        for (String line : lines2 = file.split("\n")) {
            String[] recs = line.split("\t");
            int min2 = (int)Gpr.parseDoubleSafe(recs[0]);
            int max2 = (int)Gpr.parseDoubleSafe(recs[1]);
            double mean = Gpr.parseDoubleSafe(recs[2]);
            double median = Gpr.parseDoubleSafe(recs[3]);
            double std = Gpr.parseDoubleSafe(recs[4]);
            IntStats intStats = new IntStats();
            for (int i = 5; i < recs.length; ++i) {
                int value2 = Gpr.parseIntSafe(recs[i]);
                intStats.sample(value2);
            }
            Assert.assertEquals(min2, intStats.getMin());
            Assert.assertEquals(max2, intStats.getMax());
            Assert.assertEquals(mean, intStats.getMean(), EPSILON);
            Assert.assertEquals(median, intStats.getMedian(), EPSILON);
            Assert.assertEquals(std, intStats.getStd(), EPSILON);
        }
    }
}

