/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.HgvsDna;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.snpEffect.testCases.unity.TestCasesBase;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesHgvsDnaDupNegative
extends TestCasesBase {
    @Override
    protected void init() {
        super.init();
        this.onlyMinusStrand = true;
        this.onlyPlusStrand = false;
        this.shiftHgvs = true;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        if (this.verbose) {
            Exon exFirst = (Exon)this.transcript.sorted().get(0);
            String exFirstSeq = exFirst.isStrandPlus() ? exFirst.getSequence() : GprSeq.reverseWc(exFirst.getSequence());
            Gpr.debug(this.transcript + "\n\tSequence: " + exFirstSeq);
        }
        Variant variant = new Variant((Marker)this.chromosome, 1001, "", "C", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.1dupG", hgvsDna);
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        if (this.verbose) {
            Exon exFirst = (Exon)this.transcript.sorted().get(0);
            String exFirstSeq = exFirst.isStrandPlus() ? exFirst.getSequence() : GprSeq.reverseWc(exFirst.getSequence());
            Gpr.debug(this.transcript + "\n\tSequence: " + exFirstSeq);
        }
        Variant variant = new Variant((Marker)this.chromosome, 997, "", "G", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.5dupC", hgvsDna);
    }

    @Test
    public void test_03() {
        Gpr.debug("Test");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        if (this.verbose) {
            Exon exFirst = (Exon)this.transcript.sorted().get(0);
            String exFirstSeq = exFirst.isStrandPlus() ? exFirst.getSequence() : GprSeq.reverseWc(exFirst.getSequence());
            Gpr.debug(this.transcript + "\n\tSequence: " + exFirstSeq);
        }
        Variant variant = new Variant((Marker)this.chromosome, 996, "", "CG", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.5_6dupCG", hgvsDna);
    }

    @Test
    public void test_04() {
        Gpr.debug("Test");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        if (this.verbose) {
            Exon exFirst = (Exon)this.transcript.sorted().get(0);
            String exFirstSeq = exFirst.isStrandPlus() ? exFirst.getSequence() : GprSeq.reverseWc(exFirst.getSequence());
            Gpr.debug(this.transcript + "\n\tSequence: " + exFirstSeq);
        }
        Variant variant = new Variant((Marker)this.chromosome, 984, "", "CAT", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.16_18dupATG", hgvsDna);
    }
}

