/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.FileIndexChrPos;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesFileIndexChrPos {
    boolean verbose = false;
    boolean debug = false;

    void readLinesCheck(String vcf, int numTests) {
        Random random = new Random(20130218L);
        if (this.verbose) {
            System.out.println("Opening file '" + vcf + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcf);
        idx.setVerbose(this.verbose);
        idx.open();
        long size2 = new File(vcf).length();
        for (int i = 1; i < numTests; ++i) {
            long randPos = random.nextInt((int)size2);
            FileIndexChrPos.LineAndPos lineSlow = idx.getLineSlow(randPos);
            FileIndexChrPos.LineAndPos line = idx.getLine(randPos);
            if (!line.line.equals(lineSlow.line)) {
                System.err.println("Length: " + lineSlow.line.length() + "\t" + line.line.length());
                System.err.println("Lines:\n\t" + lineSlow.line + "\n\t" + line.line);
                int shown = 0;
                for (int j = 0; j < line.line.length(); ++j) {
                    System.err.print(j + "\t'" + lineSlow.line.charAt(j) + "'\t'" + line.line.charAt(j) + "'");
                    if (lineSlow.line.charAt(j) != line.line.charAt(j)) {
                        System.err.print("\t<---");
                        if (shown++ > 20) break;
                    }
                    System.err.println("");
                }
            }
            Assert.assertEquals(lineSlow.line, line.line);
            Assert.assertEquals(lineSlow.position, line.position);
            Gpr.showMark(i, 1);
        }
        System.err.println("");
    }

    @Test
    public void test_00_long_file() throws IOException {
        Gpr.debug("Test");
        this.readLinesCheck("tests/test.chr1.vcf", 1000);
    }

    @Test
    public void test_00_short_file() throws IOException {
        Gpr.debug("Test");
        this.readLinesCheck("tests/test_filter_transcripts_001.ori.vcf", 1000);
    }

    @Test
    public void test_01() throws IOException {
        Gpr.debug("Test");
        String vcf = "tests/test.chr1.vcf";
        if (this.verbose) {
            System.out.println("Indexing file '" + vcf + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcf);
        idx.setVerbose(this.verbose);
        idx.open();
        idx.index();
        long pos = idx.getStart("1");
        if (this.verbose) {
            System.out.println("\tChr 1 start: " + pos);
        }
        Assert.assertEquals(82703L, pos);
        idx.close();
    }

    @Test
    public void test_02() throws IOException {
        Gpr.debug("Test");
        String vcf = "tests/test.chr1.vcf";
        String line = "1\t861275\t.\tC\tT\t764.18\tPASS\tAC=1;AF=0.00061;AN=1644;DS;set=Intersection";
        if (this.verbose) {
            System.out.println("Indexing file '" + vcf + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcf);
        idx.setVerbose(this.verbose);
        idx.open();
        idx.index();
        long pos = idx.getStart("1");
        FileIndexChrPos.LineAndPos lp = idx.getLine(pos);
        if (this.verbose) {
            System.out.println("\tChr 1 start: " + pos + "\tLine: '" + lp.line + "'");
        }
        Assert.assertEquals(line, lp.line);
        idx.close();
    }

    @Test
    public void test_03() throws IOException {
        Gpr.debug("Test");
        String vcf = "tests/test.chr1.vcf";
        if (this.verbose) {
            System.out.println("Indexing file '" + vcf + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcf);
        idx.setVerbose(this.verbose);
        idx.open();
        idx.index();
        int chrPos = 861274;
        long pos = idx.find("1", chrPos, true);
        Assert.assertEquals(82703L, pos);
        pos = idx.find("1", chrPos, false);
        Assert.assertEquals(82774L, pos);
        idx.close();
    }

    @Test
    public void test_04() throws IOException {
        Gpr.debug("Test");
        String vcf = "tests/test.chr1.vcf";
        if (this.verbose) {
            System.out.println("Indexing file '" + vcf + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcf);
        idx.setVerbose(this.verbose);
        idx.setDebug(this.debug);
        idx.open();
        idx.index();
        int chrPos = 1019716;
        long pos = idx.find("1", chrPos, true);
        FileIndexChrPos.LineAndPos lp = idx.getLine(pos);
        int chrPosLp = idx.pos(lp.line);
        Assert.assertEquals(chrPos, chrPosLp);
        Assert.assertEquals(129869L, pos);
        idx.close();
    }

    @Test
    public void test_05() throws IOException {
        Gpr.debug("Test");
        String vcf = "tests/test.chr1.vcf";
        if (this.verbose) {
            System.out.println("Indexing file '" + vcf + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcf);
        idx.setVerbose(this.verbose);
        idx.setDebug(this.debug);
        idx.open();
        idx.index();
        int chrPosReal = 1019717;
        int chrPos = chrPosReal - 1;
        long pos = idx.find("1", chrPos, false);
        FileIndexChrPos.LineAndPos lp = idx.getLine(pos);
        int chrPosLp = idx.pos(lp.line);
        Assert.assertEquals(chrPosReal, chrPosLp);
        idx.close();
    }

    @Test
    public void test_06() throws IOException {
        Gpr.debug("Test");
        String vcf = "tests/test.chr1.vcf";
        if (this.verbose) {
            System.out.println("Indexing file '" + vcf + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcf);
        idx.setVerbose(this.verbose);
        idx.setDebug(this.debug);
        idx.open();
        idx.index();
        int chrPosReal = 1019717;
        int chrPos = chrPosReal - 1;
        long pos = idx.find("1", chrPos, true);
        FileIndexChrPos.LineAndPos lp = idx.getLine(pos);
        int chrPosLp = idx.pos(lp.line);
        Assert.assertEquals(chrPos, chrPosLp);
        idx.close();
    }

    @Test
    public void test_07() throws IOException {
        Gpr.debug("Test");
        String vcf = "tests/test.chr1.vcf";
        if (this.verbose) {
            System.out.println("Indexing file '" + vcf + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcf);
        idx.setVerbose(this.verbose);
        idx.setDebug(this.debug);
        idx.open();
        idx.index();
        int chrPosReal = 865488;
        int chrPos = chrPosReal - 1;
        long pos = idx.find("1", chrPos, true);
        FileIndexChrPos.LineAndPos lp = idx.getLine(pos);
        int chrPosLp = idx.pos(lp.line);
        Assert.assertEquals(chrPos, chrPosLp);
        idx.close();
    }

    @Test
    public void test_10() throws IOException {
        Gpr.debug("Test");
        String vcfFileName = "tests/test.chr1.vcf";
        Random random = new Random(20130216L);
        if (this.verbose && this.verbose) {
            System.out.println("Indexing file '" + vcfFileName + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcfFileName);
        idx.setVerbose(this.verbose);
        idx.setDebug(this.debug);
        idx.open();
        idx.index();
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        for (VcfEntry ve : vcf) {
            if (random.nextInt(1000) >= 20) continue;
            int chrPos = ve.getStart();
            long pos = idx.find("1", chrPos, true);
            FileIndexChrPos.LineAndPos lp = idx.getLine(pos);
            int chrPosLp = idx.pos(lp.line);
            Assert.assertEquals(chrPos, chrPosLp);
        }
    }

    @Test
    public void test_11() throws IOException {
        Gpr.debug("Test");
        String vcfFileName = "tests/test.chr1.vcf";
        Random random = new Random(20130217L);
        if (this.verbose && this.verbose) {
            System.out.println("Indexing file '" + vcfFileName + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcfFileName);
        idx.setVerbose(this.verbose);
        idx.setDebug(this.debug);
        idx.open();
        idx.index();
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        int chrPosPrev = 0;
        for (VcfEntry ve : vcf) {
            int chrPos = ve.getStart();
            if (chrPosPrev == 0) {
                chrPosPrev = chrPos - 100;
            }
            if (random.nextInt(1000) < 2) {
                if (this.verbose) {
                    System.out.println("\tFind: " + chrPosPrev + " - " + chrPos);
                }
                int step2 = Math.max((chrPos - chrPosPrev) / 10, 1);
                for (int cp = chrPosPrev; cp <= chrPos; cp += step2) {
                    long pos = idx.find("1", cp, true);
                    FileIndexChrPos.LineAndPos lp = idx.getLine(pos);
                    int chrPosLp = idx.pos(lp.line);
                    if (this.debug) {
                        Gpr.debug("Find: " + cp + "\t" + lp.line);
                    }
                    Assert.assertEquals(chrPos, chrPosLp);
                }
            }
            chrPosPrev = chrPos + 1;
        }
        idx.close();
    }

    @Test
    public void test_20() throws IOException {
        Gpr.debug("Test");
        String vcf = "tests/test.chr1.vcf";
        if (this.verbose) {
            System.out.println("Indexing file '" + vcf + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcf);
        idx.setVerbose(this.verbose);
        idx.setDebug(this.debug);
        idx.open();
        idx.index();
        String dump = idx.dump("1", 861291, 861314, true);
        String expected = "1\t861292\t.\tC\tG\t2971.31\tPASS\tAC=3;AF=0.00182;AN=1644;DS;set=Intersection\n1\t861315\t.\tG\tA\t837.18\tPASS\tAC=1;AF=0.00061;AN=1644;DS;set=Intersection\n";
        Assert.assertEquals(expected, dump);
        idx.close();
    }

    @Test
    public void test_21() throws IOException {
        Gpr.debug("Test");
        String vcf = "tests/test.chr1.vcf";
        if (this.verbose) {
            System.out.println("Indexing file '" + vcf + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcf);
        idx.setVerbose(this.verbose);
        idx.setDebug(this.debug);
        idx.open();
        idx.index();
        String dump = idx.dump("1", 861290, 861314, true);
        String expected = "1\t861292\t.\tC\tG\t2971.31\tPASS\tAC=3;AF=0.00182;AN=1644;DS;set=Intersection\n1\t861315\t.\tG\tA\t837.18\tPASS\tAC=1;AF=0.00061;AN=1644;DS;set=Intersection\n";
        Assert.assertEquals(expected, dump);
        idx.close();
    }

    @Test
    public void test_22() throws IOException {
        Gpr.debug("Test");
        String vcf = "tests/test.chr1.vcf";
        if (this.verbose) {
            System.out.println("Indexing file '" + vcf + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcf);
        idx.setVerbose(this.verbose);
        idx.setDebug(this.debug);
        idx.open();
        idx.index();
        String dump = idx.dump("1", 861291, 861315, true);
        String expected = "1\t861292\t.\tC\tG\t2971.31\tPASS\tAC=3;AF=0.00182;AN=1644;DS;set=Intersection\n1\t861315\t.\tG\tA\t837.18\tPASS\tAC=1;AF=0.00061;AN=1644;DS;set=Intersection\n";
        Assert.assertEquals(expected, dump);
        idx.close();
    }

    @Test
    public void test_23() throws IOException {
        Gpr.debug("Test");
        String vcfFileName = "tests/test.chr1.vcf";
        int MAX_TEST = 1000;
        Random random = new Random(20130217L);
        if (this.verbose) {
            System.out.println("Indexing file '" + vcfFileName + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcfFileName);
        idx.setVerbose(this.verbose);
        idx.setDebug(this.debug);
        idx.open();
        idx.index();
        int minPos = Integer.MAX_VALUE;
        int maxPos = Integer.MIN_VALUE;
        int count2 = 0;
        ArrayList<VcfEntry> vcfEntries = new ArrayList<VcfEntry>();
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        for (VcfEntry ve : vcf) {
            vcfEntries.add(ve);
            minPos = Math.min(minPos, ve.getStart());
            maxPos = Math.max(maxPos, ve.getStart());
            ++count2;
        }
        int dist = (maxPos - minPos) / count2;
        minPos -= 1000;
        maxPos += 1000;
        if (this.verbose) {
            System.out.println("\tDump test (short): ");
        }
        for (int testNum = 1; testNum < MAX_TEST; ++testNum) {
            int start = random.nextInt(maxPos - minPos) + minPos;
            int end = start + random.nextInt(10) * dist;
            String dump = idx.dump("1", start, end, true);
            StringBuilder expected = new StringBuilder();
            for (VcfEntry ve : vcfEntries) {
                if (start > ve.getStart() || ve.getStart() > end) continue;
                if (expected.length() > 0) {
                    expected.append("\n");
                }
                expected.append(ve.getLine());
            }
            if (expected.length() > 0) {
                expected.append("\n");
            }
            Assert.assertEquals(expected.toString(), dump);
            Gpr.showMark(testNum, 1);
        }
        System.err.println("");
        idx.close();
    }

    @Test
    public void test_24() throws IOException {
        Gpr.debug("Test");
        int MAX_TEST = 100;
        String vcfFileName = "tests/test.chr1.vcf";
        Random random = new Random(20130217L);
        if (this.verbose) {
            System.out.println("Indexing file '" + vcfFileName + "'");
        }
        FileIndexChrPos idx = new FileIndexChrPos(vcfFileName);
        idx.setVerbose(this.verbose);
        idx.setDebug(this.debug);
        idx.open();
        idx.index();
        int minPos = Integer.MAX_VALUE;
        int maxPos = Integer.MIN_VALUE;
        ArrayList<VcfEntry> vcfEntries = new ArrayList<VcfEntry>();
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        for (VcfEntry ve : vcf) {
            vcfEntries.add(ve);
            minPos = Math.min(minPos, ve.getStart());
            maxPos = Math.max(maxPos, ve.getStart());
        }
        minPos -= 1000;
        maxPos += 1000;
        int testNum = 0;
        while (testNum < MAX_TEST) {
            int start = random.nextInt(maxPos - minPos) + minPos;
            int end = random.nextInt(maxPos - minPos) + minPos;
            if (end <= start) continue;
            if (this.verbose) {
                System.out.println("Dump test (long) " + testNum + "/" + MAX_TEST + "\tchr1:" + start + "\tchr1:" + end);
            }
            String dump = idx.dump("1", start, end, true);
            StringBuilder expected = new StringBuilder();
            for (VcfEntry ve : vcfEntries) {
                if (start > ve.getStart() || ve.getStart() > end) continue;
                if (expected.length() > 0) {
                    expected.append("\n");
                }
                expected.append(ve.getLine());
            }
            if (expected.length() > 0) {
                expected.append("\n");
            }
            Assert.assertEquals(expected.toString(), dump);
            Gpr.showMark(++testNum, 1);
        }
        System.err.println("");
        idx.close();
    }
}

