/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.snpEffect.testCases.unity.TestCasesBase;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.EffFormatVersion;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import org.junit.Assert;
import org.junit.Test;

public class TestCasesEffectCollapse2
extends TestCasesBase {
    @Override
    protected void init() {
        super.init();
        this.randSeed = 20150202;
        this.spliceRegionExonSize = 3;
        this.spliceRegionIntronMin = 3;
        this.spliceRegionIntronMax = 8;
        this.maxExons = 10;
        this.minExons = 5;
        this.addUtrs = true;
        this.onlyPlusStrand = true;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        Genome genome = this.snpEffectPredictor.getGenome();
        if (this.verbose) {
            for (Gene g : genome.getGenes()) {
                System.out.println(g);
            }
        }
        Variant variant = new Variant((Marker)genome.getChromosome("1"), 695, "ACGTACGTACGTACGT", "");
        if (this.verbose) {
            System.out.println((Object)((Object)variant.getVariantType()) + "\t" + variant.getStart() + "-" + variant.getEnd() + "\t" + variant);
        }
        VariantEffects veffs = this.snpEffectPredictor.variantEffect(variant);
        String expectedAnn = "5_prime_UTR_truncation&exon_loss_variant";
        boolean foundSo = false;
        boolean foundAnn = false;
        for (VariantEffect veff : veffs) {
            VcfEffect vcfEff = new VcfEffect(veff, EffFormatVersion.FORMAT_ANN_1);
            if (this.verbose) {
                System.out.println(vcfEff.getEffectsStrSo() + "\t" + vcfEff);
            }
            foundSo |= vcfEff.getEffectsStrSo().equalsIgnoreCase(expectedAnn);
            foundAnn |= vcfEff.toString().indexOf(expectedAnn) >= 0;
        }
        Assert.assertTrue("Annotation (SO) '" + expectedAnn + "' not found", foundSo);
        Assert.assertTrue("Annotation '" + expectedAnn + "' not found in 'ANN' field", foundAnn);
    }
}

