/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr5prime;
import ca.mcgill.mcb.pcingola.snpEffect.testCases.unity.TestCasesBase;
import ca.mcgill.mcb.pcingola.util.Gpr;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesCds
extends TestCasesBase {
    public static int N = 1000;

    @Override
    protected void init() {
        super.init();
        this.randSeed = 20120131;
    }

    @Test
    public void test_CdsPos() {
        Gpr.debug("Test");
        for (int iter2 = 0; iter2 < N; ++iter2) {
            this.initSnpEffPredictor();
            if (this.debug) {
                System.err.println("Test CDS pos iteration: " + iter2 + "\n" + this.transcript);
            } else if (this.verbose) {
                System.err.println("Test CDS pos iteration: " + iter2 + "\t" + this.transcript.getStrand() + "\t" + this.transcript.cds());
            } else {
                Gpr.showMark(iter2 + 1, 1);
            }
            int cdsBaseNum = 0;
            int[] cds2pos = this.transcript.baseNumberCds2Pos();
            for (Exon exon : this.transcript.sortedStrand()) {
                int min2 = this.transcript.isStrandPlus() ? exon.getStart() : exon.getEnd();
                int step2 = this.transcript.isStrandPlus() ? 1 : -1;
                int pos = min2;
                while (exon.intersects(pos)) {
                    int cdsBaseNumCalc = this.transcript.baseNumberCds(pos, true);
                    Assert.assertEquals(cdsBaseNum, cdsBaseNumCalc);
                    Assert.assertEquals(pos, cds2pos[cdsBaseNum]);
                    pos += step2;
                    ++cdsBaseNum;
                }
            }
        }
        System.err.println("");
    }

    @Test
    public void test_cdsStartEnd_1() {
        Gpr.debug("Test");
        Gene g = new Gene(this.chromosome, 0, 100, false, "g1", "g1", "");
        Transcript tr = new Transcript(g, 10, 100, false, "tr1");
        Exon e1 = new Exon(tr, 10, 30, false, "e1", 1);
        Exon e2 = new Exon(tr, 50, 80, false, "e2", 2);
        Exon e3 = new Exon(tr, 90, 100, false, "e3", 3);
        tr.add(e1);
        tr.add(e2);
        tr.add(e3);
        Assert.assertEquals(10, tr.getCdsStart());
        Assert.assertEquals(100, tr.getCdsEnd());
        if (this.verbose) {
            System.out.println("Transcript : " + tr);
        }
        if (this.verbose) {
            System.out.println("CDS.start: " + tr.getCdsStart() + "\tCDS.end: " + tr.getCdsEnd());
        }
    }

    @Test
    public void test_cdsStartEnd_2() {
        Gpr.debug("Test");
        Gene g = new Gene(this.chromosome, 10, 100, false, "g1", "g1", "");
        Transcript tr = new Transcript(g, 10, 100, false, "tr1");
        Exon e1 = new Exon(tr, 10, 30, false, "e1", 1);
        Exon e2 = new Exon(tr, 50, 80, false, "e2", 2);
        Exon e3 = new Exon(tr, 90, 100, false, "e3", 3);
        tr.add(e1);
        tr.add(e2);
        tr.add(e3);
        Utr5prime u1 = new Utr5prime(e1, 10, 30, false, "u1");
        Utr5prime u2 = new Utr5prime(e2, 50, 80, false, "u2");
        Utr5prime u3 = new Utr5prime(e3, 90, 100, false, "u3");
        tr.add(u1);
        tr.add(u2);
        tr.add(u3);
        Assert.assertEquals(10, tr.getCdsStart());
        Assert.assertEquals(10, tr.getCdsEnd());
        if (this.verbose) {
            System.out.println("Transcript : " + tr);
        }
        if (this.verbose) {
            System.out.println("CDS.start: " + tr.getCdsStart() + "\tCDS.end: " + tr.getCdsEnd());
        }
    }
}

