/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGff3;
import ca.mcgill.mcb.pcingola.util.Gpr;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesBuild {
    boolean verbose = false;

    @Test
    public void test_01_chromoNamesDoNotMatch_Gff() {
        Gpr.debug("Test");
        String genome = "testChromoNamesDoNotMatch";
        String gff = "tests/testChromoNamesDoNotMatch.genes.gff";
        String expectedError = "Error reading file 'tests/testChromoNamesDoNotMatch.genes.gff'\njava.lang.RuntimeException: FATAL ERROR: Most Exons do not have sequences!\nThere might be differences in the chromosome names used in the genes file ('tests/testChromoNamesDoNotMatch.genes.gff')\nand the chromosme names used in the 'reference sequence' file.\nPlease check that chromosome names in both files match.\n\tChromosome names missing in 'reference sequence' file:\t'1'\n\tChromosome names missing in 'genes' file             :\t'1ZZZ'\n";
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryGff3 sefGff = new SnpEffPredictorFactoryGff3(config);
        sefGff.setFileName(gff);
        sefGff.setVerbose(this.verbose);
        try {
            sefGff.create();
        }
        catch (Throwable t) {
            String errmsg = t.getMessage().substring(0, expectedError.length());
            if (this.verbose) {
                t.printStackTrace();
            }
            Assert.assertEquals(expectedError, errmsg);
            return;
        }
        throw new RuntimeException("Expected error not found!");
    }

    @Test
    public void test_02_chromoNamesDoNotMatch_GffFasta() {
        Gpr.debug("Test");
        String genome = "testChromoNamesDoNotMatch";
        String gff = "tests/testChromoNamesDoNotMatch.genes.no_fasta.gff";
        String fasta = "tests/testChromoNamesDoNotMatch.fa";
        String expectedError = "Error reading file 'tests/testChromoNamesDoNotMatch.genes.no_fasta.gff'\njava.lang.RuntimeException: FATAL ERROR: Most Exons do not have sequences!\nThere might be differences in the chromosome names used in the genes file ('tests/testChromoNamesDoNotMatch.genes.no_fasta.gff')\nand the chromosme names used in the 'reference sequence' file ('tests/testChromoNamesDoNotMatch.fa').\nPlease check that chromosome names in both files match.\n\tChromosome names missing in 'reference sequence' file:\t'1'\n\tChromosome names missing in 'genes' file             :\t'1ZZZ'\n";
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryGff3 sefGff = new SnpEffPredictorFactoryGff3(config);
        sefGff.setFileName(gff);
        sefGff.setFastaFile(fasta);
        sefGff.setVerbose(this.verbose);
        try {
            sefGff.create();
        }
        catch (Throwable t) {
            int len = Math.min(t.getMessage().length(), expectedError.length());
            String errmsg = t.getMessage().substring(0, len);
            if (this.verbose) {
                t.printStackTrace();
            }
            Assert.assertEquals(expectedError, errmsg);
            return;
        }
        throw new RuntimeException("Expected error not found!");
    }
}

