/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.unity;

import ca.mcgill.mcb.pcingola.binseq.GenomicSequences;
import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.Hgvs;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffects;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRand;
import ca.mcgill.mcb.pcingola.vcf.EffFormatVersion;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;

public class TestCasesBase {
    protected boolean debug;
    protected boolean verbose;
    protected boolean ignoreErrors;
    protected int randSeed;
    protected String genomeName;
    protected boolean addUtrs;
    protected boolean onlyPlusStrand;
    protected boolean onlyMinusStrand;
    protected boolean shiftHgvs;
    protected int maxGeneLen;
    protected int maxTranscripts;
    protected int maxExons;
    protected int minExons;
    protected int spliceRegionExonSize;
    protected int spliceRegionIntronMin;
    protected int spliceRegionIntronMax;
    protected Random rand;
    protected Config config;
    protected Genome genome;
    protected Chromosome chromosome;
    protected Gene gene;
    protected Transcript transcript;
    protected SnpEffectPredictor snpEffectPredictor;
    protected String chromoSequence;
    protected char[] chromoBases;
    protected CodonTable codonTable;

    public TestCasesBase() {
        this.verbose = this.debug = false;
        this.ignoreErrors = false;
        this.spliceRegionExonSize = 0;
        this.spliceRegionIntronMin = 0;
        this.spliceRegionIntronMax = 0;
        this.chromoSequence = "";
    }

    @After
    public void after() {
        this.config = null;
        this.codonTable = null;
        this.genome = null;
        this.chromosome = null;
        this.gene = null;
        this.transcript = null;
        this.snpEffectPredictor = null;
        this.chromoBases = null;
        this.chromoSequence = null;
    }

    @Before
    public void before() {
        this.init();
        this.initSnpEffPredictor();
    }

    protected void checkEffect(Variant variant, EffectType effectExpected) {
        this.checkEffect(variant, effectExpected, null, null);
    }

    protected void checkEffect(Variant variant, EffectType effectExpected, EffectType effectNotExpected, VariantEffect.EffectImpact impact) {
        VariantEffects effects = this.snpEffectPredictor.variantEffect(variant);
        boolean found = false;
        for (VariantEffect effect : effects) {
            String effStr = effect.getEffectTypeString(false);
            if (this.verbose) {
                System.out.println(effect.toStringSimple(true) + "\n\tEffect type: '" + effStr + "'\tExpected: '" + (Object)((Object)effectExpected) + "'");
            }
            found |= effect.hasEffectType(effectExpected);
            if (effectNotExpected != null && effect.hasEffectType(effectNotExpected)) {
                throw new RuntimeException("Effect '" + (Object)((Object)effectNotExpected) + "' should not be here");
            }
            if (impact == null || effect.getEffectImpact() == impact) continue;
            throw new RuntimeException("Effect '" + (Object)((Object)effectExpected) + "' should have impact '" + (Object)((Object)impact) + "', but impct was '" + (Object)((Object)effect.getEffectImpact()) + "'.");
        }
        Assert.assertTrue("Effect not found: '" + (Object)((Object)effectExpected) + "' in variant " + variant, found);
    }

    public void compareHgvs(String genome, String vcfFileName) {
        this.compareHgvs(genome, vcfFileName, true);
    }

    public void compareHgvs(String genome, String vcfFileName, boolean compareProt) {
        String[] args = new String[]{genome, vcfFileName};
        SnpEffCmdEff snpeff = new SnpEffCmdEff();
        snpeff.parseArgs(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        snpeff.setUpDownStreamLength(0);
        snpeff.setShiftHgvs(this.shiftHgvs);
        snpeff.setFormatVersion(EffFormatVersion.FORMAT_EFF_4);
        List<VcfEntry> results = snpeff.run(true);
        HashSet<String> trNotFoundSet = new HashSet<String>();
        int countOkC = 0;
        int countErrC = 0;
        int countOkP = 0;
        int countErrP = 0;
        int countTrFound = 0;
        for (VcfEntry ve : results) {
            String hgvsCexp = ve.getInfo("HGVS_C") != null ? ve.getInfo("HGVS_C") : "";
            String trIdC = Hgvs.parseTranscript(hgvsCexp);
            hgvsCexp = Hgvs.removeTranscript(hgvsCexp);
            String hgvsPexp = "";
            String trIdP = "";
            if (compareProt) {
                hgvsPexp = ve.getInfo("HGVS_P") != null ? ve.getInfo("HGVS_P") : "";
                trIdP = Hgvs.parseTranscript(hgvsPexp);
                hgvsPexp = Hgvs.removeTranscript(hgvsPexp);
            }
            if (this.verbose) {
                System.out.println(ve);
                if (trIdC != null) {
                    System.out.println("\tExpected HGVS_C: " + trIdC + ":" + hgvsCexp);
                }
                if (trIdP != null) {
                    System.out.println("\tExpected HGVS_P: " + trIdP + ":" + hgvsPexp + "\n");
                }
            }
            boolean okC = false;
            boolean okP = false;
            boolean trFound = false;
            for (VcfEffect veff : ve.parseEffects()) {
                String trId = veff.getTranscriptId();
                String hgvsCactual = veff.getHgvsDna() != null ? veff.getHgvsDna() : "";
                String hgvsPactual = veff.getHgvsProt() != null ? veff.getHgvsProt() : "";
                boolean foundC = false;
                boolean foundP = false;
                if (trId != null && trId.equals(trIdC)) {
                    trFound = true;
                    if (!hgvsCexp.equals(hgvsCactual)) {
                        if (!this.ignoreErrors) {
                            Assert.assertEquals(hgvsCexp, hgvsCactual);
                        }
                        ++countErrC;
                    } else {
                        foundC = true;
                        okC = true;
                        ++countOkC;
                    }
                }
                if (compareProt && trId != null && trId.equals(trIdP)) {
                    if (!hgvsPexp.equals(hgvsPactual)) {
                        if (!this.ignoreErrors) {
                            Assert.assertEquals(hgvsPexp, hgvsPactual);
                        }
                        ++countErrP;
                    } else {
                        foundP = true;
                        okP = true;
                        ++countOkP;
                    }
                }
                if (!this.verbose) continue;
                System.out.println("\t" + veff + "\n\t\tEFF    : " + veff.getEffectsStr() + "\n\t\tHGVS_C : " + trId + ":" + hgvsCactual + "\t\tExpected: " + trIdC + ":" + hgvsCexp + "\t" + (foundC ? "OK" : "NO") + (compareProt ? "\n\t\tHGVS_P : " + trId + ":" + hgvsPactual + "\t\tExpected: " + trIdP + ":" + hgvsPexp + "\t" + (foundP ? "OK" : "NO") : "") + "\n");
            }
            if (!trFound) {
                System.out.println("Transcript '" + trIdC + "' not found.");
                ++countTrFound;
                trNotFoundSet.add(trIdC);
            }
            if (!this.ignoreErrors) {
                Assert.assertTrue("HGVS (DNA) not found: '" + hgvsCexp + "'", okC);
                if (hgvsPexp.isEmpty()) continue;
                Assert.assertTrue("HGVS (Protein) not found: '" + hgvsPexp + "'", okP);
                continue;
            }
            if (!okC) {
                System.err.println("HGVS (DNA) not found : '" + hgvsCexp + "', vcf entry:\t" + ve);
            }
            if (!compareProt || okP) continue;
            System.err.println("HGVS (Prot) not found: '" + hgvsPexp + "', vcf entry:\t" + ve);
        }
        if (this.verbose || this.ignoreErrors) {
            System.out.println("Count OKs   :\tHGVS (DNA): " + countOkC + "\tHGVS (Protein): " + countOkP);
            System.out.println("Count Errors:\tHGVS (DNA): " + countErrC + "\tHGVS (Protein): " + countErrP);
            System.out.println("Transcripts not found:\t" + countTrFound + ", unique: " + trNotFoundSet.size() + "\n" + trNotFoundSet);
        }
    }

    protected EffFormatVersion formatVersion(String vcfFileName) {
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        VcfEntry ve = (VcfEntry)vcf.next();
        List<VcfEffect> effs = ve.parseEffects();
        if (effs.isEmpty()) {
            throw new RuntimeException("Empty list of effects. Tis should never happen!");
        }
        VcfEffect eff = effs.get(0);
        return eff.formatVersion();
    }

    protected boolean hasEffect(String effectExpected, String effStr) {
        for (String eff : effStr.split("&")) {
            if (!eff.equals(effectExpected)) continue;
            return true;
        }
        return false;
    }

    protected void init() {
        this.randSeed = 20141128;
        this.genomeName = "testCase";
        this.addUtrs = false;
        this.onlyPlusStrand = true;
        this.onlyMinusStrand = false;
        this.maxGeneLen = 1000;
        this.maxTranscripts = 1;
        this.maxExons = 5;
        this.minExons = 1;
        this.shiftHgvs = false;
        this.initRand();
    }

    protected void initRand() {
        this.rand = new Random(this.randSeed);
    }

    protected void initSnpEffPredictor() {
        if (this.config == null || this.config.getGenome() == null || !this.config.getGenome().getGenomeName().equals(this.genomeName)) {
            this.config = new Config(this.genomeName, "snpEff.config");
        }
        SnpEffPredictorFactoryRand sepf = new SnpEffPredictorFactoryRand(this.config, this.rand, this.maxGeneLen, this.maxTranscripts, this.maxExons);
        sepf.setForcePositiveStrand(this.onlyPlusStrand);
        sepf.setForceNegativeStrand(this.onlyMinusStrand);
        sepf.setAddUtrs(this.addUtrs);
        sepf.setMinExons(this.minExons);
        this.snpEffectPredictor = sepf.create();
        this.config.setSnpEffectPredictor(this.snpEffectPredictor);
        this.config.setShiftHgvs(this.shiftHgvs);
        this.snpEffectPredictor.setSpliceRegionExonSize(this.spliceRegionExonSize);
        this.snpEffectPredictor.setSpliceRegionIntronMin(this.spliceRegionIntronMin);
        this.snpEffectPredictor.setSpliceRegionIntronMax(this.spliceRegionIntronMax);
        this.snpEffectPredictor.setUpDownStreamLength(0);
        this.chromoSequence = sepf.getChromoSequence();
        this.chromoBases = this.chromoSequence.toCharArray();
        this.snpEffectPredictor.buildForest();
        this.chromosome = sepf.getChromo();
        this.genome = this.config.getGenome();
        this.codonTable = this.genome.codonTable();
        this.gene = this.genome.getGenes().iterator().next();
        this.transcript = (Transcript)this.gene.iterator().next();
        this.genome.getGenomicSequences().addGeneSequences(this.chromosome.getId(), this.chromoSequence);
    }

    protected void prependSequenceToFirstExon(String prepend) {
        Exon ex = (Exon)this.transcript.sortedStrand().get(0);
        String seq2 = ex.getSequence();
        ex.setSequence(prepend + seq2);
        this.transcript.resetCdsCache();
        this.chromoSequence = this.chromoSequence.substring(0, ex.getStart()) + ex.getSequence() + this.chromoSequence.substring(ex.getEnd() + 1);
        GenomicSequences gs = this.genome.getGenomicSequences();
        gs.reset();
        gs.addGeneSequences(this.chromosome.getId(), this.chromoSequence);
        gs.build();
    }
}

