/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr5prime;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.util.List;
import org.junit.Test;

public class TestCasesTranscript {
    boolean debug;
    boolean verbose;

    public TestCasesTranscript() {
        this.verbose = this.debug = false;
    }

    @Test
    public void test_mRnaSequence() {
        Gpr.debug("Test");
        String genome = "testHg3766Chr1";
        Config config = new Config(genome);
        this.verbose = true;
        if (this.verbose) {
            Timer.showStdErr("Loading genome " + genome);
        }
        SnpEffectPredictor sep = config.loadSnpEffectPredictor();
        if (this.verbose) {
            Timer.showStdErr("Building interval forest");
        }
        sep.buildForest();
        if (this.verbose) {
            Timer.showStdErr("Done");
        }
        int count2 = 1;
        for (Gene gene : sep.getGenome().getGenes()) {
            for (Transcript tr : gene) {
                if (!tr.isProteinCoding() || !tr.hasErrorOrWarning()) continue;
                String mRna = tr.mRna().toLowerCase();
                String cds = tr.cds().toLowerCase();
                List<Utr5prime> utrs5 = tr.get5primeUtrs();
                if (utrs5.size() <= 0) continue;
                Gpr.showMark(count2++, 1);
                Utr5prime utr5 = utrs5.get(0);
                String utr5Str = utr5.getSequence().toLowerCase();
                if (!mRna.startsWith(utr5Str)) {
                    throw new RuntimeException("ERROR mRna does not start with UTR5");
                }
                if (mRna.startsWith(utr5Str + cds)) continue;
                throw new RuntimeException("ERROR mRna does not start with  UTR+CDS");
            }
        }
    }
}

