/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class TestCasesSnp {
    boolean debug;
    boolean verbose;

    public TestCasesSnp() {
        this.verbose = this.debug = false;
    }

    @Test
    public void test_02_Start_NonSyn() {
        Gpr.debug("Test");
        String genome = "testHg19ChrM";
        String vcf = "tests/test_chrM_start_codon_nonSyn.vcf";
        String[] args = new String[]{"-noLog", "-classic", "-ud", "0", genome, vcf};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setSupressOutput(!this.verbose);
        snpEff.setDebug(this.debug);
        SnpEffCmdEff seff = (SnpEffCmdEff)snpEff.snpEffCmd();
        boolean checked = false;
        List<VcfEntry> vcfEntries = seff.run(true);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.parseEffects()) {
                if (this.verbose) {
                    System.out.println("\t\t" + veff);
                }
                if (veff.getEffectType() != EffectType.NON_SYNONYMOUS_START) continue;
                Assert.assertEquals((Object)VariantEffect.EffectImpact.LOW, (Object)veff.getImpact());
                checked = true;
            }
        }
        Assert.assertEquals(true, checked);
    }

    @Test
    public void test_02_StopGained_HighImpact() {
        Gpr.debug("Test");
        String genome = "testHg3775Chr2";
        String vcf = "tests/stop_gained_chr2.vcf";
        String[] args = new String[]{"-noLog", "-classic", genome, vcf};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setSupressOutput(!this.verbose);
        snpEff.setDebug(this.debug);
        SnpEffCmdEff seff = (SnpEffCmdEff)snpEff.snpEffCmd();
        boolean checked = false;
        List<VcfEntry> vcfEntries = seff.run(true);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.parseEffects()) {
                if (this.verbose) {
                    System.out.println("\t\t" + veff);
                }
                if (veff.getEffectType() != EffectType.STOP_GAINED) continue;
                Assert.assertEquals((Object)VariantEffect.EffectImpact.HIGH, (Object)veff.getImpact());
                checked = true;
            }
        }
        Assert.assertEquals(true, checked);
    }

    @Test
    public void test_03_Start_Loss() {
        Gpr.debug("Test");
        String genome = "testHg19ChrM";
        String vcf = "tests/test_chrM_start_codon.vcf";
        String[] args = new String[]{"-noLog", "-classic", "-ud", "0", genome, vcf};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setSupressOutput(!this.verbose);
        snpEff.setDebug(this.debug);
        SnpEffCmdEff seff = (SnpEffCmdEff)snpEff.snpEffCmd();
        boolean checked = false;
        List<VcfEntry> vcfEntries = seff.run(true);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.parseEffects()) {
                if (this.verbose) {
                    System.out.println("\t\t" + veff);
                }
                if (veff.getEffectType() != EffectType.START_LOST) continue;
                Assert.assertEquals((Object)VariantEffect.EffectImpact.HIGH, (Object)veff.getImpact());
                checked = true;
            }
        }
        Assert.assertEquals(true, checked);
    }
}

