/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Variant;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.LossOfFunction;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.HashSet;
import java.util.LinkedList;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Test;

public class TestCasesNmd {
    public static boolean debug = false;
    public static boolean verbose = false;
    public static int SHOW_EVERY = 10;
    Config config;
    int countTest = 1;

    @After
    public void after() {
        this.config = null;
    }

    void checkNmd(Gene gene, Transcript tr) {
        if (verbose) {
            System.err.print("\tTranscript " + tr.getId() + " " + (tr.isStrandPlus() ? (char)'+' : '-') + " :");
        } else {
            Gpr.showMark(this.countTest++, SHOW_EVERY);
        }
        int pos = 0;
        boolean[] isNmd = new boolean[tr.cds().length()];
        HashSet<Exon> codingExons = new HashSet<Exon>();
        StringBuilder nmdStr = new StringBuilder();
        StringBuilder nmdStrSimple = new StringBuilder();
        for (Exon exon : tr.sortedStrand()) {
            int from2;
            int step2 = exon.isStrandPlus() ? 1 : -1;
            for (int expos = from2 = exon.isStrandPlus() ? exon.getStart() : exon.getEnd(); exon.getStart() <= expos && expos <= exon.getEnd(); expos += step2) {
                if (!tr.isUtr(expos)) {
                    codingExons.add(exon);
                    Variant variant = new Variant((Marker)tr.getChromosome(), expos, "A", "C");
                    VariantEffect variantEffect = new VariantEffect(variant);
                    variantEffect.set(exon, EffectType.STOP_GAINED, EffectType.STOP_GAINED.effectImpact(), "");
                    LinkedList<VariantEffect> changeEffects = new LinkedList<VariantEffect>();
                    changeEffects.add(variantEffect);
                    LossOfFunction lof = new LossOfFunction(this.config, changeEffects);
                    isNmd[pos] = lof.isNmd();
                    nmdStr.append(isNmd[pos] ? (char)'+' : '.');
                    nmdStrSimple.append(isNmd[pos] ? (char)'+' : '.');
                    ++pos;
                    continue;
                }
                nmdStr.append('U');
            }
            nmdStr.append('\t');
            nmdStrSimple.append('\t');
        }
        if (verbose) {
            System.err.println(nmdStr);
        }
        if (debug) {
            System.err.println("\tCoding Exons:" + codingExons.size());
        }
        if (codingExons.size() > 1) {
            StringBuilder sb = new StringBuilder();
            String[] ex = nmdStrSimple.toString().split("\t");
            for (int i = 0; i < ex.length - 1; ++i) {
                sb.append(ex[i]);
            }
            String simpleNoLast = sb.toString();
            int lastNmd = Math.max(0, simpleNoLast.length() - 50);
            String points = simpleNoLast.substring(lastNmd) + ex[ex.length - 1];
            String plus2 = simpleNoLast.substring(0, lastNmd);
            if (debug) {
                System.err.println("\tPoints: " + points + "\n\tPlus :" + plus2);
            }
            Assert.assertEquals(0, points.replace('.', ' ').trim().length());
            Assert.assertEquals(0, plus2.replace('+', ' ').trim().length());
        }
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String genomeVer = "testHg3766Chr1";
        Gpr.debug("Loading database '" + genomeVer + "'");
        this.config = new Config(genomeVer, "snpEff.config");
        this.config.setTreatAllAsProteinCoding(true);
        this.config.loadSnpEffectPredictor();
        for (Gene gene : this.config.getGenome().getGenes()) {
            if (verbose) {
                System.err.println("NMD test\tGene ID:" + gene.getId());
            }
            for (Transcript tr : gene) {
                if (debug) {
                    System.err.println(tr);
                }
                this.checkNmd(gene, tr);
            }
        }
    }
}

