/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases.integration;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.snpEffect.EffectType;
import ca.mcgill.mcb.pcingola.snpEffect.VariantEffect;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TestCasesNextProt {
    public static boolean debug = false;
    public static boolean verbose = false;
    public static int SHOW_EVERY = 10;

    void checkNextProt(String genomeVer, String vcfFile, String effectDetails, VariantEffect.EffectImpact impact, boolean useAnn) {
        String[] args = new String[]{"-classic", "-nextProt", genomeVer, vcfFile};
        String[] argsAnn = new String[]{genomeVer, vcfFile};
        if (useAnn) {
            args = argsAnn;
        }
        SnpEff cmd = new SnpEff(args);
        cmd.setVerbose(verbose);
        cmd.setSupressOutput(!verbose);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.snpEffCmd();
        List<VcfEntry> vcfEntries = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        int numNextProt = 0;
        for (VcfEntry ve : vcfEntries) {
            for (VcfEffect veff : ve.parseEffects()) {
                if (veff.hasEffectType(EffectType.NEXT_PROT) && impact == veff.getImpact()) {
                    boolean match = false;
                    if (!useAnn && effectDetails.equals(veff.getEffectDetails())) {
                        match = true;
                    }
                    if (useAnn && effectDetails.equals(veff.getFeatureType())) {
                        match = true;
                    }
                    if (match) {
                        ++numNextProt;
                    }
                }
                if (!verbose) continue;
                System.out.println("\t" + veff + "\n\t\tEffect            : " + veff.getVcfFieldString() + "\n\t\tEffect type       : " + (Object)((Object)veff.getEffectType()) + "\n\t\tEffect details    : '" + veff.getEffectDetails() + "'" + "\n\t\tEffect impact     : '" + (Object)((Object)veff.getImpact()) + "'" + "\n\t\tExpected details  : '" + effectDetails + "'" + "\n\t\tExpected impact   : '" + (Object)((Object)impact) + "'" + "\n\t\tCount matches     : " + numNextProt + "\thasEffectType : " + veff.hasEffectType(EffectType.NEXT_PROT) + "\tmatch details : " + effectDetails.equals(veff.getEffectDetails()) + "\tmatch impact: " + (impact == veff.getImpact()));
            }
        }
        Assert.assertEquals(1L, numNextProt);
    }

    @Test
    public void test_01_build() {
        Gpr.debug("Test");
        String[] args = new String[]{"buildNextProt", "testHg3770Chr22", "tests/nextProt"};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(verbose);
        snpEff.setSupressOutput(!verbose);
        boolean ok = snpEff.run();
        Assert.assertEquals(true, ok);
    }

    @Test
    public void test_02_ann() {
        Gpr.debug("Test");
        this.checkNextProt("testHg3770Chr22", "tests/test_nextProt_02.vcf", "amino_acid_modification:N-acetylglycine", VariantEffect.EffectImpact.LOW, true);
    }

    @Test
    public void test_02_eff() {
        Gpr.debug("Test");
        this.checkNextProt("testHg3770Chr22", "tests/test_nextProt_02.vcf", "amino_acid_modification:N-acetylglycine", VariantEffect.EffectImpact.LOW, false);
    }

    @Test
    public void test_03_ann() {
        Gpr.debug("Test");
        this.checkNextProt("testHg3770Chr22", "tests/test_nextProt_03.vcf", "amino_acid_modification:Phosphoserine", VariantEffect.EffectImpact.MODERATE, true);
    }

    @Test
    public void test_03_eff() {
        Gpr.debug("Test");
        this.checkNextProt("testHg3770Chr22", "tests/test_nextProt_03.vcf", "amino_acid_modification:Phosphoserine", VariantEffect.EffectImpact.MODERATE, false);
    }

    @Test
    public void test_04_parse() {
        Gpr.debug("Test");
        String vcfFile = "tests/test.nextProt_paren.vcf";
        int count2 = 0;
        for (VcfEntry ve : new VcfFileIterator(vcfFile)) {
            for (VcfEffect eff : ve.parseEffects()) {
                if (verbose) {
                    System.out.println(eff);
                }
                if (!eff.hasEffectType(EffectType.NEXT_PROT)) continue;
                ++count2;
            }
        }
        if (verbose) {
            System.out.println("Count: " + count2);
        }
        Assert.assertTrue(count2 > 0);
    }
}

